<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bonificacion extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("mes_model");
    $this->load->model("bonificado_model");
  }

  public function index()
  {
    $anua=$this->input->post('canuo',true)!=null ? $this->input->post('canuo',true) : date("Y");
    $anuos=$this->periodo_model->mostrarTotal();
    $listas=$this->bonificado_model->mostrarLimite($this->session->userdata("predeterminado"),$anua);
    $this->layout->setTitle("Producto Bonificados");
    $this->layout->view("index",compact("anua","anuos","listas"));
  }

  public function busBonificacion()
  {
    if ($this->input->post())
    {
      $datos=$this->bonificado_model->contador(array("anuo"=>$this->input->post("a",true),"mes"=>$this->input->post("m",true)));
      echo json_encode($datos);
    }
    else
    {
      show_404();
    }
  }

  public function bonificacioni($year=null,$month=null)
  {
    if ($this->input->post())
    {
      if ($this->input->post("idproducto",true)==null) {
        $this->session->set_flashdata("css", "danger");
        $this->session->set_flashdata("mensaje", "No envio productos en la solicitud compra!");
      } else {
        for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
          $datad=array
          (
            "iduser"            =>$this->session->userdata('id'),
            "anuo"              =>$this->input->post("canuo",true),
            "mes"               =>$this->input->post("cmes",true),
            "idproducto"        =>$this->input->post("idproducto",true)[$i],
            "descripcion"       =>$this->input->post("descripcion",true)[$i],
            "monto"             =>$this->input->post("monto",true)[$i],
          );
          $insertard=$this->bonificado_model->insert($datad);
        }

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
      }
      redirect(base_url()."bonificacion/bonificacioni/".$this->input->post("canuo",true)."/".$this->input->post("cmes",true));
    }

    $anuos=$this->periodo_model->mostrarTotal();
    $meses=$this->mes_model->mostrarTotal();
    $productos=$this->producto_model->mostrarLimite(array("estado"=>1));
    $datos=$this->mes_model->mostrar($month);
    $listas=$this->bonificado_model->mostrarTotal(array("anuo"=>$year,"mes"=>$month));
    $this->layout->setLayout("contraido");
    $this->layout->setTitle("Producto Bonificados");
    $this->layout->view("bonificacioni",compact("anuos","meses","productos","datos","listas","year","month"));
  }

  public function bonificacionc($year,$month)
  {
    if ($this->input->post())
    {
      if ($this->input->post("idproducto",true)==null) {
        $this->session->set_flashdata("css", "danger");
        $this->session->set_flashdata("mensaje", "No envio productos en la solicitud compra!");
      } else {
        for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
          $datad=array
          (
            "iduser"            =>$this->session->userdata('id'),
            "anuo"              =>$this->input->post("canuo",true),
            "mes"               =>$this->input->post("cmes",true),
            "idproducto"        =>$this->input->post("idproducto",true)[$i],
            "descripcion"       =>$this->input->post("descripcion",true)[$i],
            "monto"             =>$this->input->post("monto",true)[$i],
          );
          $insertard=$this->bonificado_model->insert($datad);
        }

        $this->session->set_flashdata("css", "success");
        $this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
      }
      redirect(base_url()."bonificacion/bonificacioni/".$this->input->post("canuo",true)."/".$this->input->post("cmes",true));
    }

    $anuos=$this->periodo_model->mostrarTotal();
    $meses=$this->mes_model->mostrarTotal();
    $productos=$this->producto_model->mostrarLimite(array("estado"=>1));
    $datos=$this->mes_model->mostrar($month);
    $listas=$this->bonificado_model->mostrarTotal(array("anuo"=>$year,"mes"=>$month));
    $this->layout->setLayout("contraido");
    $this->layout->setTitle("Producto Bonificados");
    $this->layout->view("bonificacionc",compact("anuos","meses","productos","datos","listas","year","month"));
  }

  public function bonificaciond($id)
  {
    if (!$id) {show_404();}
    $datos=$this->bonificado_model->mostrar(array("id"=>$id));
    if ($datos==NULL) {show_404();}
    $eliminar=$this->bonificado_model->delete($id);

    $this->session->set_flashdata("css", "danger");
    $this->session->set_flashdata("mensaje", "Los datos fueron eliminados exitosamente!");
    redirect(base_url()."bonificacion/bonificacioni/".$datos->anuo."/".$datos->mes);
  }



}
