<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cliente extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("tidentidad_model");
		$this->load->model("departamento_model");
		$this->load->model("provincia_model");
		$this->load->model("distrito_model");
		$this->load->model("cliente_model");
		$this->load->model("nventa_model");
		$this->load->model("venta_model");
		$this->load->model("punto_model");
		$this->load->model("clientep_model");
		$this->load->model("vale_model");
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$listas=$this->cliente_model->mostrarTotal();
		$this->layout->setTitle("Cliente");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","listas"));
	}

	public function busCliente()
	{
		if ($this->input->post())
		{
			$datos=array();
			if (strlen($this->input->post('id',true))>2) {
				$clientes=$this->cliente_model->buscador($this->input->post('id',true));
			} else {
				$clientes=$this->cliente_model->mostrarLimite();
			}

			foreach ($clientes as $cliente) {
				$tpuntos=$this->clientep_model->cantidadTotal($cliente->id);
				$puntos=$tpuntos->cantidad==null ? 0 : $tpuntos->cantidad ;

				$detalle['id']=$cliente->id;
				$detalle['tdocumento']=$cliente->tdocumento;
				$detalle['documento']=$cliente->documento;
				$detalle['nombres']=$cliente->nombres;
				$detalle['puntos']='Puntos Acumulados : '.$puntos;
				array_push($datos,$detalle);
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

  public function busDocumento()
  {
    if ($this->input->post())
    {
      $datos=$this->cliente_model->mostrar(array("documento"=>$this->input->post('id',true)));
      if ($datos!=NULL) {
				$tpuntos=$this->clientep_model->cantidadTotal($datos->id);
				$puntos=$tpuntos->cantidad==null ? 0 : $tpuntos->cantidad ;

				$datos->puntos='Puntos Acumulados : '.$puntos;
      }
      echo json_encode($datos);
    }
    else
    {
      show_404();
    }
  }

	public function busDatos()
	{
		if ($this->input->post())
		{
			$tipo=$this->input->post('tipo',true);
			$numero=$this->input->post('numero',true);

      if ($tipo==1) {
				$ruta="https://api.apis.net.pe/v1/dni?numero=".$numero;
			}else{
				$ruta="https://api.apis.net.pe/v1/ruc?numero=".$numero;
			}

			$curl = curl_init();
			curl_setopt_array($curl, array(
			  // para user api versión 1
			  CURLOPT_URL => $ruta,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_SSL_VERIFYPEER => 0,
			  CURLOPT_ENCODING => '',
			  CURLOPT_MAXREDIRS => 2,
			  CURLOPT_TIMEOUT => 0,
			  CURLOPT_FOLLOWLOCATION => true,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => 'GET',
			));
			$response = curl_exec($curl);
			curl_close($curl);
			echo $response;
		}
		else
		{
			show_404();
		}
	}

	public function clientei($id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array
				(
					"tdocumento"			=>$this->input->post("tipo",true),
					"documento"				=>$this->input->post("documento",true),
					"nombres"					=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
					"iddepartamento"	=>$this->input->post("departamento",true),
					"idprovincia"			=>$this->input->post("provincia",true),
					"iddistrito"			=>$this->input->post("distrito",true),
					"direccion"				=>$this->input->post("direccion",true),
					"telefono"				=>$this->input->post("telefono",true),
					"email"						=>$this->input->post("email",true),
				);

				$guardar=$this->cliente_model->update($data,$id);
				$this->session->set_flashdata("css", "success");
				$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			} else {
				$consulta= $this->input->post("tipo",true)==0 ? 0: $this->cliente_model->contador($this->input->post("documento",true));
				if ($consulta==0) {
					if ($this->input->post("tipo",true)==1 && strlen($this->input->post("documento",true))==8 || $this->input->post("tipo",true)==6 && strlen($this->input->post("documento",true))==11 || $this->input->post("tipo",true)==4 || $this->input->post("tipo",true)==7 || $this->input->post("tipo",true)==0) {
						$data=array
						(
							"tdocumento"			=>$this->input->post("tipo",true),
							"documento"				=>$this->input->post("documento",true),
							"nombres"					=>trim(mb_strtoupper($this->input->post('nombres',true), 'UTF-8')),
							"idpais"					=>"PE",
							"iddepartamento"	=>$this->input->post("departamento",true),
							"idprovincia"			=>$this->input->post("provincia",true),
							"iddistrito"			=>$this->input->post("distrito",true),
							"direccion"				=>$this->input->post("direccion",true),
							"telefono"				=>$this->input->post("telefono",true),
							"email"						=>$this->input->post("email",true),
						);

						$insertar=$this->cliente_model->insert($data);
						$this->session->set_flashdata("css", "success");
						$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
					} else {
						$this->session->set_flashdata("css", "danger");
						$this->session->set_flashdata("mensaje", "El numero de documento en incoherente con el tipo de documento");
					}
				} else {
					$this->session->set_flashdata("css", "danger");
					$this->session->set_flashdata("mensaje", "El cliente ya EXISTE!!!!!!");
				}
			}
			echo base_url()."cliente";
			exit();
		}

		$datos=$id!=null?$this->cliente_model->mostrar(array("c.id"=>$id)):(object) array("tdocumento"=>1, "nombres"=>"", "documento"=>"", "iddepartamento"=>"", "idprovincia"=>"", "iddistrito"=>"", "direccion"=>"", "telefono"=>"", "email"=>"");
		$departamentos=$this->departamento_model->mostrarTotal();
		$provincias=$id!=null?$this->provincia_model->mostrarTotal($datos->iddepartamento):null;
		$distritos=$id!=null?$this->distrito_model->mostrarTotal($datos->idprovincia):null;
		$identidades=$this->tidentidad_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("clientei",compact("datos","departamentos","provincias","distritos","identidades"));
	}

	public function cliented($id)
	{
		if (!$id) {show_404();}
		$datos=$this->cliente_model->mostrar(array("c.id"=>$id));
		if ($datos==NULL) {show_404();}

		$contadorn=$this->nventa_model->contador(array('idcliente'=>$id));
		$contadorv=$this->venta_model->contador(array('idcliente'=>$id));
		$contador=$contadorn+$contadorv;
		if ($contador>0) {
			echo 'no borrado';
		}else{
			$eliminar=$this->cliente_model->delete($id);
			echo 'borrado';
		}
	}

	public function busVale()
	{
		$codigo=$this->input->post("id",true);
		$datos=$this->vale_model->mostrar(array("concat(id,'&',femision,'&',dni)"=>$codigo,"estado"=>1));
		if ($datos==null) {
			$resultado['importe']=0;
			$resultado['mensaje']='El codigo de vale no existe activo';
			$resultado['tipo']=1;
		} else {
			$resultado['importe']=$datos->importe;
			$resultado['mensaje']='El codigo de vale si existe';
			$resultado['tipo']=2;
		}
		echo json_encode($resultado);
	}

	public function pacumulados($id)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$datos=$this->cliente_model->mostrar(array("c.id"=>$id));
		$listas=$this->clientep_model->mostrarTotal($id);
		$vcanje=$this->punto_model->mostrar();
		$vales=$this->vale_model->mostrarTotal($datos->documento);
		$this->layout->setTitle("Puntos Acumulados");
		$this->layout->view("pacumulados",compact("establecimientos","nestablecimiento","listas","datos","vcanje","vales","id"));
	}

	public function canjerv($id)
	{
		$valor_canje=$this->punto_model->mostrar();
		if ($valor_canje->canjep>0 && $valor_canje->canjev>0) {
			$listas=$this->clientep_model->mostrarCliente($id);

			$cantidad=$valor_canje->canjep;
			foreach ($listas as $lista) {
				if ($cantidad>0) {
					$ncantidad=$cantidad-$lista->cantidad;	//nueva cantidad
					$saldoc=$lista->cantidad-$cantidad;

					if ($saldoc>0) {
						$datac=array('cantidad'=>$saldoc);
						$actualizar=$this->clientep_model->update($datac,array("id"=>$lista->id));
					} else {
						$eliminar=$this->clientep_model->delete(array("id"=>$lista->id));
					}

					$cantidad=$ncantidad;
				}else{
					break;
				}
			}

			$datos=$this->cliente_model->mostrar(array("c.id"=>$id));
			$data=array
			(
				"femision"	=>date("Y-m-d"),
				"dni"				=>$datos->documento,
				"importe"		=>$valor_canje->canjev,
				"estado"		=>1,
			);

			$insertar=$this->vale_model->insert($data);
			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "El vale se ha generado exitosamente!");

			echo "<script>window.open('".base_url()."cliente/pdfcanje/".$insertar."','_blank'); location.href ='".base_url()."cliente/pacumulados/".$id."'; </script>";
		} else {
			$this->session->set_flashdata('css', 'danger');
			$this->session->set_flashdata('mensaje', 'Tiene que configurar los montos de canje');
		}
	}

	public function pdfcanje($id)
  {
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->vale_model->mostrar(array("id"=>$id));
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfcanje",compact("empresa","datos"));
  }


}
