<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cotizacion extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('login')){redirect(base_url().'login');}
		$this->layout->setLayout('contraido');
		$this->load->model("cliente_model");
		$this->load->model('cotizacion_model');
		$this->load->model('cotizaciond_model');
		$this->load->library("mytcpdf");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post("inicio",true)!=null ? $this->input->post("inicio",true) : SumarFecha("-15 day",date("Y-m-d")) ;
		$fin=$this->input->post("fin",true)!=null ? $this->input->post("fin",true) : date("Y-m-d") ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->cotizacion_model->mostrarTotal($filtros);
		$this->layout->setTitle("Cotizacion Venta");
		$this->layout->view("index",compact("establecimientos","nestablecimiento","empresa","listas","inicio","fin"));
	}

	public function busCliente()
	{
		if ($this->input->post())
		{
			if (strlen($this->input->post('id',true))>2) {
				$datos=$this->cliente_model->buscador($this->input->post('id',true));
			} else {
				$datos=$this->cliente_model->mostrarLimite();
			}
			echo json_encode($datos);
		}
		else
		{
			show_404();
		}
	}

	public function cotizacioni()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		if ($this->input->post())
		{
			if ($this->input->post("idproducto",true)==null) {
				$this->session->set_flashdata("css", "danger");
				$this->session->set_flashdata("mensaje", "No envio productos en la cotizacion venta!");
			} else {
				$data=array
				(
					"idestablecimiento"	=>$this->session->userdata("predeterminado"),
					"iduser"						=>$this->session->userdata('id'),
					"tipo"							=>"S",
					"femision"					=>date("Y-m-d"),
					"idcliente"					=>$this->input->post("idcliente",true),
					"cliente"						=>$this->input->post("cliente",true),
					"tvalidez"					=>$this->input->post("tvalidez",true),
					"tentrega"					=>$this->input->post("tentrega",true),
					'total'							=>$this->input->post('totalg',true),
					"estado"						=>1,
				);
				$insertar=$this->cotizacion_model->insert($data);

				for ($i=0; $i < count($this->input->post("idproducto",true)) ; $i++) {
					$datad=array
					(
						"idcotizacion"		=>$insertar,
						"idproducto"	=>$this->input->post("idproducto",true)[$i],
						"descripcion"	=>trim($this->input->post("descripcion",true)[$i]),
						"unidad"			=>$this->input->post("unidad",true)[$i],
						"factor"			=>$this->input->post("factor",true)[$i],
						"cantidad"		=>$this->input->post("cantidad",true)[$i],
						"precio"			=>$this->input->post("precio",true)[$i],
						"importe"			=>$this->input->post("importe",true)[$i],
					);
					$insertard=$this->cotizaciond_model->insert($datad);
				}

				$this->session->set_flashdata("css", "success");
				$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
			}
			redirect(base_url()."cotizacion");
		}

		$empresa=$this->empresa_model->mostrar();
		$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
		$this->layout->setTitle("Cotizacion Venta");
		$this->layout->view("cotizacioni",compact("establecimientos","nestablecimiento","empresa","productos"));
	}

	public function cotizaciona($id)
	{
		$datos=$this->cotizacion_model->mostrar($id);
		$data=array("estado"=>3);
		$actualiza=$this->cotizacion_model->update($data,array("id"=>$id));
		echo "borrado";
	}

	public function opciones($id)
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("opciones",compact("id"));
	}

	public function pdfa4($id)
 {
 		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa4",compact("empresa","nestablecimiento","datos","detalles","cliente","id","nombre"));
	}

	public function pdf80($id)
 {
 		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf80",compact("empresa","nestablecimiento","datos","detalles","cliente","id","nombre"));
	}

	public function pdf58($id)
 {
 		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf58",compact("empresa","nestablecimiento","datos","detalles","cliente","id","nombre"));
	}

	public function pdfa5($id)
 {
 		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa5",compact("empresa","nestablecimiento","datos","detalles","cliente","id","nombre"));
	}





}
