<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Despacho extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata('login')){redirect(base_url().'login');}
    $this->layout->setLayout('principal');
    $this->load->model("testado_model");
    $this->load->model('serie_model');
    $this->load->model('ttransporte_model');
    $this->load->model('ttraslado_model');
    $this->load->model('departamento_model');
    $this->load->model('provincia_model');
    $this->load->model('distrito_model');
    $this->load->model('tidentidad_model');
    $this->load->model('cliente_model');
    $this->load->model('transporte_model');
    $this->load->model('venta_model');
    $this->load->model('ventad_model');
    $this->load->model('traslado_model');
    $this->load->model('trasladod_model');
    $this->load->model('despacho_model');
    $this->load->model('despachod_model');

    $this->load->library("mytcpdf");
    $this->load->library("generadorXML");
    $this->load->library("firmarXML");
    $this->load->library("apiFacturacion");
    $this->generadoXML = new GeneradorXML();
    $this->firmadoXML = new FirmarXML();
    $this->apiFacturacion = new ApiFacturacion();
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
    $fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

    if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
    $listas=$this->despacho_model->mostrarTotal($filtros,"desc");
    $this->layout->setLayout('contraido');
    $this->layout->setTitle('Guia de Remision');
    $this->layout->view('index',compact("establecimientos","nestablecimiento",'listas','inicio','fin','empresa'));
  }

  public function despachov($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'09'));
    $modost=$this->ttransporte_model->mostrarTotal();
    $motivost=$this->ttraslado_model->mostrarTotal();
    $didentidades=$this->tidentidad_model->mostrarTotal();
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal($nestablecimiento->iddepartamento);
    $distritos=$this->distrito_model->mostrarTotal($nestablecimiento->idprovincia);

    $venta=$this->venta_model->mostrar($id);
    $detalles=$this->ventad_model->mostrarTotal($id);
    $clientes=$this->cliente_model->mostrar(array("c.id"=>$venta->idcliente));
    $dprovincias=$this->provincia_model->mostrarTotal($clientes->iddepartamento);
    $ddistritos=$this->distrito_model->mostrarTotal($clientes->idprovincia);
    $conductores=$this->transporte_model->mostrarTotal('02');
    $transportistas=$this->transporte_model->mostrarTotal('01');
    $this->layout->setTitle('Guia de Remision');
    $this->layout->view('despachov',compact("establecimientos","nestablecimiento","nserie","clientes","modost","motivost","departamentos","provincias","distritos","didentidades","empresa","venta","detalles","dprovincias","ddistritos","conductores","transportistas"));
  }

  public function despachot($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'09'));
    $modost=$this->ttransporte_model->mostrarTotal();
    $motivost=$this->ttraslado_model->mostrar('04');
    $didentidades=$this->tidentidad_model->mostrarTotal();
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal($nestablecimiento->iddepartamento);
    $distritos=$this->distrito_model->mostrarTotal($nestablecimiento->idprovincia);

    $traslado=$this->traslado_model->mostrar($id);
    $detalles=$this->trasladod_model->mostrarTotal($id);
    $destino=$this->establecimiento_model->mostrar($traslado->idestablecimientod);
    $dprovincias=$this->provincia_model->mostrarTotal($destino->iddepartamento);
    $ddistritos=$this->distrito_model->mostrarTotal($destino->idprovincia);
    $conductores=$this->transporte_model->mostrarTotal('02');
    $transportistas=$this->transporte_model->mostrarTotal('01');
    $this->layout->setTitle('Guia de Remision');
    $this->layout->view('despachot',compact("establecimientos","nestablecimiento","nserie","modost","motivost","departamentos","provincias","distritos","didentidades","empresa","destino","traslado","detalles","dprovincias","ddistritos","conductores","transportistas","id"));
  }

  public function despachoi()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $empresa=$this->empresa_model->mostrar();
    $nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'09'));
    $modost=$this->ttransporte_model->mostrarTotal();
    $motivost=$this->ttraslado_model->mostrarTotal();
    $didentidades=$this->tidentidad_model->mostrarTotal();
    $departamentos=$this->departamento_model->mostrarTotal();
    $provincias=$this->provincia_model->mostrarTotal($nestablecimiento->iddepartamento);
    $distritos=$this->distrito_model->mostrarTotal($nestablecimiento->idprovincia);
    $conductores=$this->transporte_model->mostrarTotal('02');
    $transportistas=$this->transporte_model->mostrarTotal('01');
    $this->layout->setTitle('Guia de Remision');
    $this->layout->view('despachoi',compact("establecimientos","nestablecimiento","nserie","modost","motivost","departamentos","provincias","distritos","didentidades","empresa","conductores","transportistas"));
  }

  public function guardar($id=NULL)
  {
    if ($this->input->post())
    {
      if ($this->input->post('idproducto',true)==null) {
        $this->session->set_flashdata('css', 'danger');
        $this->session->set_flashdata('mensaje', 'No envio productos en la venta!');
      } else {
        $empresa=$this->empresa_model->mostrar();
        $numero=$this->despacho_model->maximo($this->input->post('serie',true));
        $ninicio= $numero==null ? '' : $numero->numero;
        $numeracion=$ninicio+1;

        $comprobante=array
        (
          'idestablecimiento'   =>$this->session->userdata("predeterminado"),
          'iduser'              =>$this->session->userdata('id'),
          'femision'            =>date('Y-m-d'),
          'hemision'            =>date('H:i:s'),
          'tcomprobante'        =>'09',
          'serie'               =>$this->input->post('serie',true),
          'numero'              =>$numeracion,
          'idcliente'           =>$this->input->post('idcliente',true),
          'cliente'             =>$this->input->post('cliente',true),
          'observaciones'       =>$this->input->post('observaciones',true),
          'idttransporte'       =>$this->input->post('modot',true),
          'idttraslado'         =>$this->input->post('motivot',true),
          'descripcion_traslado'=>$this->input->post('descripciont',true),
          'fenvio'              =>$this->input->post('fenvio',true),
          'unidad_peso'         =>"KGM",
          'peso_total'          =>$this->input->post('peso_total',true),
          'paquetes'            =>$this->input->post('paquetes',true),
          'codigo_origen'       =>$this->input->post('codigop',true),
          'ubigeo_origen'       =>$this->input->post('distritop',true),
          'direccion_origen'    =>$this->input->post('direccionp',true),
          'codigo_entrega'      =>$this->input->post('codigoe',true),
          'ubigeo_entrega'      =>$this->input->post('distritoe',true),
          'direccion_entrega'   =>$this->input->post('direccione',true),
          'tipo_estado'         =>'01',
        );

        if ($this->input->post('modot',true)=='01') {
          $comprobante['tdocumento_transporte']=$this->input->post('documentot',true);
          $comprobante['ndocumento_transporte']=$this->input->post('ndocumentot',true);
          $comprobante['nombres_transporte']   =$this->input->post('nombrest',true);
        } else {
          $comprobante['tdocumento_transporte']       =$this->input->post('documentoc',true);
          $comprobante['ndocumento_transporte']       =$this->input->post('ndocumentoc',true);
          $comprobante['nombres_transporte']          =$this->input->post('nombresc',true);
          $comprobante['licencia_conducir']       =$this->input->post('licencia',true);
          $comprobante['placa']                   =$this->input->post('placa',true);
        }
        $insertar=$this->despacho_model->insert($comprobante);

        for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
          $itemx=array
          (
            'iddespacho'  =>$insertar,
            'idproducto'  =>$this->input->post('idproducto',true)[$i],
            'descripcion' =>trim($this->input->post('descripcion',true)[$i]),
            'unidad'      =>$this->input->post("unidad",true)[$i],
            'cantidad'    =>$this->input->post('cantidad',true)[$i],
            'lote'        =>$this->input->post('lote',true)[$i],
            'fvencimiento'=>$this->input->post('fvencimiento',true)[$i],
          );
          $insertard=$this->despachod_model->insert($itemx);
        }

        $nombrexml = $empresa->ruc.'-'.$comprobante['tcomprobante'].'-'.$comprobante['serie'].'-'.$comprobante['numero'];
        $mensaje=$this->generadogXml($insertar);

        self::pdfguia($insertar);
        echo "<script>window.open('".base_url()."downloads/pdf/".$nombrexml.".pdf','_blank');</script>";
      }
      echo "<script>location.href ='".base_url()."despacho'; </script>";
    }
  }

  public function pdfguia($id)
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->despacho_model->mostrar($id);
    $clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
    $detalles=$this->despachod_model->mostrarTotal($id);
    $pdepartamentos=$this->departamento_model->mostrar(substr($datos->ubigeo_origen,0,2));
    $pprovincias=$this->provincia_model->mostrar(substr($datos->ubigeo_origen,0,4));
    $pdistritos=$this->distrito_model->mostrar($datos->ubigeo_origen);
    $edepartamentos=$this->departamento_model->mostrar(substr($datos->ubigeo_entrega,0,2));
    $eprovincias=$this->provincia_model->mostrar(substr($datos->ubigeo_entrega,0,4));
    $edistritos=$this->distrito_model->mostrar($datos->ubigeo_entrega);
    $this->layout->setLayout("blanco");
    $this->layout->view("pdfguia",compact("empresa","nestablecimiento","datos","clientes","detalles","pdepartamentos","pprovincias","pdistritos","edepartamentos","eprovincias","edistritos"));
  }

  public function emisor()
  {
    $empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $datos=array
    (
      'ruc'           =>$empresa->ruc,
      'nombres'       =>$empresa->nombres,
      'ncomercial'    =>$empresa->ncomercial,
      'codigo'        =>$nestablecimiento->codigo,
      'ndepartamento' =>$nestablecimiento->ndepartamento,
      'nprovincia'    =>$nestablecimiento->nprovincia,
      'ndistrito'     =>$nestablecimiento->ndistrito,
      'distrito'      =>$nestablecimiento->iddistrito,
      'direccion'     =>$nestablecimiento->direccion,
    );
    return $datos;
  }

  public function itemsGuia($id)
  {
    $detalles=$this->despachod_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $itemx=array
      (
        'iddespacho'      =>$id,
        'idproducto'      =>$detalle->idproducto,
        'descripcion'     =>$detalle->descripcion,
        'unidad'          =>$detalle->unidad,
        'cantidad'        =>$detalle->cantidad,
      );
      $datos[]=$itemx;
    }
    return $datos;
  }

  public function generadogXml($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->despacho_model->mostrar($id);
    $comprobante=array
    (
      'femision'              =>$datos->femision,
      'hemision'              =>$datos->hemision,
      'tcomprobante'          =>$datos->tcomprobante,
      'serie'                 =>$datos->serie,
      'numero'                =>$datos->numero,
      'codigo_motivo_traslado'=>$datos->idttraslado,
      'motivo_traslado'       =>$datos->descripcion_traslado,
      'unidad_peso'           =>$datos->unidad_peso,
      'peso'                  =>$datos->peso_total,
      'paquetes'              =>$datos->paquetes,
      'modo_transporte'       =>$datos->idttransporte,
      'fecha_envio'           =>$datos->fenvio,
      'destino_codigo'        =>$datos->codigo_entrega,
      'destino_ubigeo'        =>$datos->ubigeo_entrega,
      'destino_direccion'     =>$datos->direccion_entrega,
      'partida_codigo'        =>$datos->codigo_origen,
      'partida_ubigeo'        =>$datos->ubigeo_origen,
      'partida_direccion'     =>$datos->direccion_origen,
      'observaciones'         =>$datos->observaciones,
    );

    if ($datos->idttransporte=='01') {
      $comprobante['transportista_tipo_doc']=$datos->tdocumento_transporte;
      $comprobante['transportista_nro_doc']=$datos->ndocumento_transporte;
      $comprobante['transportista_nombres']=$datos->nombres_transporte;
    } else {
      $comprobante['conductor_tipo_doc']=$datos->tdocumento_transporte;
      $comprobante['conductor_nro_doc']=$datos->ndocumento_transporte;
      $comprobante['conductor_nombres']=$datos->nombres_transporte;
      $comprobante['conductor_licencia']=$datos->licencia_conducir;
      $comprobante['placa_vehiculo']=str_replace('-','',$datos->placa);
    }

    $nombrexml = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $ruta_xml = "downloads/xml/".$nombrexml;
    $emisor=$this->emisor();
    $cliente=(object) array();
    if ($datos->idcliente>0) {
      $cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
    } else {
      $cliente->documento=$empresa->ruc;
      $cliente->nombres=$empresa->nombres;
    }
    $detalle=$this->itemsGuia($id);
    $this->generadoXML->CrearXMLGuia($ruta_xml, $emisor, $cliente, $comprobante, $detalle);
    $ruta_certificado = "downloads/certificado/".$empresa->certificado;
    $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);

    $datav=array(
      'filename'  =>$nombrexml,
      //'hash'      =>$hash,
      'has_xml'   =>1,
      'has_pdf'   =>1,
    );
    $actualizar=$this->despacho_model->update($datav,$id);
    return 'Se genero comprobante '.$datos->serie.'-'.$datos->numero;
  }

  public function consulta($id)
  {
    $datos=$this->despacho_model->mostrar($id);
    $detalles=$this->despachod_model->mostrarTotal($id);
    $this->layout->setLayout("blanco");
    $this->layout->view("consulta",compact("datos","detalles"));
  }




}
