<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Inicio extends CI_Controller 
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("contraido");
		$this->load->model("compra_model");
		$this->load->model("nventa_model");
		$this->load->model("venta_model");
		$this->load->model("nota_model");
		$this->load->model("resumen_model");
		$this->load->model("anulado_model");
		$this->load->model("testado_model");
		$this->load->model("arqueo_model");
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$anuo=date("Y"); $mes=date("m");

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes);}
		$ntotal=$this->nventa_model->montoTotal($filtros);
		$vtotal=$this->venta_model->montoTotal($filtros);
		$dtotal=$this->nota_model->montoTotal($filtros);

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'year(femision)'=>$anuo,'month(femision)'=>$mes);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),'year(femision)'=>$anuo,'month(femision)'=>$mes);}
		$boletas=$this->venta_model->contador($filtros);
		$ncreditos=$this->nota_model->contador($filtros);
		$comprobantes=$boletas+$ncreditos;

		$ctotal=$this->compra_model->montoTotal($filtros);
    $estados=$this->testado_model->mostrarTotal();
    $diasmes=date("t");
    $arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));

    $fecvencimientos=$this->lote_model->fechasVencer(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fvencimiento<="=>SumarFecha('+3 month'),"stock>"=>0));
		$this->layout->setTitle('Inicio');
		$this->layout->view('index',compact("establecimientos","nestablecimiento","empresa","ctotal","ntotal","vtotal","dtotal","comprobantes","estados","diasmes","arqueoc","fecvencimientos"));
	}

	public function minimo()
	{
		$listas=$this->inventario_model->productosMinimo(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"estado"=>1,"mstock>"=>0,"(stock-mstock)<"=>1));
		$this->layout->setLayout("blanco");
		$this->layout->view("minimo",compact("listas"));
	}

	public function vencido()
	{
    $listas=$this->lote_model->productosVencer(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"fvencimiento<="=>SumarFecha('+3 month'),"estado"=>1,"stock>"=>0));
		$this->layout->setLayout("blanco");
		$this->layout->view("vencido",compact("listas"));
	}

	public function digemid()
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("digemid");
	}

	public function vigilancia()
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("vigilancia");
	}

	public function ventasm()
	{
		$diasmes=date("t");
		$finicio='01-'.date("m").'-'.date("Y");
		$datos=array();
		for ($i=0; $i < $diasmes ; $i++) {
			$fecha=SumarFecha('+'.$i.' day',$finicio);
			if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'femision'=>$fecha);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'femision'=>$fecha);}
      $vtotal=$this->venta_model->montoTotal($filtros);

      if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'femision'=>$fecha);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'femision'=>$fecha);}
      $ntotal=$this->nventa_model->montoTotal($filtros);

			$anexo['fechas']=date("d",strtotime($fecha));
			$anexo['ventas']=($vtotal->total??0);
			$anexo['nventas']=($ntotal->total??0);
			array_push($datos,$anexo);
		}
		echo json_encode($datos);
		//var_dump($datos);
	}

	public function comprasa()
	{
		$diasmes=date("t");
		$finicio='01-'.date("m").'-'.date("Y");
		$datos=array();
		for ($i=0; $i < $diasmes ; $i++) {
			$fecha=SumarFecha('+'.$i.' day',$finicio);
			if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'femision'=>$fecha);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'femision'=>$fecha);}
      $ctotal=$this->compra_model->montoTotal($filtros);

			$anexo['fechas']=date("d",strtotime($fecha));
			$anexo['compras']=($ctotal->total??0);
			array_push($datos,$anexo);
		}
		echo json_encode($datos);
		//var_dump($datos);
	}

	public function nventac()
	{
		$mes=date("m"); $anuo=date("Y");
		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);}
		$contado=$this->nventa_model->montoTotal($filtros);

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);}
		$credito=$this->nventa_model->montoTotal($filtros);
		$datos['contado']=($contado->total??0);
		$datos['credito']=($credito->total??0);
		echo json_encode($datos);
	}

	public function comprobantec()
	{
		$mes=date("m"); $anuo=date("Y");
		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);}
		$contado=$this->venta_model->montoTotal($filtros);

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);}
		$credito=$this->venta_model->montoTotal($filtros);
		$datos['contado']=($contado->total??0);
		$datos['credito']=($credito->total??0);
		echo json_encode($datos);
	}

	public function comprac()
	{
		$mes=date("m"); $anuo=date("Y");
		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>1);}
		$contado=$this->compra_model->montoTotal($filtros);

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,'year(femision)'=>$anuo,'month(femision)'=>$mes,"condicion"=>2);}
		$credito=$this->compra_model->montoTotal($filtros);
		$datos['contado']=($contado->total??0);
		$datos['credito']=($credito->total??0);
		echo json_encode($datos);
	}



}
