<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

class Inventario extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("kardex_model");
    $this->load->model("lote_model");
    $this->load->model("iinicial_model");
    $this->load->library("mytcpdf");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $inicio=$this->input->post("inicio",true)!=null ? $this->input->post("inicio",true) : SumarFecha("-15 day",date("Y-m-d")) ;
    $fin=$this->input->post("fin",true)!=null ? $this->input->post("fin",true) : date("Y-m-d");

    $listas=$this->iinicial_model->mostrarLimite($this->session->userdata("predeterminado"),$inicio,$fin);
    $this->layout->setTitle("Actualizar Inventario");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas","inicio","fin"));
  }

  public function inventarioi($id=null)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    if ($this->input->post())
    {
      if ($id!=null) {
        $consulta=$this->iinicial_model->contador($this->session->userdata("predeterminado"),$id,$this->input->post('mcodigo',true));
        if ($consulta==0) {
          $data=array
          (
            'idestablecimiento' =>$this->session->userdata("predeterminado"),
            'iduser'            =>$this->session->userdata('id'),
            'numero'            =>$id,
            'femision'          =>date("Y-m-d"),
            'idproducto'        =>$this->input->post('mcodigo',true),
            'descripcion'       =>$this->input->post('mdescripcion',true),
            'cantidad'          =>$this->input->post('munidades',true),
          );

          if ($this->input->post('mactivar',true)==1) {
            $data['lote']=$this->input->post('mlote',true);
            $data['fvencimiento']=$this->input->post('mfecha',true);
          }
          $insertar=$this->iinicial_model->insert($data);
          $this->session->set_flashdata('css', 'success');
          $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        } else {
          $this->session->set_flashdata('css', 'danger');
          $this->session->set_flashdata('mensaje', 'El producto ya fue agregado al inventario!!!!!!');
        }
        echo base_url()."inventario/inventarioi/".$id;
      } else {
        $numero=$this->iinicial_model->maximo($this->session->userdata("predeterminado"));
        $ninicio= $numero==null ? '' : $numero->numero;
        $numeracion=$ninicio+1;
        $data=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          'iduser'            =>$this->session->userdata('id'),
          'numero'            =>$numeracion,
          'femision'          =>date("Y-m-d"),
          'idproducto'        =>$this->input->post('mcodigo',true),
          'descripcion'       =>$this->input->post('mdescripcion',true),
          'cantidad'          =>$this->input->post('munidades',true),
        );

        if ($this->input->post('mactivar',true)==1) {
          $data['lote']=$this->input->post('mlote',true);
          $data['fvencimiento']=$this->input->post('mfecha',true);
        }
        $insertar=$this->iinicial_model->insert($data);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
        echo base_url()."inventario/inventarioi/".$numeracion;
      }
      exit();
    }

    $listas=$this->iinicial_model->mostrarTotal($this->session->userdata("predeterminado"),$id);
    $this->layout->setLayout("contraido");
    $this->layout->setTitle("Actualizar Inventario");
    $this->layout->view("inventarioi",compact("establecimientos","nestablecimiento","listas","id"));
  }

  public function inventarioe($nro,$id)
  {
    if ($this->input->post())
    {
      $data=array('cantidad'=>$this->input->post('munidades',true));
      if ($this->input->post('mactivar',true)==1) {
        $data['lote']=$this->input->post('mlote',true);
        $data['fvencimiento']=$this->input->post('mfecha',true);
      }
      //var_dump($data); exit();
      $guardar=$this->iinicial_model->update($data,$id);
      $this->session->set_flashdata('css', 'success');
      $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      echo base_url()."inventario/inventarioi/".$nro;
      exit();
    }

    $datos=$this->iinicial_model->mostrar($id);
    $producto=$this->producto_model->mostrar(array("p.id"=>$datos->idproducto));
    $this->layout->setLayout("blanco");
    $this->layout->view("inventarioe",compact("datos","producto"));
  }

  public function inventarioItemd($id)
  {
    if (!$id) {show_404();}
    $datos=$this->iinicial_model->mostrar($id);
    if ($datos==NULL) {show_404();}

    $eliminar=$this->iinicial_model->delete($id);
    echo 'borrado';
  }

  public function inventariog()
  {
    if ($this->input->post())
    {
      $url='';
      for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
        $datak=array
        (
          'idestablecimiento' =>$this->session->userdata("predeterminado"),
          'iduser'            =>$this->session->userdata('id'),
          'fecha'             =>date("Y-m-d"),
          'idtmovimiento'     =>16,
          'concepto'          =>'Stock Actualizado',
          'idproducto'        =>$this->input->post('idproducto',true)[$i],
          'descripcion'       =>trim($this->input->post('descripcion',true)[$i]),
          'entradaf'          =>$this->input->post('cantidad',true)[$i],
          'saldof'            =>$this->input->post('cantidad',true)[$i],
          'costo'             =>$this->input->post('precio',true)[$i],
          'entradav'          =>$this->input->post('importe',true)[$i],
          'saldov'            =>$this->input->post('importe',true)[$i],
        );
        $insertark=$this->kardex_model->insert($datak);

        $eliminar=$this->lote_model->delete(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));
        if ($this->input->post('lote',true)[$i]!="" && $this->input->post('cantidad',true)[$i]>0) {
          $datal=array
          (
            'idestablecimiento' =>$this->session->userdata("predeterminado"),
            'idproducto'        =>$this->input->post('idproducto',true)[$i],
            'nlote'             =>$this->input->post('lote',true)[$i],
            'fvencimiento'      =>valor_fecha($this->input->post('fvencimiento',true)[$i]),
            'inicial'           =>$this->input->post('cantidad',true)[$i],
            'stock'             =>$this->input->post('cantidad',true)[$i],
          );
          $insertarl=$this->lote_model->insert($datal);
        }

        //actualizar stock
        $datas=array('stock'=>$this->input->post('cantidad',true)[$i]);
        $actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));

        //actualizar inventario
        $data=array(
          'precio'        =>$this->input->post('precio',true)[$i],
          'importe'       =>$this->input->post('importe',true)[$i],
          'estado'        =>1,
        );
        $actualizar=$this->iinicial_model->update($data,$this->input->post('id',true)[$i]);
      }

      $datos['mensaje']='Los datos se han guardado exitosamente!';
      $datos['url']=base_url().'inventario';
      echo json_encode($datos);
      exit();
    }
  }

  public function inventariox()
  {
   if ($this->input->post())
   {
     $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
     if(isset($_FILES['archivo']['name']) && in_array($_FILES['archivo']['type'], $file_mimes)) {
       $arr_file = explode('.', $_FILES['archivo']['name']);
       $extension = end($arr_file);
       if('csv' == $extension){
         $reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
       } else {
         $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
       }
       $spreadsheet = $reader->load($_FILES['archivo']['tmp_name']);

       //numeracion del inventario
      $numero=$this->iinicial_model->maximo($this->session->userdata("predeterminado"));
      $ninicio= $numero==null ? '' : $numero->numero;
      $numeracion=$ninicio+1;

      //llenado de informacion
       $sheet_data = $spreadsheet->getActiveSheet()->toArray();
       foreach($sheet_data as $key => $val) {
         if($key != 0) {
          $data=array
          (
            'idestablecimiento' =>$this->session->userdata("predeterminado"),
            'iduser'            =>$this->session->userdata('id'),
            'numero'            =>$numeracion,
            'femision'          =>date("Y-m-d"),
            'idproducto'        =>$val[0],
            'descripcion'       =>trim($val[1]),
            'cantidad'          =>$val[3],
            'lote'              =>valor_fecha($val[4]),
            'fvencimiento'      =>valor_fecha(formatoVcto($val[5])),
          );
          $insertar=$this->iinicial_model->insert($data);
         }
       }

       $this->session->set_flashdata('css', 'success');
       $this->session->set_flashdata('mensaje', 'La informacion fue subida exitosamente!');
     }else {
       $this->session->set_flashdata('css', 'danger');
       $this->session->set_flashdata('mensaje', 'No existe archivo o no corresponde el tipo!');
     }
     echo base_url()."inventario";
     exit();
   }

   $this->layout->setLayout("blanco");
   $this->layout->view("inventariox");
  }

  public function inventarioexcel()
  {
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $listas=$this->producto_model->mostrarTotal(array("estado"=>1));

   $spreadsheet = new Spreadsheet();
   $sheet = $spreadsheet->getActiveSheet();
   $sheet->setTitle("Stock");

   $styleArray = [
       'borders' => [
           'top' => [
               'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
           ],
           'bottom' => [
               'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
           ],
           'left' => [
               'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
           ],
           'right' => [
               'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
           ],
       ],
   ];

   foreach(range("A","G") as $columnID) {
       $sheet->getColumnDimension($columnID)->setAutoSize(true);
       $sheet->getStyle($columnID."1")->applyFromArray($styleArray);
   }

   $sheet->setCellValueByColumnAndRow(1, 1,"Id");
   $sheet->setCellValueByColumnAndRow(2, 1,"Nombre");
   $sheet->setCellValueByColumnAndRow(3, 1,"Control Lote");
   $sheet->setCellValueByColumnAndRow(4, 1,"Nuevo Stock");
   $sheet->setCellValueByColumnAndRow(5, 1,"Codigo Lote");
   $sheet->setCellValueByColumnAndRow(6, 1,"F.Vcto");
   $sheet->setCellValueByColumnAndRow(7, 1,"Anterior Stock");

   $i=2;
   foreach ($listas as $lista) {
    $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$lista->id);
     $sheet->getStyle("A".$i)->applyFromArray($styleArray);
     $sheet->getStyle("B".$i)->applyFromArray($styleArray);
     $sheet->getStyle("C".$i)->applyFromArray($styleArray);
     $sheet->getStyle("D".$i)->applyFromArray($styleArray);
     $sheet->getStyle("E".$i)->applyFromArray($styleArray);
     $sheet->getStyle("F".$i)->applyFromArray($styleArray);
     $sheet->getStyle("G".$i)->applyFromArray($styleArray);

     $sheet->setCellValue("A".$i,$lista->id);
     $sheet->setCellValue("B".$i,$lista->descripcion.' '.$lista->nlaboratorio);
     $sheet->setCellValue("C".$i,$lista->lote==1?'lote/f.vcto':'');
     $sheet->setCellValue("G".$i,$cantidad->stock);
     $i++;
   }

    $writer = new Xlsx($spreadsheet); // instantiate Xlsx
    header('Content-Type: application/vnd.ms-excel'); // generate excel file
    header('Content-Disposition: attachment;filename="LISTA_STOCK_'.$nestablecimiento->descripcion.'_.xlsx"');
    $writer->save('php://output'); // download file
  }

  public function consulta($id)
  {
    $detalles=$this->iinicial_model->mostrarTotal($this->session->userdata("predeterminado"),$id);
    $this->layout->setLayout("blanco");
    $this->layout->view("consulta",compact("detalles"));
  }

  public function pdfinventario($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $detalles=$this->iinicial_model->mostrarTotal($this->session->userdata("predeterminado"),$id);
    $this->layout->setLayout("blanco");
    $this->layout->view("pdfinventario",compact("empresa","nestablecimiento","detalles","id"));
  }


}
