<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Punto extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("punto_model");
	}

	public function index()
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		if ($this->input->post()) 
		{
			$data=array
			(
				"valorp"		=>$this->input->post("valorp",true),
				"caducidad"	=>$this->input->post("caducidad",true),
				"canjep"		=>$this->input->post("canjep",true),
				"canjev"		=>$this->input->post("canjev",true),
			);
			$guardar=$this->punto_model->update($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");
		}

		$datos=$this->punto_model->mostrar();
		$this->layout->setTitle("Puntos Acumulables");
		$this->layout->view("index",compact("establecimientos","datos"));
	}

}
