<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Serie extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata("login")){redirect(base_url()."login");}
		$this->layout->setLayout("principal");
		$this->load->model("tcomprobante_model");
		$this->load->model("serie_model");
	}

	public function index($id)
	{
		$anexos=explode(",",$this->session->userdata("establecimientos"));
		$establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);

		$empresa=$this->empresa_model->mostrar();
		$datos=$this->establecimiento_model->mostrar($id);
		if ($empresa->facturacion==1) {
		$listas=$this->serie_model->mostrarTotal(array("idestablecimiento"=>$id));
		} else {
		$listas=$this->serie_model->mostrarTotal(array("idestablecimiento"=>$id,"tcomprobante"=>99));
		}
		$this->layout->setTitle("Series");
		$this->layout->view("index",compact("establecimientos","datos","listas","id"));
	}

	public function seriei($codigo,$id=null)
	{
		if ($this->input->post())
		{
			if ($id!=null) {
				$data=array("serie"=>$this->input->post("serie",true));
				$guardar=$this->serie_model->update($data,$id);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			} else {
				$data=array(
					"idestablecimiento"	=>$codigo,
					"tcomprobante"			=>$this->input->post("tcomprobante",true),
					"serie"							=>$this->input->post("serie",true),
				);
				$insertar=$this->serie_model->insert($data);
				$this->session->set_flashdata('css', 'success');
				$this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
			}
			echo base_url()."serie/index/".$codigo;
			exit();
		}

		$datos=$id!=null?$this->serie_model->mostrar(array("s.id"=>$id)):(object) array("tcomprobante"=>'',"serie"=>'');
		$tcomprobantes=$id!=null ? $this->tcomprobante_model->mostrar($datos->tcomprobante) : $this->tcomprobante_model->mostrarTotal();
		$this->layout->setLayout("blanco");
		$this->layout->view("seriei",compact('datos','tcomprobantes','id'));
	}



}
