<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transporte extends CI_Controller
{
  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata("login")){redirect(base_url()."login");}
    $this->layout->setLayout("principal");
    $this->load->model("tidentidad_model");
    $this->load->model("transporte_model");
  }

  public function index()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->transporte_model->mostrarTotal('02');
    $this->layout->setTitle("Transporte Privado");
    $this->layout->view("index",compact("establecimientos","nestablecimiento","listas"));
  }

  public function privadoi($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array
        (
          "tdocumento"  =>$this->input->post("tdocumento",true),
          "documento"   =>$this->input->post("documento",true),
          "nombres"     =>$this->input->post("nombres",true),
          "placa"       =>$this->input->post("placa",true),
          "licencia"    =>$this->input->post("licencia",true),
        );

        $guardar=$this->transporte_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $data=array
        (
          "idttransporte" =>'02',
          "tdocumento"    =>$this->input->post("tdocumento",true),
          "documento"     =>$this->input->post("documento",true),
          "nombres"       =>$this->input->post("nombres",true),
          "placa"         =>$this->input->post("placa",true),
          "licencia"      =>$this->input->post("licencia",true),
        );

        $insertar=$this->transporte_model->insert($data);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      }
      echo base_url()."transporte";
      exit();
    }

    $datos=$id!=null?$this->transporte_model->mostrar($id):(object) array("tdocumento"=>1,"documento"=>'',"nombres"=>'',"placa"=>'',"licencia"=>'');
    $identidades=$this->tidentidad_model->mostrarTotal();
    $this->layout->setLayout("blanco");
    $this->layout->view("privadoi",compact('datos',"identidades"));
  }

  public function publico()
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

    $listas=$this->transporte_model->mostrarTotal('01');
    $this->layout->setTitle("Transporte Publico");
    $this->layout->view("publico",compact("establecimientos","nestablecimiento","listas"));
  }

  public function publicoi($id=null)
  {
    if ($this->input->post())
    {
      if ($id!=null) {
        $data=array
        (
          "tdocumento"  =>$this->input->post("tdocumento",true),
          "documento"   =>$this->input->post("documento",true),
          "nombres"     =>$this->input->post("nombres",true),
        );

        $guardar=$this->transporte_model->update($data,$id);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      } else {
        $data=array
        (
          "idttransporte" =>'01',
          "tdocumento"    =>$this->input->post("tdocumento",true),
          "documento"     =>$this->input->post("documento",true),
          "nombres"       =>$this->input->post("nombres",true),
        );

        $insertar=$this->transporte_model->insert($data);
        $this->session->set_flashdata('css', 'success');
        $this->session->set_flashdata('mensaje', 'Los datos se han guardado exitosamente!');
      }
      echo base_url()."transporte/publico";
      exit();
    }

    $datos=$id!=null?$this->transporte_model->mostrar($id):(object) array("tdocumento"=>6,"documento"=>'',"nombres"=>'');
    $identidades=$this->tidentidad_model->mostrarTotal();
    $this->layout->setLayout("blanco");
    $this->layout->view("publicoi",compact('datos',"identidades"));
  }

}
