<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Venta extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('login')){redirect(base_url().'login');}
		$this->layout->setLayout('principal');
		$this->load->model("testado_model");
		$this->load->model('tidentidad_model');
		$this->load->model('tcomprobante_model');
		$this->load->model('serie_model');
		$this->load->model('tcredito_model');
		$this->load->model('tdebito_model');
		$this->load->model('tpago_model');
		$this->load->model('departamento_model');
		$this->load->model("provincia_model");
		$this->load->model("distrito_model");
		$this->load->model('cliente_model');
		$this->load->model("tafectacion_model");
		$this->load->model("categoria_model");
		$this->load->model("laboratorio_model");
		$this->load->model("pactivo_model");
		$this->load->model("aterapeutica_model");
		$this->load->model('producto_model');
		$this->load->model('lote_model');
		$this->load->model('kardex_model');
		$this->load->model("bonificado_model");
		$this->load->model('cotizacion_model');
		$this->load->model('cotizaciond_model');
		$this->load->model("nventa_model");
		$this->load->model("nventad_model");
		$this->load->model("cobro_model");
		$this->load->model('venta_model');
		$this->load->model('ventad_model');
		$this->load->model('cobroe_model');
		$this->load->model('nota_model');
		$this->load->model('notad_model');
		$this->load->model('cobron_model');
		$this->load->model("arqueo_model");
		$this->load->model("punto_model");
		$this->load->model("clientep_model");
		$this->load->model("vale_model");

		$this->load->library("mytcpdf");
    $this->load->library("generadorXML");
    $this->load->library("firmarXML");
    $this->load->library("apiFacturacion");
    $this->generadoXML = new GeneradorXML();
    $this->firmadoXML = new FirmarXML();
    $this->apiFacturacion = new ApiFacturacion();
	}

	public function index()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-7 day',date('Y-m-d')) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->venta_model->mostrarTotal($filtros,"desc");
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		$this->layout->setLayout('contraido');
		$this->layout->setTitle('Venta Producto');
		$this->layout->view('index',compact("establecimientos","nestablecimiento",'listas','inicio','fin','empresa','arqueoc'));
	}

	public function arqueoi()
	{
		if ($this->input->post())
		{
			$data=array
			(
				'idestablecimiento'	=>$this->session->userdata("predeterminado"),
				'iduser'						=>$this->session->userdata('id'),
				'femision'					=>date("Y-m-d"),
				'finicial'					=>date("Y-m-d H:i:s"),
				'minicial'					=>$this->input->post('minicial',true),
				'estado'						=>1,
			);
			$insertar=$this->arqueo_model->insert($data);

			$this->session->set_flashdata("css", "success");
			$this->session->set_flashdata("mensaje", "Los datos se han guardado exitosamente!");

			echo base_url()."venta/ventai";
			exit();
		}

		$this->layout->setLayout("blanco");
		$this->layout->view("arqueoi");
	}

	public function busSerie()
	{
		if ($this->input->post())
		{
			$datos=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>$this->input->post('nro',true)));
			echo $datos->serie;
		}
		else
		{
			show_404();
		}
	}

	public function presupuestoi($id)
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$canexos=$this->establecimiento_model->contador();
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		if ($arqueoc==0) {redirect(base_url().'venta');}

		$mpagos=$this->tpago_model->mostrarTotal();
		$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
		$comprobantes=$this->tcomprobante_model->mostrarLimite(array("formulario"=>1));
		$nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'03'));
		$cotizacion=$this->cotizacion_model->mostrar($id);
		$detalles=$this->cotizaciond_model->mostrarTotal($id);
		$ncliente=$this->cliente_model->mostrar(array("c.id"=>$cotizacion->idcliente));
		$this->layout->setLayout("contraido");
		$this->layout->setTitle('Venta Producto');
		$this->layout->view('presupuestoi',compact("establecimientos","nestablecimiento",'empresa',"canexos",'mpagos','comprobantes','nserie',"productos","cotizacion","detalles","ncliente","id"));
	}

	public function ventai()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$canexos=$this->establecimiento_model->contador();
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		if ($arqueoc==0) {redirect(base_url().'venta');}

		$mpagos=$this->tpago_model->mostrarTotal();
		$productos=$this->producto_model->mostrarLimite(array("estado"=>1));
		$comprobantes=$this->tcomprobante_model->mostrarLimite(array("formulario"=>1));
		$nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'03'));
		$this->layout->setLayout("contraido");
		$this->layout->setTitle('Venta Producto');
		$this->layout->view('ventai',compact("establecimientos","nestablecimiento",'empresa',"canexos",'mpagos','comprobantes','nserie',"productos"));
	}

	public function guardar($id=NULL)
	{
		if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			$impresion='';
			if ($this->input->post('idproducto',true)==null) {
				$mensaje='No envio productos en la venta!';
			} else {
				if ($this->input->post('totalg',true)>0) {
					$pagado=array_sum($this->input->post('monto',true));
					if (valor_check($this->input->post('pcredito',true))==0 && $pagado!=$this->input->post('totalg',true)) {
						$mensaje='El monto cobrado es diferente al comprobante';
					}else{
						$tcomprobante=$this->input->post('comprobante',true);
						$serie=SUBSTR($this->input->post('serie',true),0,1);
						$cliente=$this->cliente_model->mostrar(array("c.id"=>$this->input->post('idcliente',true)));

						if ($tcomprobante=='01' && $serie=='F' && $cliente->tdocumento==6 || $tcomprobante=='03' && $serie=='B') {
							if ($serie=="B" && $this->input->post('totalg',true)>700 && $cliente->tdocumento==0) {
								$mensaje='El monto a emitir es mayor a S/.700 requiere DNI del cliente';
							}else{
								$numero=$this->venta_model->maximo($this->input->post('serie',true));
								$ninicio= $numero==null ? '' : $numero->numero;
								$numeracion=$ninicio+1;

								$consulta=$this->venta_model->contador(array("serie"=>$this->input->post("serie",true),"numero"=>$numeracion));
								if ($consulta==0) {
									$comprobante=array
									(
										'idestablecimiento'	=>$this->session->userdata("predeterminado"),
										'iduser'						=>$this->session->userdata('id'),
										"grupo"        		 	=>$this->input->post('comprobante',true)=='01' ? '01' : '02',
										'tipo_soap'         =>$empresa->tipo_soap,
										'femision'					=>date("Y-m-d"),
										'hemision'					=>date('H:i:s'),
										'fvencimiento'			=>date("Y-m-d"),
										'tcomprobante'			=>$this->input->post('comprobante',true),
										'serie'							=>$this->input->post('serie',true),
										'numero'						=>$numeracion,
										'toperacion'				=>'0101',
										'moneda'						=>'PEN',
										'idcliente'					=>$this->input->post('idcliente',true),
										'cliente'						=>$this->input->post('cliente',true),
										'tgravado'					=>$this->input->post('gravado',true),
										'tinafecto'					=>$this->input->post('inafecto',true),
										'texonerado'				=>$this->input->post('exonerado',true),
										"subtotal"					=>$this->input->post('gravado',true)+$this->input->post('inafecto',true)+$this->input->post('exonerado',true),
										'tigv'							=>$this->input->post('igv',true),
										'total'							=>$this->input->post('totalg',true),
										'izipay'						=>valor_fecha($this->input->post('mizipay',true)),
										'lote'							=>valor_check($this->input->post('impresion',true)),
										'condicion'					=>1,
										'cancelado'					=>1,
										"tipo_estado"				=>"01",
									);

									if ($this->input->post('mdsctog',true)!='') {
										$msubtotal=$this->input->post('bimponible',true);
										$mdescuento=round($this->input->post('mdsctog',true)/1.18,2);
										$fdescuento=round(($mdescuento*100)/($msubtotal*100),4);

										$descuentos["codigo"]="02";
	                  $descuentos["descripcion"]="Descuentos globales que afectan la base imponible del IGV/IVAP";
	                  $descuentos["factor"]=$fdescuento;
	                  $descuentos["monto"]=$mdescuento;
	                  $descuentos["base"]=$msubtotal;
							      $comprobante["descuentos"]=json_encode($descuentos);
							    }
									$insertar=$this->venta_model->insert($comprobante);

									if (valor_check($this->input->post('pcredito',true))==1) {
										$suma=tiempoCuota($this->input->post('pcuota',true));
										$posterior=SumarFecha($suma,date("Y-m-d"));

										$datac=array
										(
											'condicion'			=>2,
											'cancelado'			=>0,
											'pcuota'				=>$this->input->post('pcuota',true),
											'cuotas'				=>$this->input->post('cuotas',true),
											'mcuota'				=>$this->input->post('mcuota',true),
											'fpago'					=>$posterior,
											'fvencimiento'	=>$this->input->post('fvencimiento',true),
										);
										$actualizac=$this->venta_model->update($datac,$insertar);
									} else {
										for ($i=0; $i < count($this->input->post('mpago',true)) ; $i++) {
											$datap=array
											(
												'idestablecimiento'	=>$this->session->userdata("predeterminado"),
												'iduser'						=>$this->session->userdata('id'),
												'idventa'						=>$insertar,
												'femision'					=>date("Y-m-d"),
												'idtpago'						=>$this->input->post('mpago',true)[$i],
												'total'							=>$this->input->post('monto',true)[$i],
											);
											$insertarp=$this->cobroe_model->insert($datap);
										}
									}

									$punto_acumulado=0;
									for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
										if ($this->input->post('tipo',true)[$i]=='B') {
											$saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i]);
											$inicalf=$saldos==null ? 0: $saldos->saldof;
											$inicalv=$saldos==null ? 0: $saldos->saldov;
											//costos promedio
											$costo=$inicalf==0 ? 0 : round($inicalv/$inicalf,4);
											$salidav=$this->input->post("almacenc",true)[$i]*$costo;

											$saldof=$inicalf-$this->input->post("almacenc",true)[$i];
											$saldov=$inicalv-$salidav;
											$datak=array
											(
												'idestablecimiento'	=>$this->session->userdata("predeterminado"),
												'iduser'						=>$this->session->userdata('id'),
												'fecha'							=>date('Y-m-d'),
												"idtmovimiento"			=>1,
												'concepto'					=>'Venta',
												'idproducto'				=>$this->input->post("idproducto",true)[$i],
												'descripcion'				=>trim($this->input->post("descripcion",true)[$i]),
												'salidaf'						=>$this->input->post("almacenc",true)[$i],
												'saldof'						=>$saldof,
												'costo'							=>$costo,
												'salidav'						=>$salidav,
												'saldov'						=>$saldov,
												'documento'					=>$this->input->post('serie',true).'-'.$numeracion,
											);
											$insertark=$this->kardex_model->insert($datak);

											$datas=array('stock'=>$saldof);
											$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));

											$nlotes='';
											$clotes='';
											$flotes='';
											if ($this->input->post("lote",true)[$i]==1) {
												$cantidad=$this->input->post("almacenc",true)[$i];

												$nlotes=array();
												$clotes=array();
												$flotes=array();
												if ($this->input->post("nlote",true)[$i]!='') {
													$nlotes=explode(",",$this->input->post("nlote",true)[$i]);
													for ($l=0; $l < count($nlotes) ; $l++) {
														$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
														$ncantidad=$cantidad-$consultal->stock;	//nueva cantidad
														$saldoc=$consultal->stock-$cantidad;	//saldo a guardar

														if ($saldoc>0) {
															$datal=array('stock'=>$saldoc);
															$actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$nlotes[$l]);
														} else {
															$elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$nlotes[$l]));
														}

														if ($consultal->stock<$cantidad) {
															$inicialf=$consultal->stock;
														} else {
															$inicialf=$cantidad;
														}

														array_push($clotes,$inicialf);
														array_push($flotes,$consultal->fvencimiento);
														$cantidad=$ncantidad;
													}
												} else {
													for ($l=0; $l < 3 ; $l++) {
									          $consultal=$this->lote_model->ultimo($this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i]);

									          if ($cantidad>=$consultal->stock) {
									            $elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post("idproducto",true)[$i],"nlote"=>$consultal->nlote));
									            $inicialf=$consultal->stock;
									          } else {
									            $datal=array('stock'=>$consultal->stock-$cantidad);
									            $actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post("idproducto",true)[$i],$consultal->nlote);
									            $inicialf=$cantidad;
									          }

									          array_push($nlotes,$consultal->nlote);
									          array_push($clotes,$inicialf);
									          array_push($flotes,$consultal->fvencimiento);

									          $cantidad-=$consultal->stock;
									          if ($cantidad<=0) {
									            break;
									          }
									        }
												}

												$nlotes=implode('|', $nlotes);
												$clotes=implode('|', $clotes);
												$flotes=implode('|', $flotes);
											}
										}

					  					/*----------  conversion tipo afectacion  ----------*/
										if ($this->input->post('tafectacion',true)[$i]==10) {
											$valoru=round($this->input->post('precio',true)[$i]/1.18,4);
											$valor=round($this->input->post('importe',true)[$i]/1.18,2);
											$igv=round(($this->input->post('importe',true)[$i]*0.18)/1.18,2);
										} else {
											$valoru=$this->input->post("precio",true)[$i];
											$valor=$this->input->post('importe',true)[$i];
											$igv=0;
										}

										$itemx=array
										(
											'idventa'			=>$insertar,
											'idproducto'	=>$this->input->post('idproducto',true)[$i],
											'descripcion'	=>trim($this->input->post('descripcion',true)[$i]),
											'unidad'			=>$this->input->post("unidad",true)[$i],
											'cantidad'		=>$this->input->post('cantidad',true)[$i],
											'valor'				=>$valoru,
											'tprecio'			=>'01',
											'precio'			=>$this->input->post('precio',true)[$i],
											'tafectacion'	=>$this->input->post('tafectacion',true)[$i],
											'total'				=>$valor,
											'igv'					=>$igv,
											'importe'			=>$this->input->post('importe',true)[$i],
										);

										if ($this->input->post('tipo',true)[$i]=='B') {
											$itemx["calmacen"]		=$this->input->post("almacenc",true)[$i];
											$itemx["palmacen"]		=$costo;
											$itemx["lote"]				=$nlotes;
											$itemx["clote"]				=$clotes;
											$itemx["fvencimiento"]=$flotes;
										}

										if ($this->input->post('dscto',true)[$i]>0) {
											$msubtotal=$this->input->post('cantidad',true)[$i]*$this->input->post('precio',true)[$i];
											if ($this->input->post('tafectacion',true)[$i]==10) {
												$msubtotal=round($msubtotal/1.18,2);
											}

											if ($this->input->post('tdscto',true)[$i]==0) { //descuento porcentaje
												$fdescuento=$this->input->post('dscto',true)[$i]/100;
												$mdescuento=$msubtotal*$fdescuento;
											} else { //descuento en monto
												if ($this->input->post('tafectacion',true)[$i]==10) {
													$mdescuento=round($this->input->post('dscto',true)[$i]/1.18,2);
												} else {
													$mdescuento=$this->input->post('dscto',true)[$i];
												}
												$fdescuento=round(($mdescuento*100)/($msubtotal*100),4);
											}

	                    $descuentos["codigo"]="00";
	                    $descuentos["descripcion"]="Descuento Lineal";
	                    $descuentos["factor"]=$fdescuento;
	                    $descuentos["monto"]=$mdescuento;
	                    $descuentos["base"]=$msubtotal;
	                    //$itemx["dscto"]=$mdescuento;
	                    $itemx["descuentos"]=json_encode($descuentos);
										}
										$insertard=$this->ventad_model->insert($itemx);

							      $producto=$this->producto_model->mostrar(array("p.id"=>$this->input->post("idproducto",true)[$i]));
							      $vpuntos=$this->punto_model->mostrar();
							      $punto_acumulado += $producto->puntos==0 ? 0 : intval($this->input->post("importe",true)[$i]/$vpuntos->valorp);
									}

									if ($punto_acumulado>0 && $this->input->post("idcliente",true)>1 && $this->input->post("tdocumento",true)!=6) {
										$datap=array
										(
											"idventa"		=>$insertar,
											"idcliente"	=>$this->input->post("idcliente",true),
											"femision"	=>date("Y-m-d"),
											"inicial"		=>$punto_acumulado,
											"cantidad"	=>$punto_acumulado,
										);
										$insertarp=$this->clientep_model->insert($datap);
									}

									if ($this->input->post('mdsctog',true)!='' && $this->input->post('nvale',true)!='') {
										$idvale=explode("&",$this->input->post("nvale",true));
										$datal=array(
											"estado"=>0,
							        "fcanje"=>date("Y-m-d"),
							      );
										$actualizarl=$this->vale_model->update($datal,$idvale[0]);
									}

							    if ($id!=NULL) {
										$datat=array(
					            "estado"  =>2,
					            "emitido" =>$this->input->post('serie',true).'-'.$numeracion,
					          );
										$actualizar=$this->cotizacion_model->update($datat,array("id"=>$id));
							    }

		              $nombrexml = $empresa->ruc.'-'.$comprobante['tcomprobante'].'-'.$comprobante['serie'].'-'.$comprobante['numero'];
							    if ($comprobante['grupo']=='01') {
		                $mensaje=$this->generadorXml($insertar);
							    }else{
							    	$datav=array
								    (
								      'filename'  =>$nombrexml,
								      'has_pdf'   =>1,
								    );
								    $actualizar=$this->venta_model->update($datav,$insertar);
		                $mensaje='Se genero comprobante '.$comprobante['serie'].'-'.$comprobante['numero'];
							    }

	                if (valor_check($this->input->post('formato',true))==1) {
										self::pdfformato($insertar);
									}else{
										self::pdfticket($insertar);
									}
	                $impresion=base_url()."downloads/pdf/".$nombrexml.'.pdf';
								} else {
									$mensaje='El comprobante ya existe';
								}
							}
						} else {
							$mensaje='El tipo de comprobante no corresponde con la serie o cliente';
						}
					}
				} else {
					$mensaje='No se puede realizar una venta en negativo!';
				}
			}

			$datos['mensaje']=$mensaje;
			$datos['impresion']=$impresion;
			$datos['url']=base_url().'venta/ventai';
			echo json_encode($datos);
			exit();
		}
	}

  public function emisor()
  {
    $empresa=$this->empresa_model->mostrar();
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
    $datos=array
    (
      'ruc'           =>$empresa->ruc,
      'nombres'       =>$empresa->nombres,
      'ncomercial'    =>$empresa->ncomercial,
      'codigo'        =>$nestablecimiento->codigo,
      'ndepartamento' =>$nestablecimiento->ndepartamento,
      'nprovincia'    =>$nestablecimiento->nprovincia,
      'ndistrito'     =>$nestablecimiento->ndistrito,
      'distrito'      =>$nestablecimiento->iddistrito,
      'direccion'     =>$nestablecimiento->direccion,
    );
    return $datos;
  }

  public function itemsVenta($id)
  {
    $detalles=$this->ventad_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $itemx=array
      (
        'idventa'         =>$id,
        'idproducto'      =>$detalle->idproducto,
        'descripcion'     =>$detalle->descripcion,
        'unidad'          =>$detalle->unidad,
        'cantidad'        =>$detalle->cantidad,
        'valor'           =>$detalle->valor,
        'tafectacion'     =>$detalle->tafectacion,
        'tprecio'         =>$detalle->tprecio,
        'precio'          =>$detalle->precio,
        'total'           =>$detalle->total,
        'igv'             =>$detalle->igv,
        'importe'         =>$detalle->importe,
        'descuentos'      =>$detalle->descuentos,
      );

      if ($detalle->tafectacion == 10) {
        $itemx['codigo_tributo']=array("S","1000","IGV","VAT");
      }
      elseif ($detalle->tafectacion == 20) {
        $itemx['codigo_tributo']=array("E","9997","EXO","VAT");
      }
      elseif ($detalle->tafectacion == 30) {
        $itemx['codigo_tributo']=array("O","9998","INA","FRE");
      }
      elseif ($detalle->tafectacion == 40) {
        $itemx['codigo_tributo']=array("G","9995","EXP","FRE");
      }
      else{
        $itemx['codigo_tributo']=array("Z","9996","GRA","FRE");
      }
      $datos[]=$itemx;
    }
    return $datos;
  }

  public function generadorXml($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->venta_model->mostrar($id);
    $comprobante=array
    (
      'femision'          =>$datos->femision,
      'hemision'          =>$datos->hemision,
      'fvencimiento'      =>$datos->fvencimiento,
      'tcomprobante'      =>$datos->tcomprobante,
      'serie'             =>$datos->serie,
      'numero'            =>$datos->numero,
      'toperacion'        =>$datos->toperacion,
      'moneda'            =>$datos->moneda,
      'tgravado'          =>$datos->tgravado,
      'texonerado'        =>$datos->texonerado,
      'tinafecto'         =>$datos->tinafecto,
      'subtotal'          =>$datos->subtotal,
      'tigv'              =>$datos->tigv,
      'total'           	=>$datos->total,
      'condicion'    			=>$datos->condicion,
      'descuentos'      	=>$datos->descuentos,
    );

    if ($datos->condicion==2) {
			$comprobante['cuotas']=$datos->cuotas;
			$comprobante['pcuota']=$datos->pcuota;
			$comprobante['mcuota']=$datos->mcuota;
			$comprobante['fpago']=$datos->fpago;
    }

    $nombrexml = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $ruta_xml = "downloads/xml/".$nombrexml;
    $emisor=$this->emisor();
    $cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
    $detalle=$this->itemsVenta($id);
    $this->generadoXML->CrearXMLFactura($ruta_xml, $emisor, $cliente, $comprobante, $detalle);

    $ruta_certificado = "downloads/certificado/".$empresa->certificado;
    $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);

    $datav=array
    (
      'filename'  =>$nombrexml,
      'hash'      =>$hash,
      'has_xml'   =>1,
      'has_pdf'   =>1,
    );
    $actualizar=$this->venta_model->update($datav,$id);
    return 'Se genero comprobante '.$datos->serie.'-'.$datos->numero;
  }

	public function pdfticket($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$tpuntos=$this->clientep_model->cantidadTotal($datos->idcliente);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfticket",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre","tpuntos"));
	}

	public function pdfformato($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfformato",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre"));
	}

	public function consulta($id)
	{
		$datos=$this->venta_model->mostrar($id);
		$detalles=$this->ventad_model->mostrarTotal($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("consulta",compact("datos","detalles"));
	}

	public function opciones($id)
	{
		$this->layout->setLayout("blanco");
		$this->layout->view("opciones",compact("id"));
	}

	public function pdfa4($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa4",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre"));
	}

	public function pdf80($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$tpuntos=$this->clientep_model->cantidadTotal($datos->idcliente);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf80",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre","tpuntos"));
	}

	public function pdf58($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$tpuntos=$this->clientep_model->cantidadTotal($datos->idcliente);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdf58",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre","tpuntos"));
	}

	public function pdfa5($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->venta_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->ventad_model->mostrarTotal($id);
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfa5",compact("empresa","nestablecimiento","datos","clientes","detalles","nombre"));
	}

	/*===================================================================================================================
	=                                                    notas comprobantes                                             =
	===================================================================================================================*/
	public function ncredito()
	{
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

		$empresa=$this->empresa_model->mostrar();
		$inicio=$this->input->post('inicio',true)!=null ? $this->input->post('inicio',true) : SumarFecha('-15 day',date('Y-m-d')) ;
		$fin=$this->input->post('fin',true)!=null ? $this->input->post('fin',true) : date('Y-m-d') ;

		if ($this->session->userdata("tipo")=='admin') {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"femision>="=>$inicio,"femision<="=>$fin);} else {$filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"femision>="=>$inicio,"femision<="=>$fin);}
		$listas=$this->nota_model->mostrarTotal($filtros,"desc");
		$arqueoc=$this->arqueo_model->contador($this->session->userdata("predeterminado"),$this->session->userdata("id"));
		$this->layout->setLayout('contraido');
		$this->layout->setTitle('Notas Credito');
		$this->layout->view('ncredito',compact("establecimientos","nestablecimiento",'listas','inicio','fin','empresa','arqueoc'));
	}

  public function ncreditoi($id)
  {
    $anexos=explode(",",$this->session->userdata("establecimientos"));
    $establecimientos=$this->establecimiento_model->mostrarAcceso($anexos);
    $nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));

  	$empresa=$this->empresa_model->mostrar();
  	$datos=$this->venta_model->mostrar($id);
  	$detalles=$this->ventad_model->mostrarTotal($id);
  	$cobros=$this->cobroe_model->mostrar($id);

  	$tcreditos=$this->tcredito_model->mostrarTotal();
    $documento=substr($datos->serie,0,1);
		$nserie=$this->serie_model->mostrar(array("idestablecimiento"=>$this->session->userdata("predeterminado"),'tcomprobante'=>'07','SUBSTR(serie,1,1)'=>$documento));
		$existentes=$this->nota_model->mostrarTotal(array('idventa'=>$id,'tcomprobante'=>'07'),"desc");
		$this->layout->setTitle('Nota Credito');
		$this->layout->view('ncreditoi',compact("establecimientos","nestablecimiento",'nserie','tcreditos','datos','detalles',"cobros",'existentes','id'));
  }

  public function guardan($id)
  {
  	if ($this->input->post())
		{
			$empresa=$this->empresa_model->mostrar();
			if ($this->input->post('idproducto',true)==null) {
				$this->session->set_flashdata('css', 'danger');
				$this->session->set_flashdata('mensaje', 'No envio productos en la nota!');
			} else {
				$numero=$this->nota_model->maximo($this->input->post('serie',true));
				$ninicio= $numero==null ? '' : $numero->numero;
				$numeracion=$ninicio+1;

				$consulta=$this->nota_model->contador(array("serie"=>$this->input->post("serie",true),"numero"=>$numeracion));
				if ($consulta==0) {
					$comprobante=array
					(
						'idestablecimiento'	=>$this->session->userdata("predeterminado"),
						'iduser'						=>$this->session->userdata('id'),
						"grupo"         		=>$this->input->post('vcomprobante',true)=='01' ? '01' : '02',
						'tipo_soap'     		=>$empresa->tipo_soap,
						'femision'					=>$this->input->post('fecha',true),
						'hemision'					=>date('H:i:s'),
						'tcomprobante'			=>'07',
						'serie'							=>$this->input->post('serie',true),
						'numero'						=>$numeracion,
						'moneda'						=>'PEN',
						'tnota'							=>$this->input->post('tnota',true),
						'motivo'						=>$this->input->post('motivo',true),
						'idcliente'					=>$this->input->post('idcliente',true),
						'cliente'						=>$this->input->post('cliente',true),
						'tgravado'					=>$this->input->post('gravado',true),
						'tinafecto'					=>$this->input->post('inafecto',true),
						'texonerado'				=>$this->input->post('exonerado',true),
						"subtotal"					=>$this->input->post("gravado",true)+$this->input->post('inafecto',true)+$this->input->post('exonerado',true),
						'tigv'							=>$this->input->post('igv',true),
						'total'							=>$this->input->post('totalg',true),
						'idventa'						=>$id,
						"tipo_estado"				=>"01",
					);
					$insertar=$this->nota_model->insert($comprobante);

					if ($this->input->post('tpago',true)==1) {
						$datap=array
						(
							'idestablecimiento'	=>$this->session->userdata("predeterminado"),
							'iduser'						=>$this->session->userdata('id'),
							'idnota'						=>$insertar,
							'femision'					=>date('Y-m-d'),
							'total'							=>'-'.$this->input->post('totalg',true),
							'idtpago'						=>$this->input->post('mpago',true),
						);
						$insertarp=$this->cobron_model->insert($datap);
					}else{
						$datap=array('cancelado'=>1);
						$actualizac=$this->venta_model->update($datap,$id);
					}

					for ($i=0; $i < count($this->input->post('idproducto',true)) ; $i++) {
						if ($this->input->post('tipo',true)[$i]=='B') {
							$saldos=$this->kardex_model->ultimo($this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i]);
							$inicalf=$saldos==null ? 0: $saldos->saldof;
							$inicalv=$saldos==null ? 0: $saldos->saldov;

							//costos promedio
							$saldof=$inicalf+$this->input->post('almacenc',true)[$i];
							$saldov=$inicalv+$this->input->post('importe',true)[$i];
							$datak=array
							(
								'idestablecimiento'	=>$this->session->userdata("predeterminado"),
								'iduser'						=>$this->session->userdata('id'),
								'fecha'							=>date('Y-m-d'),
								"idtmovimiento"			=>1,
								'concepto'					=>'Nota de Credito',
								'idproducto'				=>$this->input->post('idproducto',true)[$i],
								'descripcion'				=>trim($this->input->post('descripcion',true)[$i]),
								'entradaf'					=>$this->input->post('almacenc',true)[$i],
								'saldof'						=>$saldof,
								'costo'							=>$this->input->post('almacenp',true)[$i],
								'entradav'					=>$this->input->post('importe',true)[$i],
								'saldov'						=>$saldov,
								'documento'					=>$this->input->post('serie',true).'-'.$numeracion,
							);
							$insertark=$this->kardex_model->insert($datak);

							$datas=array('stock'=>$saldof);
							$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$this->session->userdata("predeterminado"),"idproducto"=>$this->input->post('idproducto',true)[$i]));
						}

						$itemx=array
						(
							'idnota'			=>$insertar,
							'idproducto'	=>$this->input->post('idproducto',true)[$i],
							'descripcion'	=>trim($this->input->post('descripcion',true)[$i]),
							'unidad'			=>$this->input->post('unidad',true)[$i],
							'cantidad'		=>$this->input->post('cantidad',true)[$i],
							'valor'				=>$this->input->post('valor',true)[$i],
							'tprecio'			=>$this->input->post('tprecio',true)[$i],
							'precio'			=>$this->input->post('precio',true)[$i],
							'tafectacion'	=>$this->input->post('tafectacion',true)[$i],
							'total'				=>$this->input->post('total',true)[$i],
							'igv'					=>$this->input->post('vigv',true)[$i],
							'importe'			=>$this->input->post('importe',true)[$i],
							"calmacen"		=>$this->input->post("almacenc",true)[$i],
							"palmacen"		=>$this->input->post('almacenp',true)[$i],
							'lote'				=>$this->input->post('lote',true)[$i],
							'fvencimiento'=>$this->input->post('fvencimiento',true)[$i],
							'clote'				=>$this->input->post('clote',true)[$i],
						);
						$insertard=$this->notad_model->insert($itemx);

						if ($this->input->post('lote',true)[$i]!='') {
							$nlote=explode('|',$this->input->post('lote',true)[$i]);
							$flote=explode('|',$this->input->post('fvencimiento',true)[$i]);
							$clote=explode('|',$this->input->post('clote',true)[$i]);

							for ($l=0; $l < count($nlote) ; $l++) {
								$consultal=$this->lote_model->mostrar(array('idestablecimiento'=>$this->session->userdata("predeterminado"),'idproducto'=>$this->input->post('idproducto',true)[$i],'nlote'=>$nlote[$l]));

								if ($consultal==null) {
									$datal=array
									(
										'idestablecimiento'	=>$this->session->userdata("predeterminado"),
										'idproducto'				=>$this->input->post('idproducto',true)[$i],
										'nlote'							=>$nlote[$l],
										'fvencimiento'			=>valor_fecha($flote[$l]),
										'inicial'						=>$clote[$l],
										'stock'							=>$clote[$l],
									);
									$insertarl=$this->lote_model->insert($datal);
								} else {
									$datal=array('stock'=>$consultal->stock+$clote[$l]);
									$actualizar=$this->lote_model->update($datal,$this->session->userdata("predeterminado"),$this->input->post('idproducto',true)[$i],$nlote[$l]);
								}
							}
						}
					}

					$datat=array("estado" =>1,"emitido" =>NULL);
          $actualizar=$this->cotizacion_model->update($datat,array("emitido"=>$this->input->post('vnumero',true)));

					$nombrexml = $empresa->ruc.'-'.$comprobante['tcomprobante'].'-'.$comprobante['serie'].'-'.$comprobante['numero'];
			    if ($comprobante['grupo']=='01') {
		        $mensaje=$this->generadonXml($insertar);
			    }else{
			    	$datav=array
				    (
				      'filename'  =>$nombrexml,
				      'has_pdf'   =>1,
				    );
				    $actualizar=$this->nota_model->update($datav,$insertar);
            $mensaje='Se genero comprobante '.$comprobante['serie'].'-'.$comprobante['numero'];
			    }

					$this->session->set_flashdata('css', 'success');
					$this->session->set_flashdata('mensaje', $mensaje);

	        self::pdfnticket($insertar);
	        echo "<script>window.open('".base_url()."downloads/pdf/".$nombrexml.".pdf','_blank');</script>";
				} else {
					$this->session->set_flashdata("css", "danger");
					$this->session->set_flashdata("mensaje", "El comprobante ya existe");
				}
			}
			echo "<script>location.href ='".base_url()."venta/ncredito'; </script>";
		}
  }

  public function itemsNota($id)
  {
    $detalles=$this->notad_model->mostrarTotal($id);
    foreach ($detalles as $detalle) {
      $itemx=array
      (
        'idnota'         	=>$id,
        'idproducto'      =>$detalle->idproducto,
        'descripcion'     =>$detalle->descripcion,
        'unidad'          =>$detalle->unidad,
        'cantidad'        =>$detalle->cantidad,
        'valor'           =>$detalle->valor,
        'tafectacion'     =>$detalle->tafectacion,
        'tprecio'         =>$detalle->tprecio,
        'precio'          =>$detalle->precio,
        'total'           =>$detalle->total,
        'igv'             =>$detalle->igv,
        'importe'         =>$detalle->importe,
      );

      if ($detalle->tafectacion == 10) {
        $itemx['codigo_tributo']=array("S","1000","IGV","VAT");
      }
      elseif ($detalle->tafectacion == 20) {
        $itemx['codigo_tributo']=array("E","9997","EXO","VAT");
      }
      elseif ($detalle->tafectacion == 30) {
        $itemx['codigo_tributo']=array("O","9998","INA","FRE");
      }
      elseif ($detalle->tafectacion == 40) {
        $itemx['codigo_tributo']=array("G","9995","EXP","FRE");
      }
      else{
        $itemx['codigo_tributo']=array("Z","9996","GRA","FRE");
      }
      $datos[]=$itemx;
    }
    return $datos;
  }

  public function generadonXml($id)
  {
    $empresa=$this->empresa_model->mostrar();
    $datos=$this->nota_model->mostrar($id);
    $venta=$this->venta_model->mostrar($datos->idventa);
    $comprobante=array
    (
      'femision'          =>$datos->femision,
      'hemision'          =>$datos->hemision,
      'tcomprobante'      =>$datos->tcomprobante,
      'serie'             =>$datos->serie,
      'numero'            =>$datos->numero,
      'moneda'            =>$datos->moneda,
      'tnota'        			=>$datos->tnota,
      'motivo'    				=>$datos->motivo,
      'tgravado'          =>$datos->tgravado,
      'texonerado'        =>$datos->texonerado,
      'tinafecto'         =>$datos->tinafecto,
      'subtotal'          =>$datos->subtotal,
      'tigv'              =>$datos->tigv,
      'total'           	=>$datos->total,
      'treferencia'   		=>$venta->tcomprobante,
      'referencia'        =>$venta->serie.'-'.$venta->numero,
    );

    $nombrexml = $empresa->ruc.'-'.$datos->tcomprobante.'-'.$datos->serie.'-'.$datos->numero;
    $ruta_xml = "downloads/xml/".$nombrexml;
    $emisor=$this->emisor();
    $cliente=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
    $detalle=$this->itemsNota($id);
    $this->generadoXML->CrearXMLNotaCredito($ruta_xml, $emisor, $cliente, $comprobante, $detalle);

    $ruta_certificado = "downloads/certificado/".$empresa->certificado;
    $hash = $this->firmadoXML->FirmarDocumento($ruta_xml,$ruta_certificado,$empresa->certificado_clave);

    $datav=array
    (
      'filename'  =>$nombrexml,
      'hash'      =>$hash,
      'has_xml'   =>1,
      'has_pdf'   =>1,
    );
    $actualizar=$this->nota_model->update($datav,$id);
    return 'Se genero comprobante '.$datos->serie.'-'.$datos->numero;
  }

	public function pdfnticket($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nota_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->notad_model->mostrarTotal($id);
		$docafectado=$this->venta_model->mostrar($datos->idventa);
		$tiponota=$datos->tcomprobante=='07' ? $this->tcredito_model->mostrar($datos->tnota) : $this->tdebito_model->mostrar($datos->tnota) ;
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfnticket",compact("empresa","nestablecimiento","datos","clientes","detalles","docafectado","tiponota","nombre"));
	}

	public function pdfnformato($id)
	{
		$nestablecimiento=$this->establecimiento_model->mostrar($this->session->userdata("predeterminado"));
		$empresa=$this->empresa_model->mostrar();
		$datos=$this->nota_model->mostrar($id);
		$clientes=$this->cliente_model->mostrar(array("c.id"=>$datos->idcliente));
		$detalles=$this->notad_model->mostrarTotal($id);
		$docafectado=$this->venta_model->mostrar($datos->idventa);
		$tiponota=$datos->tcomprobante=='07' ? $this->tcredito_model->mostrar($datos->tnota) : $this->tdebito_model->mostrar($datos->tnota) ;
		$nombre= $this->usuario_model->mostrar($datos->iduser);
		$this->layout->setLayout("blanco");
		$this->layout->view("pdfnformato",compact("empresa","nestablecimiento","datos","clientes","detalles","docafectado","tiponota","nombre"));
	}

	public function consultan($id)
	{
		$datos=$this->nota_model->mostrar($id);
		$detalles=$this->notad_model->mostrarTotal($id);
		$this->layout->setLayout("blanco");
		$this->layout->view("consultan",compact("datos","detalles"));
	}

	/*====================================================================================================================
	=                                              anulaciones de documentos                                             =
	====================================================================================================================*/
  public function anulacion($id)
  {
    $datos=$this->venta_model->mostrar($id);
    if ($datos->tipo_estado<'09' && $datos->nulo==0) {
      $datav=array("nulo"=>1);
      $actualizar=$this->venta_model->update($datav,$id);

      $datap=array("nulo"=>1,"total"=>"0.00");
      $actualizap=$this->cobroe_model->update($datap,array("idventa"=>$id));

      $elimnarp=$this->clientep_model->delete(array("idventa"=>$id));

      $datat=array("estado"	=>1,"emitido"	=>NULL);
      $actualizar=$this->cotizacion_model->update($datat,array("emitido"=>$datos->serie.'-'.$datos->numero));

      $devolver=$this->devolucionv($id);
      echo "borrado";
    }else{
      echo "no borrado";
    }
  }

	public function devolucionv($id)
	{
		/*----------  devolucion de venta  ----------*/
		$datos=$this->venta_model->mostrar($id);
		$detalles=$this->ventad_model->mostrarTotal($id);
		foreach ($detalles as $detalle) {
			$productos=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));

			if ($productos->tipo=='B') {
				$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
				$inicalf=$saldos==null ? 0: $saldos->saldof;
				$inicalv=$saldos==null ? 0: $saldos->saldov;
				//costos promedio
				$salidav=$detalle->calmacen*$detalle->palmacen;

				$saldof=$inicalf+$detalle->calmacen;
				$saldov=$inicalv+$salidav;
				$datak=array
				(
					"idestablecimiento"	=>$datos->idestablecimiento,
					"iduser"						=>$this->session->userdata('id'),
					"fecha"							=>date("Y-m-d"),
					"idtmovimiento"			=>1,
					"concepto"					=>"Anulacion Venta",
					"idproducto"				=>$detalle->idproducto,
					"descripcion"				=>$detalle->descripcion,
					"entradaf"					=>$detalle->calmacen,
					"saldof"						=>$saldof,
					"costo"							=>$detalle->palmacen,
					"entradav"					=>$salidav,
					"saldov"						=>$saldov,
					"documento"					=>$datos->serie."-".$datos->numero,
				);
				//var_dump($datak);
				$insertark=$this->kardex_model->insert($datak);

				$datas=array("stock"=>$saldof);
				$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

				//devolucion de lotes
				if ($detalle->lote!='') {
					$nlote=explode("|",$detalle->lote);
					$flote=explode("|",$detalle->fvencimiento);
					$clote=explode("|",$detalle->clote);

					for ($l=0; $l < count($nlote) ; $l++) {
						$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlote[$l]));

						if ($consultal==null) {
							$datal=array
							(
								"idestablecimiento"	=>$datos->idestablecimiento,
								"idproducto"				=>$detalle->idproducto,
								"nlote"							=>$nlote[$l],
								"fvencimiento"			=>valor_fecha($flote[$l]),
								"inicial"						=>$clote[$l],
								"stock"							=>$clote[$l],
							);
							$insertarl=$this->lote_model->insert($datal);
						} else {
							$datal=array("stock"=>$consultal->stock+$clote[$l]);
							$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlote[$l]);
						}
					}
				}
			}
		}
	}

	public function anulacionn($id)
  {
    $datos=$this->nota_model->mostrar($id);
    if ($datos->tipo_estado<'09' && $datos->nulo==0) {
      $datav=array("nulo"=>1);
      $actualizar=$this->nota_model->update($datav,$id);

      $datap=array("nulo"=>1,"total"=>"0.00");
      $actualizap=$this->cobron_model->update($datap,array("idnota"=>$id));

      $devolver=$this->devolucionn($id);
      echo "borrado";
    }else{
      echo "no borrado";
    }
  }

	public function devolucionn($id)
	{
		/*----------  devolucion de nota  ----------*/
		$datos=$this->nota_model->mostrar($id);
		if ($datos->tcomprobante=="07") {
			$detalles=$this->notad_model->mostrarTotal($id);
			foreach ($detalles as $detalle) {
				$productos=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));

				if ($productos->tipo=='B') {
					$saldos=$this->kardex_model->ultimo($datos->idestablecimiento,$detalle->idproducto);
					$inicalf=$saldos==null ? 0: $saldos->saldof;
					$inicalv=$saldos==null ? 0: $saldos->saldov;
					//costos promedio
					$costo=$inicalf==0 ? 0 : round($inicalv/$inicalf,4);
					$salidav=$detalle->calmacen*$costo;

					$saldof=$inicalf-$detalle->calmacen;
					$saldov=$inicalv-$salidav;
					$datak=array
					(
						"idestablecimiento"	=>$datos->idestablecimiento,
						"iduser"						=>$this->session->userdata('id'),
						"fecha"							=>date("Y-m-d"),
						"idtmovimiento"			=>1,
						"concepto"					=>"Anulacion ".$datos->ncomprobante,
						"idproducto"				=>$detalle->idproducto,
						"descripcion"				=>$detalle->descripcion,
						"salidaf"						=>$detalle->calmacen,
						"saldof"						=>$saldof,
						"costo"							=>$costo,
						"salidav"						=>$salidav,
						"saldov"						=>$saldov,
						"documento"					=>$datos->serie."-".$datos->numero,
					);
					//var_dump($datak);
					$insertark=$this->kardex_model->insert($datak);

					$datas=array("stock"=>$saldof);
					$actualizar=$this->inventario_model->update($datas,array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto));

					//devolucion de lotes
					if ($detalle->lote!='') {
						$nlotes=explode("|",$detalle->lote);
						$clote=explode("|",$detalle->clote);
						for ($l=0; $l < count($nlotes) ; $l++) {
							$consultal=$this->lote_model->mostrar(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlotes[$l]));
							$saldoc=$consultal->stock-$clote[$l];	//saldo a guardar

							if ($saldoc>0) {
								$datal=array('stock'=>$saldoc);
								$actualizar=$this->lote_model->update($datal,$datos->idestablecimiento,$detalle->idproducto,$nlotes[$l]);
							} else {
								$elimnarl=$this->lote_model->delete(array("idestablecimiento"=>$datos->idestablecimiento,"idproducto"=>$detalle->idproducto,"nlote"=>$nlotes[$l]));
							}
						}
					}
				}
			}
		}
	}




}
