<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kardex_model extends CI_Model
{
	public $table = "kardex";
	public function __construct()
	{
		parent::__construct();
	}

	public function mostrarTotal($filtros)
	{
		$query=$this->db
				->select("id, fecha, concepto, idproducto, descripcion, entradaf, salidaf, saldof, costo, entradav, salidav, saldov, documento, fregistro")
				->from($this->table)
				->where($filtros)
				->get();
		return $query->result();
	}

	public function mostrarProducto($anexo,$fecha)
	{
		$query=$this->db
				->select("idproducto")
				->from($this->table)
				->where(array("idestablecimiento"=>$anexo,"fecha"=>$fecha))
				->group_by("idproducto")
				->get();
		return $query->result();
	}

	public function mostrar($id)
	{
		$query=$this->db
				->select("id, idestablecimiento, fecha, concepto, idproducto, descripcion, entradaf, salidaf, saldof, costo, entradav, salidav, saldov, documento, fregistro")
				->from($this->table)
				->where(array("id"=>$id))
				->get();
		//echo $this->db->last_query();exit;
		return $query->row();
	}

	public function insert($data=array())
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($data=array(),$id)
	{
		$this->db->where(array("id"=>$id));
		$this->db->update($this->table, $data);
	}

	public function delete($anexo,$idproducto)
	{
		$this->db->where(array("idestablecimiento"=>$anexo,"idproducto"=>$idproducto));
		$this->db->delete($this->table);
	}

	public function contador($anexo,$idproducto)
	{
		$this->db->from($this->table)->where(array("idestablecimiento"=>$anexo,"idproducto"=>$idproducto));
		return $this->db->count_all_results();
	}

	public function ultimo($anexo,$idproducto)
	{
		$query=$this->db
				->select("saldof, costo, saldov")
				->from($this->table)
				->where(array("idestablecimiento"=>$anexo,"idproducto"=>$idproducto))
				->limit(1)
				->order_by("id","desc")
				->get();
		return $query->row();
	}


}
