<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuario_model extends CI_Model
{
	public $table = "usuarios";
	public function __construct()
	{
		parent::__construct();
	}

	public function login($user,$pass)
	{		
		$query=$this->db
				->select("id, nombres, usuario, clave, tipo, idestablecimiento, predeterminadoe")
				->from($this->table)
				->where(array("usuario"=>$user,"clave"=>$pass,"estado"=>1))
				->get();
		return $query->row();
	}

	public function mostrarTotal()
	{		
		$query=$this->db
				->select("id, nombres, estado, tipo, usuario, idestablecimiento, predeterminadoe")
				->from($this->table)
				->order_by("id","desc")
				->get();
		return $query->result();
	}

	public function mostrar($id)
	{		
		$query=$this->db
				->select("id, nombres, usuario, clave, tipo, estado, idestablecimiento, predeterminadoe")
				->from($this->table)
				->where(array("id"=>$id))
				->get();
		return $query->row();
	}

	public function insert($data=array())
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($data=array(),$id)
	{
		$this->db->where("id",$id);
		$this->db->update($this->table, $data);
	}

	public function delete($id)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->table);
	}

	public function contador($dato)
	{
		$this->db->from($this->table)->where("usuario", $dato);
		return $this->db->count_all_results();
	}

	public function activos()
	{
		$query=$this->db
				->select("id, nombres, estado, usuario, idestablecimiento, predeterminadoe")
				->from($this->table)
				->where(array("estado"=>1))
				->order_by("nombres","asc")
				->get();
		return $query->result();
	}

}
