<section class="content-header pb-1">
  <div class="container-fluid">
    <div class="row mb-0">
      <div class="col-sm-6">
        <h4 class="m-0 text-dark">Kardex</h4>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><i class="fa fa-home"></i> <b class="text-danger"><?php echo $nestablecimiento->descripcion ?></b></li>
          <li class="breadcrumb-item">Consulta</li>
          <li class="breadcrumb-item active">Kardex</li>
        </ol>
      </div>
    </div>
  </div>
</section>

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card card-outline">
          <div class="card-header py-2">
            <ul class="nav nav-pills">
              <li class="nav-item"><a class="nav-link py-1 border border-info" href="<?php echo base_url(); ?>consulta/kardex">General</a></li>
              <li class="nav-item"><a class="nav-link py-1 ml-1 border border-info" href="<?php echo base_url(); ?>consulta/producto">Producto</a></li>
              <li class="nav-item"><a class="nav-link py-1 ml-1 active" href="<?php echo base_url(); ?>consulta/lote">Por Lotes</a></li>
            </ul>
          </div>
          <div class="card-body p-3">
            <?php echo form_open(null,array("class"=>"form-horizontal","name"=>"form1", "id"=>"form1")); ?>
              <?php
              $idproducto = $envio_datos!=null ? $envio_datos["idproducto"] : "" ;
              $descripcion = $envio_datos!=null ? $envio_datos["descripcion"] : "" ;
              ?>
              <div class="form-group row mb-2">
                <label class="col-sm-1 control-label">Producto</label>
                <input name="idproducto" id="idproducto" type="hidden" value="<?php echo $idproducto ?>" required>
                <div class="col-sm-6">
                  <div class="input-group">
                    <input name="descripcion" type="text" id="descripcion" placeholder="Buscar Nombre del producto" class="form-control form-control-sm" onkeyup="productoNombre('<?php echo base_url(); ?>producto/busProductos',this.value)" autocomplete="off" value="<?php echo $descripcion ?>" autofocus required>
                    <div class="input-group-append">
                      <span class="input-group-text" id="basic-addon1"><i class="fa fa-search" aria-hidden="true"></i></span>
                    </div>
                    </div>

                    <div id="tblProducto" style="position:absolute; z-index: 1051; width: 98%; overflow: overlay; max-height:250px; display: none;">
                      <dl class="bg-buscador" id="grproducto">
                      </dl>
                    </div>
                  </div>

                <div class="col-sm-1 offset-1">
                  <button type="submit" class="btn btn-primary btn-sm">Buscar</button>
                </div>
              </div>
            <?php echo form_close(); ?>

            <div class="table-responsive" style="height: 430px;">
              <table class="table table-hover table-sm">
                <thead class="thead-dark">
                  <tr>
                    <th width="5%">#</th>
                    <th width="10%">Codigo</th>
                    <th width="40%">Nombre</th>
                    <th width="10%">Stock</th>
                    <th width="15%">Lote</th>
                    <th width="10%">Vcto</th>
                    <th width="10%">Dias x vencer</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i=1; ?>
                  <?php foreach ($listas as $lista) { ?>
                    <tr>
                      <td><?php echo $i; ?></td>
                      <td><?php echo $idproducto; ?></td>
                      <td><?php echo $descripcion; ?></td>
                      <td><?php echo $lista->stock ?></td>
                      <td><?php echo $lista->nlote; ?></td>
                      <td><?php echo formatoFecha($lista->fvencimiento); ?></td>
                      <td><?php echo diferenciaFecha($lista->fvencimiento,date("Y-m-d")); ?></td>
                    </tr>
                    <?php $i++; ?>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="busdatos">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-1">
        <h5 class="modal-title" id="modalTitle">Datos de la consulta</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body p-3">
        <div name="bdatos" id="bdatos">

        </div>
      </div>
    </div>
  </div>
</div>

