<section class="content-header pb-1">
  <div class="container-fluid">
    <div class="row mb-0">
      <div class="col-sm-6 mb-3">
        <h4 class="m-0 text-dark">Cotizacion de Venta</h4>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><i class="fa fa-home"></i> <b class="text-danger"><?php echo $nestablecimiento->descripcion ?></b></li>
          <li class="breadcrumb-item">Venta</li>
          <li class="breadcrumb-item active"><a href="<?php echo base_url(); ?>cotizacion">Cotizacion</a></li>
        </ol>
      </div>
    </div>
  </div>
</section>

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card card-outline">
          <div class="card-body p-3">
            <?php if($this->session->flashdata('mensaje')!=''){ ?>
              <div class="alert alert-<?php echo $this->session->flashdata('css') ?> alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo $this->session->flashdata('mensaje') ?>
              </div>
            <?php } ?>

            <?php echo form_open(null,array("class"=>"form-horizontal","name"=>"form1", "id"=>"form1", "autocomplete"=>"off")); ?>
              <div class="row">
                <div class="col-sm-6">
                  <div class="row mb-2">
                    <div class="col-sm-2 col-6">
                    </div>

                    <div class="col-sm-3 col-6">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-barcode"></i></span>
                        </div>
                        <input id="codbarra" type="text" class="form-control form-control-sm" placeholder="Precio Unidad" aria-label="Codigo Barra" aria-describedby="basic-addon1" onfocus="limpiarBuscadorn('<?php echo base_url(); ?>producto/busProductos')" onkeydown="productoBarran(event,'<?php echo base_url(); ?>producto/busCodigobarra',this.value);">
                      </div>
                    </div>

                    <div class="col-sm-7">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-search" aria-hidden="true"></i></span>
                        </div>
                        <input name="bproducto" type="text" id="bproducto" class="form-control form-control-sm" value="" placeholder="Buscar Producto" onkeyup="productoNombren('<?php echo base_url(); ?>producto/busProductos',this.value)" autofocus>
                      </div>
                    </div>
                  </div>

                  <div class="table-responsive border border-dark" style="height: 340px; font-size: .79rem">
                    <table class="table table-striped table-hover table-sm">
                      <thead class="thead-dark">
                        <tr>
                          <th class="priority" width="6%">COD</th>
                          <th width="51%">PRODUCTO</th>
                          <th class="priority" width="6%">FACT</th>
                          <th width="7%">CAN</th>
                          <th width="10%">P. UNID</th>
                          <th width="10%">P. BLIS</th>
                          <th width="10%">P. CAJA</th>
                        </tr>
                      </thead>
                      <tbody id="grproducto">
                        <?php foreach ($productos as $producto): ?>
                          <?php
                          $nproducto=$producto->descripcion;
                          if ($producto->nlaboratorio!='') {$nproducto.=' ['.$producto->nlaboratorio.']';}
                          $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
                          $pventa=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
                          $pblister=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
                          $venta=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;
                          ?>
                          <tr <?php if ($cantidad->stock<1): ?>style="color: #dc3545;"<?php endif ?>>
                            <td class="priority"><?php echo $producto->id; ?></td>
                            <td><?php echo $nproducto; ?></td>
                            <td class="priority"><b><?php echo $producto->factor; ?></b></td>
                            <td><?php echo $cantidad->stock; ?></td>
                            <td align="right"><a href="javascript:void(0)" onclick="appcotizacion('<?php echo $producto->id; ?>', `<?php echo $nproducto; ?>`,'<?php echo 'NIU'; ?>','<?php echo 1; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pventa; ?>','<?php echo $cantidad->stock; ?>');" class="btn btn-info btn-sm py-0" title="Click para seleccionar"><?php echo $pventa; ?></a></td>
                            <td align="right">
                              <?php if ($producto->factorb>1 && $pblister>0): ?>
                              <a href="javascript:void(0)" onclick="appcotizacion('<?php echo $producto->id; ?>', `<?php echo $nproducto.' BLISTER X '.$producto->factorb; ?>`,'<?php echo 'BL'; ?>','<?php echo $producto->factorb; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pblister; ?>','<?php echo $cantidad->stock; ?>');" class="btn btn-primary btn-sm py-0" title="Click para seleccionar"><?php echo $pblister; ?></a>
                              <?php endif ?>
                            </td>
                            <td align="right">
                              <?php if ($producto->factor>1 && $venta>0): ?>
                              <a href="javascript:void(0)" onclick="appcotizacion('<?php echo $producto->id; ?>', `<?php echo $nproducto.' CJ X '.$producto->factor; ?>`,'<?php echo 'BX'; ?>','<?php echo $producto->factor; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $venta; ?>','<?php echo $cantidad->stock; ?>');" class="btn btn-success btn-sm py-0" title="Click para seleccionar"><?php echo $venta; ?></a>
                              <?php endif ?>
                            </td>
                          </tr>
                        <?php endforeach ?>
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="col-sm-6">
                  <hr class="m-2" style="border-bottom: solid #17a2b8;">
                  <div class="table-responsive table-striped p-0 border border-info" style="height: 330px;">
                    <table class="table table-head-fixed text-nowrap table-sm">
                      <tbody id="grilla">
                      </tbody>
                    </table>
                  </div>

                  <table>
                    <tr>
                      <td width="24%" align="right"><strong></strong></td>
                      <td width="23%"></td>
                      <td width="24%" align="right"><strong>TOTAL S./</strong></td>
                      <td width="29%">
                        <h4><input name="totalg" type="text" id="totalg" class="campo text-right" value=""/></h4>
                      </td>
                    </tr>
                  </table>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group row mb-2 mt-3">
                    <label for="tvalidez" class="col-sm-3 col-6 control-label">Tiempo Validez</label>
                    <div class="col-sm-3 col-6">
                      <input name="tvalidez" type="text" id="tvalidez" class="form-control form-control-sm">
                    </div>

                    <label for="tentrega" class="col-sm-3 col-6 control-label">Tiempo Entrega</label>
                    <div class="col-sm-3 col-6">
                      <input name="tentrega" type="text" id="tentrega" class="form-control form-control-sm">
                    </div>
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group row mb-2 mt-3">
                    <label for="idcliente" class="col-sm-2 col-6 control-label">Cliente*</label>

                    <input name="idcliente" id="idcliente" type="hidden" value="1"/>
                    <input name="tdocumento" id="tdocumento" type="hidden" value="0"/>
                    <div class="col-sm-3 col-6">
                      <input type="text" name="dni" id="dni" class="form-control form-control-sm" value="" onkeydown="bcliente(event,'<?php echo base_url(); ?>cliente/busDocumento',this.value,'P');" onclick="this.select();" placeholder="DNI O RUC">
                    </div>

                    <div class="col-sm-7">
                      <div class="input-group">
                        <input name="cliente" type="text" id="cliente" class="form-control form-control-sm" value="CLIENTES VARIOS" aria-label="cliente" aria-describedby="basic-addon2" onkeyup="clienteNombre('<?php echo base_url(); ?>cliente/busCliente',this.value,'P')"  onclick="this.select();" placeholder="Nombre o Razon Social" required>
                        <div class="input-group-append">
                          <button type="button" class="btn btn-info btn-sm" onclick="mostrarCliente('<?php echo base_url(); ?>venta/clientei','nuevo','Datos del Cliente')"><i class="fa fa-plus"></i></button>
                        </div>
                      </div>

                      <div id="tblcliente" style="position:absolute; z-index: 1051; width: 95%; overflow: overlay; max-height:250px; display: none;">
                        <dl class="bg-buscador" id="grcliente">
                        </dl>
                      </div>
                    </div>
                  </div>

                  <div class="form-group col-sm-12 text-center mb-2">
                    <button type="submit" class="btn btn-primary btn-sm ml-4">GUARDAR</button>
                  </div>
                </div>
              </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="busregistro">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
    <div class="modal-header py-1">
      <h5 class="modal-title" id="registroTitle">Datos del Cliente</h5>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">×</span>
      </button>
    </div>
    <div class="modal-body">
      <div name="bregistro" id="bregistro">

      </div>
    </div>
  </div>
  </div>
</div>

<div class="modal fade" id="busdatos">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-1">
        <h5 class="modal-title" id="modalTitle">Datos de la Serie</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body">
        <div name="bdatos" id="bdatos">

        </div>
      </div>
    </div>
  </div>
</div>
