<div class="content-header pb-1">
  <div class="container-fluid">
    <div class="row mb-0">
      <div class="col-sm-6 mb-3">
        <?php $anuo = date("Y");
        $mes = date("m"); ?>
        <h4 class="m-0 text-dark"><b>Bienvenido 😉 al panel de control - <?php echo $mes . '/' . $anuo; ?></b></h4>
      </div>
      <div class="col-sm-6 d-flex align-items-center justify-content-end">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-white mb-0 py-2 px-3 shadow-sm rounded">
        <li class="breadcrumb-item d-flex align-items-center">
          <i class="fa fa-home mr-1 text-primary"></i>
          <span class="font-weight-bold text-primary"><?php echo $nestablecimiento->descripcion ?></span>
        </li>
        <li class="breadcrumb-item active" aria-current="page">Inicio</li>
          </ol>
        </nav>
      </div>
    </div>
  </div>
</div>

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <?php if ($empresa->facturacion == 1): ?>
        <?php $rventa = $arqueoc > 0 ? base_url() . 'venta/ventai' : base_url() . 'venta'; ?>
        <div class="col-12 col-sm-6 col-md-2">
          <a href="<?php echo $rventa; ?>">
            <div class="card card-widget widget-user-2" style="border-radius: 0.5rem;">
              <div class="widget-user-header p-2 d-flex flex-row align-items-center" style="background: #6E62DF; color: white; border-radius: 0.5rem; height: 100%;">
                <div class="widget-user-image mr-2">
                  <img class="img-circle elevation-2" src="public/logo/ventas.png" alt="User Avatar" style="width: 55px;">
                </div>
                <h5 class="widget-user-desc m-0">
                  Nuevo CPE
                  <i class="fas fa-arrow-right ml-2"></i>
                </h5>
              </div>
            </div>
          </a>
        </div>
      <?php endif ?>

      <div class="col-12 col-sm-6 col-md-2">
        <?php $rnventa = $arqueoc > 0 ? base_url() . 'nventa/nventai' : base_url() . 'nventa'; ?>
        <a href="<?php echo $rnventa; ?>">
          <div class="card card-widget widget-user-2" style="border-radius: 0.5rem;">
            <div class="widget-user-header p-2 d-flex flex-row align-items-center" style="background: #00B67A; color: white; border-radius: 0.5rem; height: 100%;">
              <div class="widget-user-image mr-2">
                <img class="img-circle elevation-2" src="public/logo/ventas.png" alt="User Avatar" style="width: 55px;">
              </div>
              <h5 class="widget-user-desc m-0">
                Nota venta
                <i class="fas fa-arrow-right ml-2"></i>
              </h5>
            </div>
          </div>
        </a>
      </div>

      <div class="col-12 col-sm-6 col-md-2">
        <?php $rcompra = $arqueoc > 0 ? base_url() . 'compra/comprai' : base_url() . 'compra'; ?>
        <a href="<?php echo $rcompra; ?>">
          <div class="card card-widget widget-user-2" style="border-radius: 0.5rem;">
            <div class="widget-user-header p-2 d-flex flex-row align-items-center" style="background:rgb(70, 116, 218); color: white; border-radius: 0.5rem; height: 100%;">
              <div class="widget-user-image mr-2">
                <img class="img-circle elevation-2" src="public/logo/compras.png" alt="User Avatar" style="width: 55px;">
              </div>
              <h5 class="widget-user-desc m-0">
                Compra
                <i class="fas fa-arrow-right ml-2"></i>
              </h5>
            </div>
          </div>
        </a>
      </div>

      <div class="col-12 col-sm-6 col-md-3">
        <div class="info-box">
          <span class="info-box-icon elevation-1" style="background: #00B67A;"><i class="fas fa-file-alt text-white"></i></span>
          <div class="info-box-content">
            <span class="info-box-text">Total Notas Ventas</span>
            <span class="info-box-number" style="font-size: 1.2rem;">
              S/
              <?php echo $totaln = $ntotal->total ?? 0; ?>
            </span>
          </div>
        </div>
      </div>

      <?php if ($empresa->facturacion == 1): ?>
        <div class="col-12 col-sm-6 col-md-3">
          <div class="info-box">
            <span class="info-box-icon elevation-1" style="background: #00B67A;"><i class="fas fa-file-pdf text-white"></i></span>
            <div class="info-box-content">
              <span class="info-box-text">Total Comprobantes</span>
              <span class="info-box-number" style="font-size: 1.2rem;">
                S/
                <?php echo $totalc = ($vtotal->total ?? 0) - ($dtotal->total ?? 0); ?>
              </span>
            </div>
          </div>
        </div>
      <?php endif ?>

      <div class="col-sm-6">
        <div class="card card-outline">
          <div class="card-header">
            <h3 class="card-title">Alertas de Fechas de Vencimiento:</h3>
          </div>

          <div class="card-body p-0">
            <table class="table table-hover">
              <tbody>
                <?php foreach ($fecvencimientos as $fecvencimiento): ?>
                  <tr data-widget="expandable-table" aria-expanded="false">
                    <td>
                      <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                      <?php echo $fecvencimiento->fecha; ?>
                    </td>
                  </tr>
                  <tr class="expandable-body">
                    <td>
                      <div class="p-0" style="display: none;">
                        <?php
                        $fecha = explode('-', $fecvencimiento->fecha);
                        $nlotes = $this->lote_model->productosVencer(array("idestablecimiento" => $this->session->userdata("predeterminado"), 'year(fvencimiento)' => $fecha[0], 'month(fvencimiento)' => $fecha[1], "estado" => 1, "stock>" => 0));
                        ?>
                        <div class="table-responsive" style="height: 440px; font-size: .78rem;">
                          <table class="table table-hover table-sm table-striped">
                            <thead class="thead-dark">
                              <tr>
                                <th align="center" width="5%"><strong>#</strong></th>
                                <th align="center" width="60%"><strong>Descripcion</strong></th>
                                <th align="center" width="10%"><strong>Lote</strong></th>
                                <th align="center" width="15%"><strong>F. Vcto</strong></th>
                                <th align="center" width="10%"><strong>Cantidad</strong></th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php $i = 1; ?>
                              <?php foreach ($nlotes as $nlote): ?>
                                <?php
                                $nproducto = $nlote->descripcion;
                                if ($nlote->nlaboratorio != '') {
                                  $nproducto .= ' [' . $nlote->nlaboratorio . ']';
                                }
                                ?>
                                <tr>
                                  <td width="5%"><?php echo $i; ?></td>
                                  <td width="60%"><?php echo $nproducto; ?></td>
                                  <td width="10%"><?php echo $nlote->lote; ?></td>
                                  <td width="15%"><?php echo $nlote->fvencimiento; ?></td>
                                  <td width="10%" align="center"><?php echo $nlote->stock; ?></td>
                                </tr>
                                <?php $i++; ?>
                              <?php endforeach ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endforeach ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <div class="col-sm-6">
        <div class="card card-outline">
          <div class="card-header">
            <h3 class="card-title">Alertas de Stocks Mínimos:</h3>
          </div>

          <div class="card-body p-0">
            <table class="table table-hover">
              <tbody>
                <?php
                $pocas = $this->inventario_model->productosMinimo(array("idestablecimiento" => $this->session->userdata("predeterminado"), "estado" => 1, "mstock>" => 0, "(stock-mstock)<" => 1, "stock>" => 0));
                ?>
                <?php if ($pocas != NULL): ?>
                  <tr data-widget="expandable-table" aria-expanded="false">
                    <td>
                      <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                      Pocas existencias
                    </td>
                  </tr>
                  <tr class="expandable-body">
                    <td>
                      <div class="p-0" style="display: none;">
                        <div class="table-responsive" style="height: 440px; font-size: .78rem;">
                          <table class="table table-hover table-sm table-striped">
                            <thead class="thead-dark">
                              <tr>
                                <th align="center" width="5%"><strong>#</strong></th>
                                <th align="center" width="75%"><strong>Descripcion</strong></th>
                                <th align="center" width="10%"><strong>Minimo</strong></th>
                                <th align="center" width="10%"><strong>Cantidad</strong></th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php $i = 1; ?>
                              <?php foreach ($pocas as $lista): ?>
                                <?php
                                $nproducto = $lista->descripcion;
                                if ($lista->nlaboratorio != '') {
                                  $nproducto .= ' [' . $lista->nlaboratorio . ']';
                                }
                                ?>
                                <tr>
                                  <td width="5%"><?php echo $i; ?></td>
                                  <td width="75%"><?php echo $nproducto; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->mstock; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->stock; ?></td>
                                </tr>
                                <?php $i++; ?>
                              <?php endforeach ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endif ?>

                <?php
                $ningunas = $this->inventario_model->productosMinimo(array("idestablecimiento" => $this->session->userdata("predeterminado"), "estado" => 1, "mstock>" => 0, "(stock-mstock)<" => 1, "stock" => 0));
                ?>
                <?php if ($ningunas != NULL): ?>
                  <tr data-widget="expandable-table" aria-expanded="false">
                    <td>
                      <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                      No hay existencias
                    </td>
                  </tr>
                  <tr class="expandable-body">
                    <td>
                      <div class="p-0" style="display: none;">
                        <div class="table-responsive" style="height: 440px; font-size: .78rem;">
                          <table class="table table-hover table-sm table-striped">
                            <thead class="thead-dark">
                              <tr>
                                <th align="center" width="5%"><strong>#</strong></th>
                                <th align="center" width="75%"><strong>Descripcion</strong></th>
                                <th align="center" width="10%"><strong>Minimo</strong></th>
                                <th align="center" width="10%"><strong>Cantidad</strong></th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php $i = 1; ?>
                              <?php foreach ($ningunas as $lista): ?>
                                <?php
                                $nproducto = $lista->descripcion;
                                if ($lista->nlaboratorio != '') {
                                  $nproducto .= ' [' . $lista->nlaboratorio . ']';
                                }
                                ?>
                                <tr>
                                  <td width="5%"><?php echo $i; ?></td>
                                  <td width="75%"><?php echo $nproducto; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->mstock; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->stock; ?></td>
                                </tr>
                                <?php $i++; ?>
                              <?php endforeach ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endif ?>

                <?php
                $negativos = $this->inventario_model->productosMinimo(array("idestablecimiento" => $this->session->userdata("predeterminado"), "estado" => 1, "mstock>" => 0, "(stock-mstock)<" => 1, "stock<" => 0));
                ?>
                <?php if ($negativos != NULL): ?>
                  <tr data-widget="expandable-table" aria-expanded="false">
                    <td>
                      <i class="expandable-table-caret fas fa-caret-right fa-fw"></i>
                      Saldo Negativo
                    </td>
                  </tr>
                  <tr class="expandable-body">
                    <td>
                      <div class="p-0" style="display: none;">
                        <div class="table-responsive" style="height: 440px; font-size: .78rem;">
                          <table class="table table-hover table-sm table-striped">
                            <thead class="thead-dark">
                              <tr>
                                <th align="center" width="5%"><strong>#</strong></th>
                                <th align="center" width="75%"><strong>Descripcion</strong></th>
                                <th align="center" width="10%"><strong>Minimo</strong></th>
                                <th align="center" width="10%"><strong>Cantidad</strong></th>
                              </tr>
                            </thead>
                            <tbody>
                              <?php $i = 1; ?>
                              <?php foreach ($negativos as $lista): ?>
                                <?php
                                $nproducto = $lista->descripcion;
                                if ($lista->nlaboratorio != '') {
                                  $nproducto .= ' [' . $lista->nlaboratorio . ']';
                                }
                                ?>
                                <tr>
                                  <td width="5%"><?php echo $i; ?></td>
                                  <td width="75%"><?php echo $nproducto; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->mstock; ?></td>
                                  <td width="10%" align="center"><?php echo $lista->stock; ?></td>
                                </tr>
                                <?php $i++; ?>
                              <?php endforeach ?>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endif ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <div class="col-sm-6">
        <div class="card card-outline ">
          <div class="card-header">
            <h3 class="card-title">Ventas</h3>
          </div>
          <div class="card-body p-1">
            <div class="chart">
              <canvas id="barVenta" style="min-height: 400px; height: 400px; max-height: 400px; max-width: 100%;"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="col-sm-6">
        <div class="card card-outline ">
          <div class="card-header">
            <h3 class="card-title">Compras</h3>
          </div>
          <div class="card-body p-1">
            <div class="chart">
              <canvas id="barCompra" style="min-height: 400px; height: 400px; max-height: 400px; max-width: 100%;"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="col-sm-4">
        <div class="card card-outline ">
          <div class="card-header">
            <h3 class="card-title">Nota Venta</h3>
          </div>
          <div class="card-body p-2">
            <div class="chart">
              <canvas id="doughnutNventa"></canvas>
            </div>
          </div>
        </div>
      </div>

      <?php if ($empresa->facturacion == 1): ?>
        <div class="col-sm-4">
          <div class="card card-outline">
            <div class="card-header">
              <h3 class="card-title">Comprobante</h3>
            </div>
            <div class="card-body p-2">
              <div class="chart">
                <canvas id="doughnutComprobante"></canvas>
              </div>
            </div>
          </div>
        </div>
      <?php endif ?>

      <div class="col-sm-4">
        <div class="card card-outline ">
          <div class="card-header">
            <h3 class="card-title">Compra</h3>
          </div>
          <div class="card-body p-2">
            <div class="chart">
              <canvas id="doughnutCompra"></canvas>
            </div>
          </div>
        </div>
      </div>

      <div class="col-12 d-none d-sm-block">
        <div class="card card-outline ">
          <div class="card-header">
            <h3 class="card-title">Ventas Emitidas <?php echo $mes . '/' . $anuo; ?></h3>
          </div>

          <div class="card-body p-0">
            <table class="table table-hover table-bordered table-sm table-info" style="font-size: .72rem;">
              <thead>
                <tr>
                  <th width="5%" class="pl-1">Dias</th>
                  <?php
                  $finicio = '01-' . date("m") . '-' . date("Y");
                  $ndias = cal_days_in_month(CAL_GREGORIAN, date("m"), date("Y"));
                  $ancho = 95 / $ndias;
                  ?>
                  <?php for ($i = 0; $i < $diasmes; $i++) {  ?>
                    <?php $fecha = SumarFecha('+' . $i . ' day', $finicio); ?>
                    <th width="<?php echo $ancho; ?>" class="pr-1" <?php if ($fecha == date("Y-m-d")) {
                                                                      echo 'class="table-danger"';
                                                                    } ?>><?php echo date("d", strtotime($fecha)); ?></th>
                  <?php } ?>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td class="pl-1">Nota Venta</td>
                  <?php for ($i = 0; $i < $diasmes; $i++) {  ?>
                    <?php
                    $fecha = SumarFecha('+' . $i . ' day', $finicio);
                    if ($this->session->userdata("tipo") == 'admin') {
                      $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), "nulo" => 0, 'femision' => $fecha);
                    } else {
                      $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), 'iduser' => $this->session->userdata("id"), "nulo" => 0, 'femision' => $fecha);
                    }
                    $ntotal = $this->nventa_model->montoTotal($filtros);
                    ?>
                    <td align="right" class="pr-1" <?php if ($fecha == date("Y-m-d")) {
                                                      echo 'class="table-danger"';
                                                    } ?>><?php echo $ntotal->total ?? ''; ?></td>
                  <?php } ?>
                </tr>
                <?php if ($empresa->facturacion == 1): ?>
                  <tr>
                    <td class="pl-1">BV/Factura</td>
                    <?php for ($i = 0; $i < $diasmes; $i++) {  ?>
                      <?php
                      $fecha = SumarFecha('+' . $i . ' day', $finicio);
                      if ($this->session->userdata("tipo") == 'admin') {
                        $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), "nulo" => 0, 'femision' => $fecha);
                      } else {
                        $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), 'iduser' => $this->session->userdata("id"), "nulo" => 0, 'femision' => $fecha);
                      }
                      $vtotal = $this->venta_model->montoTotal($filtros);
                      ?>
                      <td align="right" class="pr-1" <?php if ($fecha == date("Y-m-d")) {
                                                        echo 'class="table-danger"';
                                                      } ?>><?php echo $vtotal->total ?? ''; ?></td>
                    <?php } ?>
                  </tr>
                  <tr>
                    <td class="pl-1">Nota Credito</td>
                    <?php for ($i = 0; $i < $diasmes; $i++) {  ?>
                      <?php
                      $fecha = SumarFecha('+' . $i . ' day', $finicio);
                      if ($this->session->userdata("tipo") == 'admin') {
                        $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), "nulo" => 0, 'femision' => $fecha);
                      } else {
                        $filtros = array("idestablecimiento" => $this->session->userdata("predeterminado"), 'iduser' => $this->session->userdata("id"), "nulo" => 0, 'femision' => $fecha);
                      }
                      $dtotal = $this->nota_model->montoTotal($filtros);
                      ?>
                      <td align="right" class="pr-1" <?php if ($fecha == date("Y-m-d")) {
                                                        echo 'class="table-danger"';
                                                      } ?>><?php echo $dtotal->total ?? ''; ?></td>
                    <?php } ?>
                  </tr>
                <?php endif ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>

      <?php if ($empresa->facturacion == 1): ?>
        <div class="col-12 d-none d-sm-block">
          <div class="card card-outline">
            <div class="card-header">
              <?php $anuo = date("Y");
              $mes = date("m"); ?>
              <h3 class="card-title">Comprobantes Estado <?php echo $mes . '/' . $anuo; ?></h3>
            </div>

            <div class="card-body p-0">
              <table class="table table-hover table-striped table-bordered table-sm">
                <thead>
                  <tr>
                    <th>Comprobantes</th>
                    <?php foreach ($estados as $estado): ?>
                      <th><?php echo $estado->descripcion; ?></th>
                    <?php endforeach ?>
                    <th>Total</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Facturas</td>
                    <?php $tfactura = 0; ?>
                    <?php foreach ($estados as $estado): ?>
                      <?php $contadorf = $this->venta_model->contador(array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => $estado->id, 'tcomprobante' => '01')); ?>
                      <td><?php echo $contadorf; ?></td>
                      <?php $tfactura += $contadorf; ?>
                    <?php endforeach ?>
                    <td><?php echo $tfactura; ?></td>
                  </tr>
                  <tr>
                    <td>Boletas</td>
                    <?php $tboleta = 0; ?>
                    <?php foreach ($estados as $estado): ?>
                      <?php $contadorb = $this->venta_model->contador(array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => $estado->id, 'tcomprobante' => '03')); ?>
                      <td><?php echo $contadorb; ?></td>
                      <?php $tboleta += $contadorb; ?>
                    <?php endforeach ?>
                    <td><?php echo $tboleta; ?></td>
                  </tr>
                  <tr>
                    <td>Notas Credito</td>
                    <?php $tcredito = 0; ?>
                    <?php foreach ($estados as $estado): ?>
                      <?php $contadorn = $this->nota_model->contador(array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => $estado->id, 'tcomprobante' => '07')); ?>
                      <td><?php echo $contadorn; ?></td>
                      <?php $tcredito += $contadorn; ?>
                    <?php endforeach ?>
                    <td><?php echo $tcredito; ?></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>

        <div class="col-12 d-none d-sm-block">
          <div class="card card-outline">
            <div class="card-header py-2">
              <h3 class="card-title">Consultas Facturacion</h3>
            </div>
            <div class="card-body p-0">
              <table class="table table-hover table-striped table-bordered table-sm">
                <thead>
                  <tr>
                    <th>Meses</th>
                    <?php for ($i = 0; $i < 12; $i++) { ?>
                      <?php
                      $mes = date("m") - $i;
                      $anuo = date("Y");
                      if ($mes < 1) {
                        $mes = $mes + 12;
                        $anuo -= 1;
                      }
                      ?>
                      <th><?php echo zerofill($mes, 2) . '/' . $anuo; ?></th>
                    <?php } ?>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td><strong>Comprobantes emitidos</strong></td>
                    <?php for ($i = 0; $i < 12; $i++) { ?>
                      <?php
                      $mes = date("m") - $i;
                      $anuo = date("Y");
                      if ($mes < 1) {
                        $mes = $mes + 12;
                        $anuo -= 1;
                      }

                      $filtros = array('year(femision)' => $anuo, 'month(femision)' => $mes);
                      $contadorv = $this->venta_model->contador($filtros);
                      $contadorn = $this->nota_model->contador($filtros);
                      $emitidos = $contadorv + $contadorn;
                      ?>
                      <td align="center"><?php echo $emitidos; ?></td>
                    <?php } ?>
                  </tr>
                  <tr>
                    <td><strong>Comprobantes no enviados</strong></td>
                    <?php for ($i = 0; $i < 12; $i++) { ?>
                      <?php
                      $mes = date("m") - $i;
                      $anuo = date("Y");
                      if ($mes < 1) {
                        $mes = $mes + 12;
                        $anuo -= 1;
                      }

                      $filtros = array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => "01");
                      $contadorv = $this->venta_model->contador($filtros);
                      $contadorn = $this->nota_model->contador($filtros);
                      $noenviados = $contadorv + $contadorn;
                      ?>
                      <td align="center"><?php echo $noenviados; ?></td>
                    <?php } ?>
                  </tr>
                  <tr>
                    <td><strong>Resumenes no consultados</strong></td>
                    <?php for ($i = 0; $i < 12; $i++) { ?>
                      <?php
                      $mes = date("m") - $i;
                      $anuo = date("Y");
                      if ($mes < 1) {
                        $mes = $mes + 12;
                        $anuo -= 1;
                      }

                      $filtror = array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => "01");
                      $resumenes = $this->resumen_model->contador($filtror);
                      ?>
                      <td align="center"><?php echo $resumenes; ?></td>
                    <?php } ?>
                  </tr>
                  <tr>
                    <td><strong>Anulaciones no consultadas</strong></td>
                    <?php for ($i = 0; $i < 12; $i++) { ?>
                      <?php
                      $mes = date("m") - $i;
                      $anuo = date("Y");
                      if ($mes < 1) {
                        $mes = $mes + 12;
                        $anuo -= 1;
                      }

                      $filtror = array('year(femision)' => $anuo, 'month(femision)' => $mes, "tipo_estado" => "01");
                      $anulaciones = $this->anulado_model->contador($filtror);
                      ?>
                      <td align="center"><?php echo $anulaciones; ?></td>
                    <?php } ?>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      <?php endif ?>

      <!-- <audio id="miAudio" src="<?php echo base_url(); ?>public/img/inicio.mp3" muted></audio> -->
      <script>
        document.addEventListener("DOMContentLoaded", function() {
          document.getElementById('miAudio').muted = false;
          document.getElementById('miAudio').play();
        });
      </script>
    </div>
  </div>
</section>

<div class="modal fade" id="busdatos">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-1">
        <h5 class="modal-title" id="modalTitle">Datos de la Serie</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">×</span>
        </button>
      </div>
      <div class="modal-body">
        <div name="bdatos" id="bdatos">

        </div>
      </div>
    </div>
  </div>
</div>