<div class="content-header pb-1">
  <div class="container-fluid">
    <div class="row mb-0">
      <div class="col-sm-7">
        <h4 class="m-0 text-dark">Nota Venta</h4>
      </div>
      <div class="col-sm-5">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><i class="fa fa-home"></i> <b class="text-danger"><?php echo $nestablecimiento->descripcion ?></b></li>
          <li class="breadcrumb-item">Venta</li>
          <li class="breadcrumb-item active"><a href="<?php echo base_url() ?>nventa">Nota de Venta</a></li>
        </ol>
      </div>
    </div>
  </div>
</div>

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card card-outline">
          <div class="card-body p-3">
            <?php if($this->session->flashdata('mensaje')!=''){?>
              <div class="alert alert-<?php echo $this->session->flashdata('css') ?> alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo $this->session->flashdata('mensaje') ?>
              </div>
            <?php } ?>

            <?php echo form_open(null,array("class"=>"form-horizontal","name"=>"form1", "id"=>"form1", "autocomplete"=>"off", "onsubmit"=>"return envioVenta('".base_url()."nventa/guardar/".$id."');")); ?>
              <div class="row">
                <div class="col-sm-6">
                  <div class="table-responsive table-striped p-0 border border-info" style="height: 330px;">
                    <table class="table table-head-fixed text-nowrap table-sm">
                      <tbody id="grilla">
                        <?php $igravado=0; $exonerado=0; $inafecto=0; $i=1; ?>
                        <?php foreach ($detalles as $detalle): ?>
                          <?php
                            $producto=$this->producto_model->mostrar(array("p.id"=>$detalle->idproducto));
                            $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
                            $factor= $detalle->unidad=='BX' ? $producto->factor : 1 ;
                            $dscto=$detalle->dscto>0 ? $detalle->dscto : '' ;
                            if ($producto->tafectacion==30) {
                              $inafecto+=$detalle->importe;
                            } else if($producto->tafectacion==20) {
                              $exonerado+=$detalle->importe;
                            } else {
                              $igravado+=$detalle->importe;
                            }

                            $almacenc=$detalle->cantidad*$factor;
                            if ($cantidad->stock<$almacenc) {$color='text-danger';} else {$color='';}
                            $descuento=$empresa->dscto==0 ? '%' : 'S/.';
                          ?>
                          <tr>
                            <td colspan="2">
                              <input type="text" name="descripcion[]" value="<?php echo $detalle->descripcion ?>" class="campo <?php echo $color; ?>" readonly /><input type="hidden" name="idproducto[]" value="<?php echo $detalle->idproducto ?>"/><input type="hidden" name="tipo[]" value="<?php echo $producto->tipo ?>"/>
                              <div class="row">
                                <div class="col-sm-3 col-4"><input type="text" name="nlote[]" id="mlote<?php echo $i; ?>" value="" class="campo"/><input type="hidden" name="lote[]" value="<?php echo $producto->lote ?>" class="campo"/></div>
                                <div class="col-sm-1 col-4"><input type="hidden" class="factorn" name="factor[]" id="factor[]" value="<?php echo $factor; ?>"><input type="text" name="unidad[]" value="<?php echo $detalle->unidad ?>" class="campo"/><input type="hidden" name="tafectacion[]" value="<?php echo $producto->tafectacion ?>"/></div>
                                <div class="col-sm-2 col-4"><input type="hidden" name="stock[]" value="<?php echo $cantidad->stock; ?>" class="stockn"><input type="number" min="1" name="cantidad[]" value="<?php echo $detalle->cantidad ?>" class="form-control form-control-sm cantidadn" onkeypress="return event.keyCode != 13;"/><input type="hidden" class="calmacenn" id="mcantidad<?php echo $i; ?>" name="almacenc[]" value="<?php echo $almacenc; ?>"/></div>
                                <div class="col-sm-2 col-4"><input type="text" name="precio[]" value="<?php echo $detalle->precio ?>" class="campo text-right precion"/></div>
                                <div class="col-sm-2 col-4"><input type="hidden" class="dscton" name="tdscto[]" id="tdscto[]" value="<?php echo $empresa->dscto; ?>"><input type="number" name="dscto[]" value="<?php echo $dscto ?>" class="form-control form-control-sm porcentajen" step="0.01" placeholder="(<?php echo $descuento; ?>)Dscto"/></div>
                                <div class="col-sm-2 col-4"><input type="number" min="0.01" step="0.01" name="importe[]" value="<?php echo $detalle->importe ?>" class="campo text-right importen"/></div>
                              </div>
                            </td>
                            <td>
                              <a href="javascript:void(0)" class="btn btn-danger btn-sm py-0 elimina" title="Eliminar"><i class="fa fa-trash"></i></a>
                              <?php if ($producto->lote==1): ?>
                              <br><a href="javascript:void(0)" onclick="mlotes('<?php echo $detalle->idproducto ?>','<?php echo $i; ?>','<?php echo base_url(); ?>producto/busLotes');" class="btn btn-secondary btn-sm py-0 mt-2" title="Lotes"><i class="fa fa-cubes"></i></a>
                              <?php endif ?>
                            </td>
                          </tr>
                          <?php $i++; ?>
                        <?php endforeach ?>
                      </tbody>
                    </table>
                  </div>

                  <table>
                    <tr>
                      <?php $gravado=round($igravado/1.18,4); $igv=round($gravado*0.18,2); ?>
                      <td width="24%" align="right"><strong>IGV S./</strong></td>
                      <td width="23%">
                        <input name="bimponible" type="hidden" id="bimponible" value="<?php echo $gravado; ?>"/>
                        <input name="gravado" type="hidden" id="gravado" value="<?php echo $gravado; ?>"/>
                        <input name="inafecto" type="hidden" id="inafecto" value="<?php echo $inafecto; ?>"/>
                        <input name="exonerado" type="hidden" id="exonerado" value="<?php echo $exonerado; ?>"/>
                        <h4><input name="igv" type="text" id="igv" class="campo text-right" value="<?php echo formatoMonto($igv); ?>"/></h4>
                      </td>
                      <td width="24%" align="right"><strong>TOTAL S./</strong></td>
                      <td width="29%">
                        <h4><input name="totalg" type="text" id="totalg" class="campo text-right" value="<?php echo formatoMonto($gravado+$inafecto+$exonerado+$igv); ?>"/></h4>
                      </td>
                    </tr>
                  </table>
                </div>

                <div class="col-sm-6">
                  <div class="row mb-2">
                    <div class="col-sm-2 col-6">
                      <b>Dscto : (<?php echo $empresa->dscto==0 ? '%' : 'S/.'; ?>)</b>
                    </div>

                    <div class="col-sm-3 col-6">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-barcode"></i></span>
                        </div>
                        <input id="codbarra" type="text" class="form-control form-control-sm" placeholder="Precio Unidad" aria-label="Codigo Barra" aria-describedby="basic-addon1" onfocus="limpiarBuscadorv('<?php echo base_url(); ?>producto/busProductos')" onkeydown="productoBarrav(event,'<?php echo base_url(); ?>producto/busCodigobarra',this.value);">
                      </div>
                    </div>

                    <div class="col-sm-7">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-search" aria-hidden="true"></i></span>
                        </div>
                        <input name="bproducto" type="text" id="bproducto" class="form-control form-control-sm" value="" placeholder="Buscar Producto" onkeyup="productoNombrev('<?php echo base_url(); ?>producto/busProductos',this.value)" autofocus>
                        <div class="input-group-append">
                          <button type="button" class="btn bg-info btn-sm" onclick="mostrarModal('<?php echo base_url(); ?>venta/productoi','bdatos','Datos del Producto')" title="Producto Nuevo" data-toggle="tooltip" data-placement="bottom"><i class="fas fa-plus"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="table-responsive border border-dark" style="height: 340px; font-size: .79rem">
                    <table class="table table-striped table-hover table-sm">
                      <thead class="thead-dark">
                        <tr>
                          <th class="priority" width="6%"></th>
                          <th width="43%">PRODUCTO</th>
                          <th class="priority" width="7%">FACTOR</th>
                          <th class="priority" width="7%">BONIF</th>
                          <th width="7%">STOCK</th>
                          <th width="10%">P. UNID</th>
                          <th width="10%">P. BLIS</th>
                          <th width="10%">P. CAJA</th>
                        </tr>
                      </thead>
                      <tbody id="grproducto">
                        <?php foreach ($productos as $producto): ?>
                          <?php
                          $nproducto=$producto->descripcion;
                          if ($producto->nlaboratorio!='') {$nproducto.=' ['.$producto->nlaboratorio.']';}
                          $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
                          $pventa=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
                          $pblister=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
                          $venta=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;

                          $bonificados=$this->bonificado_model->mostrar(array("anuo"=>date("Y"),"mes"=>date("n"),"idproducto"=>$producto->id));
                          if ($cantidad->stock<1 && $producto->tipo=='B'){
                            $color='#dc3545';
                          }else{
                            if ($bonificados!=NULL) {$color='#00c800';} else {$color='#000000';}
                          }

                          if ($producto->vsujeta==1) {$tcolor='table-success';} else {$tcolor='';}
                          ?>
                          <tr style="color: <?php echo $color; ?>;" class="<?php echo $tcolor; ?>">
                            <td class="priority"><?php echo $producto->puntos==1 ? 'PUN': ''; ?></td>
                            <td><a href="javascript:void(0)" onclick="msimilares('<?php echo base_url(); ?>producto/busPrincipio','<?php echo $producto->id; ?>')"><?php echo $nproducto; ?></a></td>
                            <td class="priority"><b><?php echo $producto->factor; ?></b></td>
                            <td class="priority" align="right"><?php echo $bonificados->monto??''; ?></td>
                            <?php if ($producto->lote==1 && $cantidad->stock>0): ?>
                            <td><a href="javascript:void(0)" onclick="mvental('<?php echo $producto->id; ?>',`<?php echo $nproducto; ?>`,'<?php echo $venta; ?>','<?php echo $producto->factor; ?>','<?php echo $pventa; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo base_url(); ?>producto/busLotes')" class="badge badge-dark" style="font-size: 100%;" title="Seleccionar Lotes"><?php echo $cantidad->stock>99 ? '+99': $cantidad->stock; ?></a></td>
                            <?php else: ?>
                            <td><?php echo $cantidad->stock>99 ? '+99': $cantidad->stock; ?></td>
                            <?php endif ?>
                            <?php if ($cantidad->stock>0 || $producto->tipo=='S'): ?>
                              <td align="right"><a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto; ?>`,'<?php echo 'NIU'; ?>','<?php echo 1; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pventa; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-info btn-sm py-0" title="Click para seleccionar"><?php echo $pventa; ?></a></td>
                              <td align="right">
                                <?php if ($producto->factorb>1 && $pblister>0 && intval($cantidad->stock)>=$producto->factorb): ?>
                                <a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto.' BLISTER X '.$producto->factorb; ?>`,'<?php echo 'BL'; ?>','<?php echo $producto->factorb; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pblister; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-primary btn-sm py-0" title="Click para seleccionar"><?php echo $pblister; ?></a>
                                <?php endif ?>
                              </td>
                              <td align="right">
                                <?php if ($producto->factor>1 && $venta>0 && intval($cantidad->stock)>=$producto->factor): ?>
                                <a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto.' CJ X '.$producto->factor; ?>`,'<?php echo 'BX'; ?>','<?php echo $producto->factor; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $venta; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-success btn-sm py-0" title="Click para seleccionar"><?php echo $venta; ?></a>
                                <?php endif ?>
                              </td>
                            <?php else: ?>
                              <td align="right"><?php echo $pventa; ?></td>
                              <td align="right">
                                <?php if ($producto->factorb>1 && $pblister>0): ?>
                                <?php echo $pblister; ?>
                                <?php endif ?>
                              </td>
                              <td align="right">
                                <?php if ($producto->factor>1 && $venta>0): ?>
                                <?php echo $venta; ?>
                                <?php endif ?>
                              </td>
                            <?php endif ?>
                          </tr>
                        <?php endforeach ?>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group row mb-2 mt-3">
                    <label for="serie" class="col-sm-2 col-6 control-label">Serie*</label>
                    <div class="col-sm-3 col-6" >
                       <input name="serie" type="text" id="serie" value="<?php echo $nserie->serie ?>" class="form-control form-control-sm" readonly required/>
                    </div>

                    <div class="col-sm-3 col-6">
                      <input name="efectivo" type="text" id="efectivo" class="form-control form-control-sm" value="" onkeyup="diferencia('efectivo','totalg','vuelto')" placeholder="Monto en Efectivo">
                    </div>

                    <div class="col-sm-3 col-6">
                      <!-- <label for="vuelto" class="control-label mb-0">Vuelto</label> -->
                      <input name="vuelto" type="text" id="vuelto" class="form-control form-control-sm" value="" placeholder="Vuelto" readonly>
                    </div>
                  </div>

                  <div class="form-group row mb-2">
                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" name="pcredito" type="checkbox" id="pcredito" value="1" onchange="pagoCredito(this);">
                          Pago Credito
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" name="dizipay" type="checkbox" id="dizipay" value="1" onchange="pagoIzipay(this);">
                          Izipay
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="formato" name="formato" value="1">
                          Formato A4
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="impresion" name="impresion" value="1">
                          Impresion Lote
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="canjear" name="canjear" value="1" onchange="mostrarDescuento(this)">
                          Canjear Vale
                        </label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-sm-6">
                  <fieldset class="border border-info mb-2 px-2 mt-3">
                    <legend class="h6 pl-1 mb-1">Cliente</legend>
                    <div class="form-group row mb-1">
                      <div class="col-sm-9 col-9">
                        <input name="idcliente" id="idcliente" type="hidden" value="<?php echo $cotizacion->idcliente ?>"/>
                        <input name="tdocumento" id="tdocumento" type="hidden" value="<?php echo $ncliente->tdocumento ?>"/>
                        <input name="cliente" type="text" id="cliente" class="form-control form-control-sm" value="<?php echo $cotizacion->cliente ?>" readonly>
                      </div>

                      <div class="col-sm-3 col-3">
                        <label class="col-form-label" id="puntaje">Puntos Acumulados : 0</label>
                      </div>
                    </div>
                  </fieldset>

                  <div id="cvale" style="display: none;">
                    <div class="form-group row mb-2">
                      <div class="col-sm-7">
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" id="nvale" name="nvale" value="" autocomplete="off" onkeypress="return event.keyCode != 13;" placeholder="Codigo del vale">
                          <div class="input-group-append">
                            <button class="btn btn-warning btn-sm" type="button" onclick="validarVale('<?php echo base_url(); ?>cliente/busVale')"><i class="fa fa-search" aria-hidden="true"></i> Validar</button>

                            <button class="btn btn-danger btn-sm" type="button" onclick="limpiarVale('nvale')"><i class="fa fa-ban" aria-hidden="true"></i> Limpiar</button>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-5">
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <span class="input-group-text text-sm py-0"><strong>DESCUENTO S./</strong></span>
                          </div>
                          <input name="mdsctog" type="text" id="mdsctog" class="form-control form-control-sm" value="" readonly/>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div id="cizipay" style="display: none;">
                    <div class="form-group row mb-2">
                      <label for="pizipay" class="col-sm-2 control-label">Izipay</label>
                      <div class="col-sm-3">
                        <div class="input-group">
                          <input name="pizipay" type="text" id="pizipay" class="form-control form-control-sm" value="" onkeyup="porcentajes('totalg','pizipay','mizipay');suma('totalg','mizipay','pagar');" />
                          <div class="input-group-append">
                            <span class="input-group-text py-0 text-sm">%</span>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-3">
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <span class="input-group-text py-0 text-sm">S/.</span>
                          </div>
                          <input name="mizipay" type="text" id="mizipay" class="form-control form-control-sm" value=""  onkeyup="suma('totalg','mizipay','pagar');"/>
                        </div>
                      </div>

                      <label for="pagar" class="col-sm-1 control-label">Pagar</label>
                      <div class="col-sm-3">
                        <input name="pagar" type="text" id="pagar" class="form-control form-control-sm text-right" value=""/>
                      </div>
                    </div>
                  </div>

                  <div id="contado" style="display: block;">
                    <div class="form-group row mb-2">
                      <label for="mpago" class="col-sm-2 col-6 col-form-label">Medio Pago*</label>
                      <div class="col-sm-3 col-6">
                        <select name="mpago[]" id="mpago[]" class="form-control form-control-sm">
                          <?php foreach ($mpagos as $mpago): ?>
                            <option value="<?php echo $mpago->id ?>"><?php echo $mpago->descripcion ?></option>
                          <?php endforeach ?>
                        </select>
                      </div>

                      <label for="monto" class="col-sm-2 col-6 col-form-label">Monto</label>
                      <div class="col-sm-2 col-4">
                        <input name="monto[]" type="text" id="monto[]" class="form-control form-control-sm" value="<?php echo $cotizacion->total; ?>" readonly/>
                      </div>
                      <div class="col-sm-1 col-2">
                        <button type="button" class="btn btn-info btn-sm" onclick="apppagos('<?php echo base_url(); ?>nventa/metodos');"><i class="fa fa-plus"></i></button>
                      </div>
                    </div>
                  </div>

                  <div id="credito" style="display: none;">
                    <div class="form-group row mb-2">
                      <div class="col-sm-4">
                        <label class="control-label">F. Vencimiento*</label>
                        <input name="fvencimiento" type="date" id="fvencimiento" class="form-control form-control-sm" value=""/>
                      </div>

                      <div class="col-sm-4">
                        <label class="control-label">Periodo*</label>
                        <select name="pcuota" id="pcuota" class="form-control form-control-sm">
                          <option value="">::Seleccione</option>
                          <option value="Semanal">Semanal</option>
                          <option value="Quincenal">Quincenal</option>
                          <option value="Mensual">Mensual</option>
                        </select>
                      </div>

                      <div class="col-sm-2">
                        <label class="control-label">Cuotas*</label>
                        <input name="cuotas" type="text" id="cuotas" class="form-control form-control-sm" value="" onkeyup="divisores('totalg','cuotas','mcuota')"/>
                      </div>

                      <div class="col-sm-2">
                        <label class="control-label">A pagar*</label>
                        <input name="mcuota" type="text" id="mcuota" class="form-control form-control-sm" value=""/>
                      </div>
                    </div>
                  </div>

                  <div class="col-sm-12 text-center">
                    <input type="submit" class="btn btn-primary btn-sm" id="btsubmit" value="GUARDAR"/>
                  </div>
                </div>
              </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="buslotes">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h5 class="modal-title">Detalle de Lotes</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <table class="table table-striped table-sm">
          <thead>
            <tr>
              <th>Codigo</th>
              <th>Cantidad</th>
              <th>Fecha vencimiento</th>
            </tr>
          </thead>
          <tbody id="tblote">
          </tbody>
        </table>

        <input type="hidden" name="lentregar" id="lentregar" value="0">
        <input type="hidden" name="rlote" id="rlote" value="">
        <input type="hidden" name="orden" id="orden" value="">

        <div class="form-group row mb-0">
          <div class="col-sm-12 text-right">
            <button type="button" class="btn btn-primary btn-sm ml-4" onclick="applotes();">AGREGAR</button>
            <button type="button" class="btn btn-outline-danger btn-sm" class="close" data-dismiss="modal" aria-label="Close">CERRAR</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
