<?php
$pdf = new Mytcpdf(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetTitle('Consulta de Caja');
$pdf->SetMargins(8,13,8);

$pdf->SetAutoPageBreak(true,9.5);
$pdf->SetAuthor('SisPharma');

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->AddPage();

// contenido
$pdf->SetFont('helvetica', 'B',12);
if ($this->session->userdata("tipo")=='admin') {
    if ($this->input->post('cusuario',true)=='') {
        $nusuario='Todos';
    } else {
        $usuarios=$this->usuario_model->mostrar($this->input->post('cusuario',true));
        $nusuario=$usuarios->nombres;
    }
} else {
    $usuarios=$this->usuario_model->mostrar($this->session->userdata("id"));
    $nusuario=$usuarios->nombres;
}
$tblc = '<table cellspacing="0" cellpadding="0" border="0">
    <tr>
        <td width="15%" align="center" height="48px"><img src="'.$empresa->logo.'" border="0" height="44px"/></td>
        <td width="70%" align="center" height="48px"><br> VENTA SEGUN MEDIO PAGO DEL '.FormatoFecha($this->input->post('cinicio',true)).' AL '.FormatoFecha($this->input->post('cfin',true)).'<br>'.$nusuario.'</td>
        <td width="15%" align="center" height="48px"><b style="font-size: 0.7 em;">'.$nestablecimiento->descripcion.'</b></td>
    </tr>
</table>';
$pdf->writeHTML($tblc, false, false, false, false, '');
$pdf->Ln(2);

$pdf->SetFont('helvetica','',9);
$tblf = '<table cellspacing="0" cellpadding="2" border="1">
    <tr>
      <th><strong>Modalidad</strong></th>
      <th><strong>CPE</strong></th>
      <th><strong>Nota Venta</strong></th>
      <th><strong>Total</strong></th>
    </tr>';
    $tcomprobantes=0; $tnventas=0; $tmedios=0;
    foreach ($mpagos as $mpago) {
        if ($this->session->userdata("tipo")=='admin') {
            if ($this->input->post('cusuario',true)=='') {
            $filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),"nulo"=>0,"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true),"idtpago"=>$mpago->id);
            } else {
            $filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->input->post('cusuario',true),"nulo"=>0,"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true),"idtpago"=>$mpago->id);
            }
        } else {
            $filtros=array("idestablecimiento"=>$this->session->userdata("predeterminado"),'iduser'=>$this->session->userdata("id"),"nulo"=>0,"femision>="=>$this->input->post('cinicio',true),"femision<="=>$this->input->post('cfin',true),"idtpago"=>$mpago->id);
        }

        //cobros comprobante
        $mcobrosc=$this->cobroe_model->montoTotal($filtros);
        //pagos comprobante
        $mcobrosn=$this->cobron_model->montoTotal($filtros);
        $totalComprobante=$mcobrosc->total+$mcobrosn->total;

        //cobros
        $mcobros=$this->cobro_model->montoTotal($filtros);
        $totalNventas=$mcobros->total;

        $totalmedio=$totalComprobante+$totalNventas;
        $tcomprobantes+=$totalComprobante; $tnventas+=$totalNventas; $tmedios+=$totalmedio;
        $tblf .= '<tr>
            <td><strong>'.$mpago->descripcion.'</strong></td>
            <td align="right">'.formatoPrecio($totalComprobante).'</td>
            <td align="right">'.formatoPrecio($totalNventas).'</td>
            <td align="right">'.formatoPrecio($totalmedio).'</td>
        </tr>';
    }
    $tblf .= '<tr>
                <td align="right"><strong>Totales</strong></td>
                <td align="right"><strong>'.formatoPrecio($tcomprobantes).'</strong></td>
                <td align="right"><strong>'.formatoPrecio($tnventas).'</strong></td>
                <td align="right"><strong>'.formatoPrecio($tmedios).'</strong></td>
            </tr>';
$tblf .= '</table>';
$pdf->writeHTML($tblf, false, false, false, false, '');
$pdf->Ln(2);

$pdf->Output();
