<section class="content-header pb-1">
  <div class="container-fluid">
    <div class="row mb-0">
      <div class="col-sm-7 d-flex align-items-center">
        <div class="alert w-100 mb-0 py-2 d-flex align-items-center shadow-sm" role="alert" style="background: linear-gradient(90deg, #fffbe6 0%, #f7fafc 100%); border-left: 5px solid #fbc02d; color: #795548; font-size: 1.05rem;">
          <i class="fa fa-info-circle mr-3" style="color: #fbc02d; font-size: 1.6rem;"></i>
          <span>
        <strong>Atención:</strong> Ventas mayores a <b>S/ 700</b> requieren <b>DNI</b> del cliente.
          </span>
        </div>
      </div>
      <div class="col-sm-5 d-flex justify-content-end align-items-center">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb bg-white mb-0 py-2 px-3 shadow-sm rounded">
        <li class="breadcrumb-item d-flex align-items-center">
          <i class="fa fa-home mr-1 text-primary"></i>
          <span class="font-weight-bold text-primary"><?php echo $nestablecimiento->descripcion ?></span>
        </li>
        <li class="breadcrumb-item">Venta</li>
        <li class="breadcrumb-item active" aria-current="page">
          <a href="<?php echo base_url() ?>venta" class="text-info font-weight-bold">Comprobante</a>
        </li>
          </ol>
        </nav>
      </div>
    </div>
  </div>
</section>

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card card-outline">
          <div class="card-body p-2">
            <?php if($this->session->flashdata('mensaje')!=''){ ?>
              <div class="alert alert-<?php echo $this->session->flashdata('css') ?> alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo $this->session->flashdata('mensaje') ?>
              </div>
            <?php } ?>

            <?php echo form_open(null,array("class"=>"form-horizontal","name"=>"form1", "id"=>"form1", "autocomplete"=>"off", "onsubmit"=>"return envioVenta('".base_url()."venta/guardar');")); ?>
              <div class="row">
                <div class="col-sm-6">
                  <div class="row mb-2">
                    <div class="col-sm-2 col-6">
                      <b>DSCTO <?php echo $empresa->dscto==0 ? '%' : 'S/.'; ?></b>
                    </div>

                    <div class="col-sm-3 col-6">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-barcode"></i></span>
                        </div>
                        <input id="codbarra" type="text" class="form-control form-control-sm" placeholder="Código del producto" aria-label="Codigo Barra" aria-describedby="basic-addon1" onfocus="limpiarBuscadorv('<?php echo base_url(); ?>producto/busProductos')" onkeydown="productoBarrav(event,'<?php echo base_url(); ?>producto/busCodigobarra',this.value);">
                      </div>
                    </div>

                    <div class="col-sm-7">
                      <div class="input-group">
                        <div class="input-group-prepend">
                          <span class="input-group-text" id="basic-addon1"><i class="fa fa-search" aria-hidden="true"></i></span>
                        </div>
                        <input name="bproducto" type="text" id="bproducto" class="form-control form-control-sm" value="" placeholder="Buscar Producto" onkeyup="productoNombrev('<?php echo base_url(); ?>producto/busProductos',this.value)" autofocus>
                        <div class="input-group-append">
                          <button type="button" class="btn bg-info btn-sm" onclick="mostrarModal('<?php echo base_url(); ?>nventa/productoi','bdatos','Datos del Producto')" title="Producto Nuevo" data-toggle="tooltip" data-placement="bottom"><i class="fas fa-plus"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="table-responsive border border-dark" style="height: 340px; font-size: .79rem">
                    <table class="table table-striped table-hover table-sm">
                      <thead class="thead-dark">
                        <tr>
                          <th class="priority" width="6%"></th>
                          <th width="45%">PRODUCTO</th>
                          <th class="priority" width="6%">FACT</th>
                          <th class="priority" width="6%">BONIF</th>
                          <th width="7%">CAN</th>
                          <th width="10%">P. UNID</th>
                          <th width="10%">P. BLIS</th>
                          <th width="10%">P. CAJA</th>
                        </tr>
                      </thead>
                      <tbody id="grproducto">
                        <?php foreach ($productos as $producto): ?>
                          <?php
                          $nproducto=$producto->descripcion;
                          if ($producto->nlaboratorio!='') {$nproducto.=' ['.$producto->nlaboratorio.']';}
                          $cantidad=$this->inventario_model->mostrar($this->session->userdata("predeterminado"),$producto->id);
                          $pventa=$empresa->pestablecimiento==1 ? $cantidad->pventa: $producto->pventa;
                          $pblister=$empresa->pestablecimiento==1 ? $cantidad->pblister: $producto->pblister;
                          $venta=$empresa->pestablecimiento==1 ? $cantidad->venta: $producto->venta;

                          $bonificados=$this->bonificado_model->mostrar(array("anuo"=>date("Y"),"mes"=>date("n"),"idproducto"=>$producto->id));
                          if ($cantidad->stock<1 && $producto->tipo=='B'){
                            $color='#dc3545';
                          }else{
                            if ($bonificados!=NULL) {$color='#00c800';} else {$color='#000000';}
                          }

                          if ($producto->vsujeta==1) {$tcolor='table-success';} else {$tcolor='';}
                          ?>
                          <tr style="color: <?php echo $color; ?>;" class="<?php echo $tcolor; ?>">
                            <td class="priority"><?php echo $producto->puntos==1 ? 'PUN': ''; ?></td>
                            <td><a href="javascript:void(0)" onclick="msimilares('<?php echo base_url(); ?>producto/busPrincipio','<?php echo $producto->id; ?>')"><?php echo $nproducto; ?></a></td>
                            <td class="priority"><b><?php echo $producto->factor; ?></b></td>
                            <td class="priority" align="right"><?php echo $bonificados->monto??''; ?></td>
                            <?php if ($producto->lote==1 && $cantidad->stock>0): ?>
                            <td><a href="javascript:void(0)" onclick="mvental('<?php echo $producto->id; ?>',`<?php echo $nproducto; ?>`,'<?php echo $venta; ?>','<?php echo $producto->factor; ?>','<?php echo $pventa; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo base_url(); ?>producto/busLotes')" class="badge badge-dark" style="font-size: 100%;" title="Seleccionar Lotes"><?php echo $cantidad->stock>99 ? '+99': $cantidad->stock; ?></a></td>
                            <?php else: ?>
                            <td><?php echo $cantidad->stock>99 ? '+99': $cantidad->stock; ?></td>
                            <?php endif ?>
                            <?php if ($cantidad->stock>0 || $producto->tipo=='S'): ?>
                              <td align="right"><a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto; ?>`,'<?php echo 'NIU'; ?>','<?php echo 1; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pventa; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-info btn-sm py-0" title="Click para seleccionar"><?php echo $pventa; ?></a></td>
                              <td align="right">
                                <?php if ($producto->factorb>1 && $pblister>0 && intval($cantidad->stock)>=$producto->factorb): ?>
                                <a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto.' BLISTER X '.$producto->factorb; ?>`,'<?php echo 'BL'; ?>','<?php echo $producto->factorb; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $pblister; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-primary btn-sm py-0" title="Click para seleccionar"><?php echo $pblister; ?></a>
                                <?php endif ?>
                              </td>
                              <td align="right">
                                <?php if ($producto->factor>1 && $venta>0 && intval($cantidad->stock)>=$producto->factor): ?>
                                <a href="javascript:void(0)" onclick="appventa('<?php echo $producto->id; ?>', `<?php echo $nproducto.' CJ X '.$producto->factor; ?>`,'<?php echo 'BX'; ?>','<?php echo $producto->factor; ?>','<?php echo $producto->tafectacion; ?>','<?php echo $venta; ?>','<?php echo $producto->lote; ?>','<?php echo $cantidad->stock; ?>','<?php echo $producto->tipo; ?>','<?php echo $empresa->dscto; ?>','<?php echo $empresa->pventa; ?>');" class="btn btn-success btn-sm py-0" title="Click para seleccionar"><?php echo $venta; ?></a>
                                <?php endif ?>
                              </td>
                            <?php else: ?>
                              <td align="right"><?php echo $pventa; ?></td>
                              <td align="right">
                                <?php if ($producto->factorb>1 && $pblister>0): ?>
                                <?php echo $pblister; ?>
                                <?php endif ?>
                              </td>
                              <td align="right">
                                <?php if ($producto->factor>1 && $venta>0): ?>
                                <?php echo $venta; ?>
                                <?php endif ?>
                              </td>
                            <?php endif ?>
                          </tr>
                        <?php endforeach ?>
                      </tbody>
                    </table>
                  </div>
                </div>

                <div class="col-sm-6">
                  <hr class="m-2" style="border-bottom: solid #6E62DF;">
                  <div class="table-responsive table-striped p-0 border border-info" style="height: 330px;">
                    <table class="table table-head-fixed text-nowrap table-sm">
                      <tbody id="grilla">
                      </tbody>
                    </table>
                  </div>

                  <table>
                    <tr>
                      <td width="24%" align="right"><b>IGV S./</b></td>
                      <td width="23%">
                        <input name="bimponible" type="hidden" id="bimponible" value=""/>
                        <input name="gravado" type="hidden" id="gravado" value=""/>
                        <input name="inafecto" type="hidden" id="inafecto" value=""/>
                        <input name="exonerado" type="hidden" id="exonerado" value=""/>
                        <h4><input name="igv" type="text" id="igv" class="campo text-right" value=""/></h4>
                      </td>
                      <td width="24%" align="right"><b>TOTAL S./</b></td>
                      <td width="29%">
                        <h4><input name="totalg" type="text" id="totalg" class="campo text-right" value=""/></h4>
                      </td>
                    </tr>
                  </table>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group row mb-2 mt-3">
                    <div class="col-sm-4 col-6">
                      <select name="comprobante" id="comprobante" class="form-control form-control-sm" onchange="tcomprobante(this.value,'<?php echo base_url(); ?>venta/busSerie')" required>
                        <?php foreach ($comprobantes as $comprobante): ?>
                          <option value="<?php echo $comprobante->id ?>"><?php echo $comprobante->descripcion ?></option>
                        <?php endforeach ?>
                      </select>
                    </div>

                    <div class="col-sm-2 col-6">
                      <input name="serie" type="text" id="serie" value="<?php echo $nserie->serie ?>" class="form-control form-control-sm" readonly required/>
                    </div>

                    <div class="col-sm-3 col-6">
                      <input name="efectivo" type="text" id="efectivo" class="form-control form-control-sm" value="" onkeyup="diferencia('efectivo','totalg','vuelto')" placeholder="Monto en Efectivo">
                    </div>

                    <div class="col-sm-3 col-6">
                      <!-- <label for="vuelto" class="control-label mb-0">Vuelto</label> -->
                      <input name="vuelto" type="text" id="vuelto" class="form-control form-control-sm" value="" placeholder="Vuelto" readonly>
                    </div>
                  </div>

                  <div class="form-group row mb-2">
                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" name="pcredito" type="checkbox" id="pcredito" value="1" onchange="pagoCredito(this);">
                          Pago Credito
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input class="form-check-input" name="dizipay" type="checkbox" id="dizipay" value="1" onchange="pagoIzipay(this);">
                          Izipay
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="formato" name="formato" value="1">
                          Formato A4
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="impresion" name="impresion" value="1">
                          Impresion Lote
                        </label>
                      </div>
                    </div>

                    <div class="col-sm-2 col-6">
                      <div class="form-check">
                        <label class="form-check-label">
                          <input type="checkbox" class="form-check-input" id="canjear" name="canjear" value="1" onchange="mostrarDescuento(this)">
                          Canjear Vale
                        </label>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="col-sm-6">
                  <fieldset class="border border-info mb-2 px-2 mt-3">
                    <legend class="h6 pl-1 mb-1">Cliente</legend>
                    <div class="form-group row mb-1">
                      <input name="idcliente" id="idcliente" type="hidden" value="1"/>
                      <input name="tdocumento" id="tdocumento" type="hidden" value="0"/>
                      <div class="col-sm-3 col-6">
                        <input type="text" name="dni" id="dni" class="form-control form-control-sm" value="" onkeydown="bcliente(event,'<?php echo base_url(); ?>cliente/busDocumento',this.value,'V');" onclick="this.select();" placeholder="DNI O RUC">
                      </div>

                      <div class="col-sm-6">
                        <div class="input-group">
                          <input name="cliente" type="text" id="cliente" class="form-control form-control-sm" value="CLIENTES VARIOS" aria-label="cliente" aria-describedby="basic-addon2" onkeyup="clienteNombre('<?php echo base_url(); ?>cliente/busCliente',this.value,'V')"  onclick="this.select();" placeholder="Nombre o Razon Social" required>
                          <div class="input-group-append">
                            <button type="button" class="btn btn-info btn-sm" onclick="mostrarCliente('<?php echo base_url(); ?>nventa/clientei','nuevo','Datos del Cliente')"><i class="fa fa-plus"></i></button>
                          </div>
                        </div>

                        <div id="tblcliente" style="position:absolute; z-index: 1051; width: 95%; overflow: overlay; max-height:250px; display: none;">
                          <dl class="bg-buscador" id="grcliente">
                          </dl>
                        </div>
                      </div>

                      <div class="col-sm-3">
                        <label class="col-form-label" id="puntaje">Puntos Acumulados : 0</label>
                      </div>
                    </div>
                  </fieldset>

                  <div id="cvale" style="display: none;">
                    <div class="form-group row mb-2">
                      <div class="col-sm-7">
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" id="nvale" name="nvale" value="" autocomplete="off" onkeypress="return event.keyCode != 13;" placeholder="Codigo del vale">
                          <div class="input-group-append">
                            <button class="btn btn-warning btn-sm" type="button" onclick="validarVale('<?php echo base_url(); ?>cliente/busVale')"><i class="fa fa-search" aria-hidden="true"></i> Validar</button>

                            <button class="btn btn-danger btn-sm" type="button" onclick="limpiarVale('nvale')"><i class="fa fa-ban" aria-hidden="true"></i> Limpiar</button>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-5">
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <span class="input-group-text text-sm py-0"><b>DESCUENTO S./</b></span>
                          </div>
                          <input name="mdsctog" type="text" id="mdsctog" class="form-control form-control-sm" value="" readonly/>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div id="cizipay" style="display: none;">
                    <div class="form-group row mb-2">
                      <label for="pizipay" class="col-sm-2 control-label">Izipay</label>
                      <div class="col-sm-3">
                        <div class="input-group">
                          <input name="pizipay" type="text" id="pizipay" class="form-control form-control-sm" value="" onkeyup="porcentajes('totalg','pizipay','mizipay');suma('totalg','mizipay','pagar');" />
                          <div class="input-group-append">
                            <span class="input-group-text py-0 text-sm">%</span>
                          </div>
                        </div>
                      </div>

                      <div class="col-sm-3">
                        <div class="input-group">
                          <div class="input-group-prepend">
                            <span class="input-group-text py-0 text-sm">S/.</span>
                          </div>
                          <input name="mizipay" type="text" id="mizipay" class="form-control form-control-sm" value=""  onkeyup="suma('totalg','mizipay','pagar');"/>
                        </div>
                      </div>

                      <label for="pagar" class="col-sm-1 control-label">Pagar</label>
                      <div class="col-sm-3">
                        <input name="pagar" type="text" id="pagar" class="form-control form-control-sm text-right" value=""/>
                      </div>
                    </div>
                  </div>

                  <div id="contado" style="display: block;">
                    <div class="form-group row mb-2">
                      <label for="mpago" class="col-sm-2 col-6 col-form-label">Medio Pago*</label>
                      <div class="col-sm-3 col-6">
                        <select name="mpago[]" id="mpago[]" class="form-control form-control-sm">
                          <?php foreach ($mpagos as $mpago): ?>
                            <option value="<?php echo $mpago->id ?>"><?php echo $mpago->descripcion ?></option>
                          <?php endforeach ?>
                        </select>
                      </div>

                      <label for="monto" class="col-sm-2 col-6 col-form-label">Monto</label>
                      <div class="col-sm-2 col-4">
                        <input name="monto[]" type="text" id="monto[]" class="form-control form-control-sm" value="" readonly/>
                      </div>

                      <div class="col-sm-1 col-2">
                        <button type="button" class="btn btn-info btn-sm" onclick="apppagos('<?php echo base_url(); ?>nventa/metodos');"><i class="fa fa-plus"></i></button>
                      </div>
                    </div>
                  </div>

                  <div id="credito" style="display: none;">
                    <div class="form-group row mb-2">
                      <div class="col-sm-4">
                        <label class="control-label">F. Vencimiento*</label>
                        <input name="fvencimiento" type="date" id="fvencimiento" class="form-control form-control-sm" value=""/>
                      </div>

                      <div class="col-sm-4">
                        <label class="control-label">Periodo*</label>
                        <select name="pcuota" id="pcuota" class="form-control form-control-sm">
                          <option value="">::Seleccione</option>
                          <option value="Semanal">Semanal</option>
                          <option value="Quincenal">Quincenal</option>
                          <option value="Mensual">Mensual</option>
                        </select>
                      </div>

                      <div class="col-sm-2">
                        <label class="control-label">Cuotas*</label>
                        <input name="cuotas" type="text" id="cuotas" class="form-control form-control-sm" value="" onkeyup="divisores('totalg','cuotas','mcuota')"/>
                      </div>

                      <div class="col-sm-2">
                        <label class="control-label">A pagar*</label>
                        <input name="mcuota" type="text" id="mcuota" class="form-control form-control-sm" value=""/>
                      </div>
                    </div>
                  </div>

                  <div class="col-sm-12 text-center">
                    <input type="submit" class="btn btn-primary btn-sm" id="btsubmit" value="GUARDAR"/>
                  </div>
                </div>
              </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<div class="modal fade" id="busregistro">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
    <div class="modal-header py-1">
      <h5 class="modal-title" id="registroTitle">Datos del Cliente</h5>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">×</span>
      </button>
    </div>
    <div class="modal-body">
      <div name="bregistro" id="bregistro">

      </div>
    </div>
  </div>
  </div>
</div>

<div class="modal fade" id="bussimilares">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
    <div class="modal-header bg-primary py-1">
      <h5 class="modal-title">Datos Productos</h5>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">×</span>
      </button>
    </div>
    <div class="modal-body pt-0">
      <ul class="nav nav-pills ml-auto p-2">
        <li class="nav-item"><a class="nav-link active" href="#tab_1" data-toggle="tab"><i class="fa fa-flask"></i> Principio Activo</a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_2" data-toggle="tab"><i class="fa fa-tint"></i> Accion Terapeutica</a></li>
        <li class="nav-item"><a class="nav-link" href="#tab_3" data-toggle="tab"><i class="fa fa-book"></i> Informacion Producto</a></li>
        <?php if ($canexos>1): ?>
          <li class="nav-item"><a class="nav-link" href="#tab_4" data-toggle="tab"><i class="fa fa-cubes"></i> Stock Establecimientos</a></li>
        <?php endif ?>
      </ul>
      <div class="tab-content">
        <div class="tab-pane active" id="tab_1">
          <div class="table-responsive p-0" style="height: 500px;">
            <table class="table table-head-fixed text-nowrap table-sm">
              <thead>
                <tr>
                  <th></th>
                  <th>PRODUCTO</th>
                  <th>STOCK</th>
                  <th>P. UNID</th>
                  <th>P. BLIS</th>
                  <th>P. CAJA</th>
                </tr>
              </thead>
              <tbody id="tbprincipio">

              </tbody>
            </table>
          </div>
        </div>

        <div class="tab-pane" id="tab_2">
          <div class="table-responsive p-0" style="height: 500px;">
            <table class="table table-head-fixed text-nowrap table-sm">
              <thead>
                <tr>
                  <th></th>
                  <th>PRODUCTO</th>
                  <th>STOCK</th>
                  <th>P. UNID</th>
                  <th>P. BLIS</th>
                  <th>P. CAJA</th>
                </tr>
              </thead>
              <tbody id="tbterapeutica">

              </tbody>
            </table>
          </div>
        </div>

        <div class="tab-pane" id="tab_3">
          <div id="tbinformacion" style="height: 500px;">

          </div>
        </div>

        <div class="tab-pane" id="tab_4">
          <div id="tbestablecimiento" style="height: 500px;">

          </div>
        </div>
      </div>
    </div>
  </div>
  </div>
</div>

<div class="modal fade" id="busventa">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h5 class="modal-title">Detalle de Producto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <form name="fproducto" id="fproducto" autocomplete="off">
          <div id="mensajeerror"></div>
          <input name="mcodigo" id="mcodigo" type="hidden">
          <div class="form-group row mb-2">
            <label class="col-sm-2 col-form-label">Producto</label>
            <div class="col-sm-10">
              <input name="mdescripcion" id="mdescripcion" type="text" class="form-control form-control-sm" readonly>
            </div>
          </div>

          <div class="form-group row mb-2">
            <label class="col-sm-2 col-form-label">Tipo Precio</label>
            <div class="col-sm-3">
              <select name="mmedida" id="mmedida" class="form-control form-control-sm" onchange="conversion(this.value)">
                <option value="">Seleccione</option>
              </select>
            </div>
            <input type="hidden" id="mfactor" name="mfactor" value="1">
            <input type="hidden" name="mafectacion" id="mafectacion" value="">

            <label class="col-sm-2 col-form-label">Stock Actual</label>
            <div class="col-sm-2">
              <input name="mstock" id="mstock" type="text" class="form-control form-control-sm" value="" readonly>
            </div>
          </div>

          <hr>
          <div class="form-group row mb-2">
            <label class="col-sm-2 col-form-label">Cantidad</label>
            <div class="col-sm-2">
              <input name="munidades" id="munidades" type="text" class="form-control form-control-sm" value="" onkeyup="factores('munidades','mcosto','mtotal');factores('munidades','mfactor','mcantidad');" required>
            </div>

            <label class="col-sm-2 col-form-label">Precio</label>
            <div class="col-sm-2">
              <h4><input name="mcosto" id="mcosto" type="text" class="campo text-right"value=""></h4>
            </div>

            <label class="col-sm-2 col-form-label">Total</label>
            <div class="col-sm-2">
              <h4><input name="mtotal" id="mtotal" type="text" class="campo text-right"value=""></h4>
            </div>
          </div>
          <input name="mcantidad" id="mcantidad" type="hidden" value="" class="campo">
          <input type="hidden" name="mmonto" id="mmonto" value="">

          <input type="hidden" name="mtipo" id="mtipo" value="">
          <input type="hidden" name="mdscto" id="mdscto" value="<?php echo $empresa->dscto; ?>">
          <input type="hidden" name="medicion" id="medicion" value="<?php echo $empresa->pventa; ?>">
          <input type="hidden" name="mactivar" id="mactivar" value="">
          <div id="mdetalle" class="form-group" style="display: none;">
            <h5>Lotes</h5>
            <table class="table table-striped table-sm">
              <thead>
                <tr>
                  <th>Codigo</th>
                  <th>Cantidad</th>
                  <th>Fecha vencimiento</th>
                </tr>
              </thead>
              <tbody id="tbLotes">
              </tbody>
            </table>
          </div>

          <input type="hidden" name="centregar" id="centregar" value="0">
          <input type="hidden" name="clote" id="clote" value="">
          <div class="form-group row mb-2">
            <div class="col-sm-12 text-right">
              <button type="button" class="btn btn-primary btn-sm ml-4" onclick="appvental();">AGREGAR</button>
              <button type="button" class="btn btn-outline-danger btn-sm" class="close" data-dismiss="modal" aria-label="Close" onclick="reset_vental();">CERRAR</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="busdatos">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header py-1">
        <h4 class="modal-title" id="modalTitle">Datos de la Venta</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">x</span>
        </button>
      </div>
      <div class="modal-body">
        <div name="bdatos" id="bdatos">

        </div>
      </div>
    </div>
  </div>
</div>

