/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

CREATE TABLE IF NOT EXISTS `acceso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `valor` varchar(20) DEFAULT NULL,
  `menu` varchar(20) DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  `estado` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `acceso` DISABLE KEYS */;
INSERT INTO `acceso` (`id`, `valor`, `menu`, `orden`, `estado`) VALUES
	(1, 'venta', 'Venta', 1, 0),
	(2, 'compra', 'Compra', 3, 0),
	(3, 'caja', 'Caja', 4, 0),
	(4, 'reporte', 'Reportes', 5, 0),
	(5, 'consulta', 'Consultas', 6, 0),
	(6, 'almacen', 'Almacen', 7, 0),
	(7, 'configuracion', 'Configuracion', 8, 0),
	(8, 'facturacion', 'Facturacion', 2, 1);
/*!40000 ALTER TABLE `acceso` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `acceso_niveles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `valor` varchar(20) NOT NULL,
  `submenu` varchar(30) NOT NULL,
  `idacceso` int(11) NOT NULL,
  `estado` tinyint(4) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `acceso_niveles` DISABLE KEYS */;
INSERT INTO `acceso_niveles` (`id`, `valor`, `submenu`, `idacceso`, `estado`) VALUES
	(1, 'cotizacion', 'Cotizaciones de Venta', 1, 0),
	(2, 'comprobante', 'Comprobante Electronico', 1, 1),
	(3, 'presupuesto', 'Solicitudes de Compra', 2, 0),
	(4, 'compra', 'Compra Mercaderia', 2, 0),
	(5, 'proveedor', 'Proveedores', 2, 0),
	(6, 'arqueo', 'Arqueo Caja', 3, 0),
	(7, 'mediopago', 'Medio Pago', 3, 0),
	(8, 'cobrar', 'Cuentas por Cobrar', 3, 0),
	(9, 'pagar', 'Cuentas por Pagar', 3, 0),
	(10, 'gasto', 'Gastos', 3, 0),
	(11, 'rcompra', 'Compra', 4, 0),
	(12, 'rventa', 'Venta', 4, 0),
	(13, 'rproducto', 'Producto', 4, 0),
	(14, 'vvalorizada', 'Venta Valorizada', 5, 0),
	(15, 'svalorizado', 'Stock Valorizado', 5, 0),
	(16, 'vhorario', 'Venta Horario', 5, 0),
	(17, 'movimientoa', 'Movimiento Almacen', 6, 0),
	(18, 'kardex', 'Kardex', 5, 0),
	(19, 'producto', 'Producto', 6, 0),
	(20, 'atributo', 'Atributos del Producto', 6, 0),
	(21, 'empresa', 'Empresa', 7, 0),
	(22, 'usuario', 'Usuario', 7, 0),
	(23, 'establecimiento', 'Establecimiento/Serie', 7, 0),
	(24, 'utilitario', 'Utilitarios', 7, 0),
	(25, 'ingreso', 'Ingresos', 3, 0),
	(26, 'cliente', 'Clientes', 1, 0),
	(27, 'nenviado', 'Comprobante no enviado', 8, 1),
	(28, 'rectificaciones', 'Comprobante por rectificar', 8, 1),
	(29, 'resumenes', 'Resumenes', 8, 1),
	(30, 'anulaciones', 'Anulaciones', 8, 1),
	(31, 'consistencia', 'Consistencia Documentos', 8, 1),
	(32, 'validador', 'Validador Documentos', 8, 1),
	(33, 'rregistro', 'Registros Contables', 4, 1),
	(34, 'despacho', 'Guia de Remision', 1, 1),
	(35, 'bonificacion', 'Bonificados', 6, 0),
	(36, 'bvendedor', 'Bonificaciones Vendedor', 5, 0),
	(37, 'punto', 'Puntos', 7, 0),
	(38, 'inventario', 'Ajustes Inventario', 6, 0),
	(39, 'rcaja', 'Caja', 4, 0),
	(40, 'traslado', 'Traslados Internos', 6, 0),
	(41, 'nventa', 'Nota Venta', 1, 0),
	(42, 'servicio', 'Servicios', 6, 0),
	(43, 'transporte', 'Transporte', 7, 1);
/*!40000 ALTER TABLE `acceso_niveles` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `acceso_niveles_usuario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idacceson` int(11) NOT NULL,
  `iduser` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `acceso_niveles_usuario` DISABLE KEYS */;
INSERT INTO `acceso_niveles_usuario` (`id`, `idacceson`, `iduser`) VALUES
	(1, 1, 1),
	(2, 2, 1),
	(3, 3, 1),
	(4, 4, 1),
	(5, 5, 1),
	(6, 6, 1),
	(7, 7, 1),
	(8, 8, 1),
	(9, 9, 1),
	(10, 10, 1),
	(11, 11, 1),
	(12, 12, 1),
	(13, 13, 1),
	(14, 14, 1),
	(15, 15, 1),
	(16, 16, 1),
	(17, 17, 1),
	(18, 18, 1),
	(19, 19, 1),
	(20, 20, 1),
	(21, 21, 1),
	(22, 22, 1),
	(23, 23, 1),
	(24, 24, 1),
	(25, 25, 1),
	(26, 26, 1),
	(27, 27, 1),
	(28, 28, 1),
	(29, 29, 1),
	(30, 30, 1),
	(31, 31, 1),
	(32, 32, 1),
	(33, 33, 1),
	(34, 34, 1),
	(35, 35, 1),
	(36, 36, 1),
	(37, 37, 1),
	(38, 38, 1),
	(39, 39, 1),
	(40, 40, 1),
	(41, 41, 1);
/*!40000 ALTER TABLE `acceso_niveles_usuario` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `acceso_usuario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idacceso` int(11) NOT NULL,
  `iduser` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `acceso_usuario` DISABLE KEYS */;
INSERT INTO `acceso_usuario` (`id`, `idacceso`, `iduser`) VALUES
	(1, 1, 1),
	(2, 8, 1),
	(3, 2, 1),
	(4, 3, 1),
	(5, 4, 1),
	(6, 5, 1),
	(7, 6, 1),
	(8, 7, 1);
/*!40000 ALTER TABLE `acceso_usuario` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `accion_terapeuticas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `accion_terapeuticas` DISABLE KEYS */;
INSERT INTO `accion_terapeuticas` (`id`, `descripcion`) VALUES
	(1, 'ANTIBIOTICO'),
	(2, 'ANALGESICO-ANTIINFLAMATORIO'),
	(3, 'ANTIPIRETICO-ANALGESICO'),
	(4, 'ANTIEMETICO-ANTIVERTIGINOSO'),
	(5, 'ANTIULCEROSO'),
	(6, 'ANTIALERGICOS'),
	(7, 'ANTIPURIGINOSOS'),
	(8, 'ANTIANEMICOS'),
	(9, 'ANTIACIDOS'),
	(10, 'LAXANTES'),
	(11, 'ANTICUAGULANTES'),
	(12, 'ESPASMOLITICO ANALGESICO'),
	(13, 'ANALGESICO-ANTIPIRETICO'),
	(14, 'ANTIINFLAMATORIA-ANTIFUNGICO-ANTIBACTERIANO'),
	(15, 'ANTIPIRETICO-ANTIINFLAMATORIO'),
	(16, 'ANALGESICO-ANTIINFLAMATORIO-RELAJANTE MUSCULAR'),
	(17, 'ANTIHISTAMINICO-ANALGESICO -ANTIPIRETICO'),
	(18, 'ANTIBACTERIANO-ANTIDIARREICO'),
	(19, 'ANTIDIARREICO'),
	(20, 'ANTIAGREGANTE PLAQUETARIO'),
	(21, 'ANTIINFLAMATORIO-ANTIPURIGINOSO'),
	(22, 'ANTITUSIVO'),
	(23, 'ANTITUSIGENO-EXPECTORANTE'),
	(24, 'MUCOLITICO '),
	(25, 'MUCOLITICO-BRONCODILATADOR'),
	(26, 'ANTIACIDO-ANTIFLATULENTO'),
	(27, 'ANTIBACTERIANO-EXPECTORANTE'),
	(28, 'DIGESTIVO-ANTIFLATULENTO'),
	(29, 'ANTIRREUMATICO -ANALGESICO-ANTIINFLAMATORIO'),
	(30, 'ANTIRREUMATICO'),
	(31, 'ANTIRREUMATICO-RELAJANTE MUSCULAR'),
	(32, 'MUCOLITICO-EXPECTORANTE '),
	(33, 'CORTICOIDE-ANTIINFLAMATORIO'),
	(34, 'HIPOGLUCEMIANTE'),
	(35, 'ANTIPROSTATICOS'),
	(36, 'ANTIINFLAMTORIO-ANALGESICO URINARIO'),
	(37, 'ANTIPARASITARIO-ANTIHELMINTICO'),
	(38, 'ANTIGOTOSO'),
	(39, 'HEPAPROTECTOR '),
	(40, 'MULTIVITAMINICO'),
	(41, 'MUCOLITICO-FLUIDIFICANTE'),
	(42, 'ANTIMICOTICO'),
	(43, 'EXPECTORANTE'),
	(44, 'ANTIBACTERIANO'),
	(45, 'ANALGESICO-ANTIINFLAMATORIO-ANTIPIRETICO'),
	(46, 'TRICOMONICIDA-ANTIFUNGICO-ANESTESICO'),
	(47, 'ANTIFLATULENTO'),
	(48, 'ANTIBACTERIANO-ANALGESICO DE LAS VIAS URINARIAS'),
	(49, 'ANTIPROSTATICO'),
	(50, 'HIPERTIROYDISMO'),
	(51, 'ANTIPARASITARIO'),
	(52, 'SUPLEMENTO VITAMINICO'),
	(53, 'SUPLEMENTO DIETETICO'),
	(54, 'ANTITUSIVO-EXPECTORANTE-ANTIHISTAMINICO'),
	(55, 'REGENERADOR DE LA PIEL'),
	(56, 'ANTIHEMORROIDAL'),
	(57, 'ANTIVIRAL '),
	(58, 'ANTIINFLAMATORIO -ANTITROMBOTICO PERCUTANEO'),
	(59, 'DESCONGESTIONANTE NASAL '),
	(60, 'ANTIBACTERIANO -ANASTESICO BUCAL'),
	(61, 'ESPASMOLITICO -ANALGESICO'),
	(62, 'ANTIINFLAMATORIO -ANALGESICO/BOCA Y GARGANTA'),
	(63, 'ANTIHIPERLIPIDEMICO'),
	(64, 'DESINFECTANTE -ANTISEPTICO'),
	(65, 'ANALGESICO +ANTIREUMATICO'),
	(66, 'ANTIPIRETICO -ANTIHISTAMINICO -ANALGESICO-ANTITUSIVO '),
	(67, 'ANTIPIRETICO -EXPECTORANTE -ANTIHISTAMINICO'),
	(68, 'ANTIDIABETICO'),
	(69, 'BRONCODILATADOR '),
	(70, 'ANTIPERTENSIVO'),
	(71, 'MATERIAL MEDICO'),
	(72, 'PRODUCTO SANITARIO'),
	(73, 'VASOPROTECTOR'),
	(74, 'ANTHIPERTENCIVO'),
	(75, 'ANTIEPILEPTICO'),
	(76, 'ANTIHISTAMINICO'),
	(77, 'EXTREÑIMIENTO '),
	(78, 'ANALGESICO DE LAS VIAS URINARIAS'),
	(79, 'ANTIMIGRAÑOSO'),
	(80, 'MAL DE ALTURA '),
	(81, 'ANALGESICO -ANTIACIDO '),
	(82, 'ANTICONCEPTIVO OVULOS'),
	(83, 'ACIDEZ +INDIGESTION + MALESTAR ESTOMACAL'),
	(84, 'ANALGESICO ANTIINFLAMATORIO +MULTIVITAMINICO '),
	(85, 'ANTIINFLAMATORIO MIORRELAJANTE '),
	(86, 'ANTIPIRETICO +ANTIHISTAMINICO'),
	(87, 'ANTICONCEPTIVO INYECTABLE'),
	(88, 'INDUCTOR DEL SUEÑO'),
	(89, 'EXPECTORANTE +ANTITUSIVO'),
	(90, 'CREMA ADHESIVA PARA PROTESIS DENTALE'),
	(91, 'TOALLA HIGIENICA '),
	(92, 'ANTICONCEPTIVO'),
	(93, 'ENJUAJE BUCAL '),
	(94, 'PASTA DENTAL'),
	(95, 'ANTIBACTERIANO /ANTIINFLAMATORIO OFTALMICO'),
	(96, ' AMPOLLA DISOLVENTE '),
	(97, 'ANTIBACTERIANO -ANALGESICO -ANTIINFLAMATORIO -ANASTESICO- OTICA '),
	(98, 'LAGRIMAS ARTIFICIALES'),
	(99, 'REFRESCANTE OCULAR '),
	(100, 'LUBRICANTE OCULAR '),
	(101, 'ANTIBACTERIANO OFTALMICO'),
	(102, 'DIFUCION ERECTIL '),
	(103, 'ANTICONCEPTIVO DE EMERGENCIA '),
	(104, 'ANTIMICOTICO-ANTIPURIGINOSO'),
	(105, 'ANTIMICOTICO /ANTIBACTERIANO'),
	(106, 'REHIDRATANTE '),
	(107, 'PAÑITOS DE LIMPIEZA'),
	(108, 'MASCARILLA'),
	(109, 'DOLORES MUSCULARES'),
	(110, 'GEL PARA EL CABELLO '),
	(111, 'NITAZOXANIDA 100\'MG /5ML'),
	(112, 'DIURETICO');
/*!40000 ALTER TABLE `accion_terapeuticas` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `anulados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `fdocumento` date DEFAULT NULL,
  `identificador` char(20) DEFAULT NULL,
  `ticket` char(20) DEFAULT NULL,
  `filename` varchar(50) DEFAULT NULL,
  `has_xml` tinyint(1) DEFAULT 0,
  `has_cdr` tinyint(1) DEFAULT 0,
  `tipo_soap` char(2) DEFAULT NULL,
  `tipo_estado` char(2) DEFAULT NULL,
  `respuesta_sunat` text DEFAULT NULL,
  `validado` tinyint(1) DEFAULT 0,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `anulados` DISABLE KEYS */;
/*!40000 ALTER TABLE `anulados` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `anulados_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idanulado` int(11) DEFAULT NULL,
  `idventa` int(11) DEFAULT NULL,
  `idnota` int(11) DEFAULT NULL,
  `motivo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `anulados_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `anulados_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `arqueos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `finicial` datetime DEFAULT NULL,
  `ffinal` datetime DEFAULT NULL,
  `minicial` decimal(10,2) DEFAULT NULL,
  `mfinal` decimal(10,2) DEFAULT NULL,
  `ventas` decimal(10,2) DEFAULT NULL,
  `compras` decimal(10,2) DEFAULT NULL,
  `ingresos` decimal(10,2) DEFAULT NULL,
  `gastos` decimal(10,2) DEFAULT NULL,
  `estado` int(1) DEFAULT 1,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `arqueos` DISABLE KEYS */;
/*!40000 ALTER TABLE `arqueos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `arqueos_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idarqueo` int(11) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `arqueos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `arqueos_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `bonificados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iduser` int(11) DEFAULT NULL,
  `anuo` char(5) DEFAULT NULL,
  `mes` char(2) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `monto` decimal(10,2) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `bonificados` DISABLE KEYS */;
/*!40000 ALTER TABLE `bonificados` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `categorias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `categorias` DISABLE KEYS */;
INSERT INTO `categorias` (`id`, `descripcion`) VALUES
	(1, 'TRACTO ALIMENTARIO Y METABOLISMO'),
	(2, 'SANGRE Y ÓRGANOS HEMATOPOYÉTICOS'),
	(3, 'SISTEMA CARDIOVASCULAR'),
	(4, 'DERMATOLÓGICOS'),
	(5, 'SISTEMA GENITOURINARIO Y HORMONAS SEXUALES'),
	(6, 'PREPARADOS HORMONALES SISTEMICOS, EXCLUYENDO HORMONAS SEXUALES E INSULINAS'),
	(7, 'ANTIINFECCIOSOS PARA USO SISTEMICO'),
	(8, 'ANTINEOPLÁSICOS E INMUNOMODULADORES'),
	(9, 'SISTEMA MUSCULOESQUELETICO'),
	(10, 'SISTEMA NERVIOSO'),
	(11, 'ANTIPARASITARIOS, INSECTICIDAS Y REPELENTES'),
	(12, 'SISTEMA RESPIRATORIO'),
	(13, 'ÓRGANOS DE LOS SENTIDOS'),
	(14, 'VARIOS FARMACIA'),
	(15, 'COSMETICOS'),
	(16, 'ALIMENTOS Y DIETETICOS'),
	(17, 'ARTICULOS BAZAR'),
	(18, 'PERFUMERIA'),
	(19, 'SERVICIOS');
/*!40000 ALTER TABLE `categorias` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tdocumento` char(3) DEFAULT NULL,
  `nombres` varchar(200) DEFAULT NULL,
  `documento` varchar(15) DEFAULT NULL,
  `idpais` char(2) DEFAULT 'PE',
  `iddepartamento` char(2) DEFAULT NULL,
  `idprovincia` char(4) DEFAULT NULL,
  `iddistrito` char(6) DEFAULT NULL,
  `direccion` varchar(100) DEFAULT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `clientes` DISABLE KEYS */;
INSERT INTO `clientes` (`id`, `tdocumento`, `nombres`, `documento`, `idpais`, `iddepartamento`, `idprovincia`, `iddistrito`, `direccion`, `telefono`, `email`, `fregistro`) VALUES
	(1, '0', 'CLIENTES VARIOS', '00000000', 'PE', '04', '0401', '040101', '-', '-', '-', '2020-10-01 07:35:38');
/*!40000 ALTER TABLE `clientes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `clientes_puntos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idcliente` int(11) DEFAULT NULL,
  `idventa` int(11) DEFAULT NULL,
  `idnventa` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `inicial` int(11) DEFAULT NULL,
  `cantidad` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `clientes_puntos` DISABLE KEYS */;
/*!40000 ALTER TABLE `clientes_puntos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `cobros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `nulo` tinyint(1) DEFAULT 0,
  `idnventa` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `cobros` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobros` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `cobros_cpe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `nulo` tinyint(1) DEFAULT 0,
  `idventa` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `cobros_cpe` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobros_cpe` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `cobros_nota` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `nulo` tinyint(1) DEFAULT 0,
  `idnota` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `cobros_nota` DISABLE KEYS */;
/*!40000 ALTER TABLE `cobros_nota` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `compras` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `comprobante` varchar(5) DEFAULT NULL,
  `serie` char(5) DEFAULT NULL,
  `numero` int(8) DEFAULT NULL,
  `idproveedor` int(11) DEFAULT NULL,
  `proveedor` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `dadicional` text DEFAULT NULL,
  `porcentaje` double DEFAULT NULL,
  `incluye` tinyint(1) DEFAULT 1,
  `dscto` double DEFAULT NULL,
  `cargo` double DEFAULT NULL,
  `subtotal` decimal(10,2) DEFAULT NULL,
  `igv` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `percepcion` double DEFAULT NULL,
  `condicion` tinyint(1) DEFAULT NULL,
  `cancelado` tinyint(1) DEFAULT 0,
  `almacen` tinyint(1) DEFAULT 0,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `compras` DISABLE KEYS */;
/*!40000 ALTER TABLE `compras` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `compras_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idcompra` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `factor` int(3) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,2) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `fvencimiento` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `compras_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `compras_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `cotizaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `tipo` tinytext DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `estado` tinyint(1) DEFAULT NULL,
  `tvalidez` text DEFAULT NULL,
  `tentrega` text DEFAULT NULL,
  `emitido` varchar(15) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `cotizaciones` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `cotizaciones_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idcotizacion` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `factor` int(3) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `dscto` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `cotizaciones_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `cotizaciones_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `departamentos` (
  `id` varchar(2) DEFAULT NULL,
  `descripcion` varchar(20) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `departamentos` DISABLE KEYS */;
INSERT INTO `departamentos` (`id`, `descripcion`) VALUES
	('01', 'AMAZONAS'),
	('02', 'ANCASH'),
	('03', 'APURIMAC'),
	('04', 'AREQUIPA'),
	('05', 'AYACUCHO'),
	('06', 'CAJAMARCA'),
	('07', 'CALLAO'),
	('08', 'CUSCO'),
	('09', 'HUANCAVELICA'),
	('10', 'HUANUCO'),
	('11', 'ICA'),
	('12', 'JUNIN'),
	('13', 'LA LIBERTAD'),
	('14', 'LAMBAYEQUE'),
	('15', 'LIMA'),
	('16', 'LORETO'),
	('17', 'MADRE DE DIOS'),
	('18', 'MOQUEGUA'),
	('19', 'PASCO'),
	('20', 'PIURA'),
	('21', 'PUNO'),
	('22', 'SAN MARTIN'),
	('23', 'TACNA'),
	('24', 'TUMBES'),
	('25', 'UCAYALI');
/*!40000 ALTER TABLE `departamentos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `despachos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `tcomprobante` char(3) DEFAULT NULL,
  `serie` char(5) DEFAULT NULL,
  `numero` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `hemision` time DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `observaciones` text DEFAULT NULL,
  `idttransporte` char(2) DEFAULT NULL,
  `idttraslado` char(2) DEFAULT NULL,
  `descripcion_traslado` varchar(255) DEFAULT NULL,
  `fenvio` date DEFAULT NULL,
  `unidad_peso` char(5) DEFAULT NULL,
  `peso_total` decimal(10,3) DEFAULT NULL,
  `paquetes` int(11) DEFAULT NULL,
  `codigo_origen` varchar(4) DEFAULT NULL,
  `ubigeo_origen` char(8) DEFAULT NULL,
  `direccion_origen` varchar(150) DEFAULT NULL,
  `codigo_entrega` varchar(4) DEFAULT NULL,
  `ubigeo_entrega` char(8) DEFAULT NULL,
  `direccion_entrega` varchar(150) DEFAULT NULL,
  `tdocumento_transporte` char(3) DEFAULT NULL,
  `ndocumento_transporte` varchar(15) DEFAULT NULL,
  `nombres_transporte` varchar(200) DEFAULT NULL,
  `licencia_conducir` varchar(50) DEFAULT NULL,
  `placa` varchar(15) DEFAULT NULL,
  `filename` varchar(50) NOT NULL,
  `ticket` varchar(50) DEFAULT NULL,
  `frecepcion` text DEFAULT NULL,
  `has_xml` tinyint(1) DEFAULT 0,
  `has_pdf` tinyint(1) DEFAULT 0,
  `has_cdr` tinyint(1) DEFAULT 0,
  `tipo_estado` char(2) DEFAULT NULL,
  `respuesta_sunat` text DEFAULT NULL,
  `qr` text DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `despachos` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `despachos_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iddespacho` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `despachos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `despachos_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `distritos` (
  `id` varchar(6) DEFAULT NULL,
  `idprovincia` varchar(4) DEFAULT NULL,
  `descripcion` varchar(40) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `distritos` DISABLE KEYS */;
INSERT INTO `distritos` (`id`, `idprovincia`, `descripcion`) VALUES
	('050303', '0503', 'SACSAMARCA'),
	('050304', '0503', 'SANTIAGO DE LUCANAMARCA'),
	('050401', '0504', 'HUANTA'),
	('050402', '0504', 'AYAHUANCO'),
	('050403', '0504', 'HUAMANGUILLA'),
	('050404', '0504', 'IGUAIN'),
	('050405', '0504', 'LURICOCHA'),
	('050406', '0504', 'SANTILLANA'),
	('050407', '0504', 'SIVIA'),
	('050408', '0504', 'LLOCHEGUA'),
	('050501', '0505', 'SAN MIGUEL'),
	('050502', '0505', 'ANCO'),
	('050503', '0505', 'AYNA'),
	('050504', '0505', 'CHILCAS'),
	('050505', '0505', 'CHUNGUI'),
	('050506', '0505', 'LUIS CARRANZA'),
	('050507', '0505', 'SANTA ROSA'),
	('050508', '0505', 'TAMBO'),
	('050601', '0506', 'PUQUIO'),
	('050602', '0506', 'AUCARA'),
	('050603', '0506', 'CABANA'),
	('050604', '0506', 'CARMEN SALCEDO'),
	('050605', '0506', 'CHAVIÑA'),
	('050606', '0506', 'CHIPAO'),
	('050607', '0506', 'HUAC-HUAS'),
	('050608', '0506', 'LARAMATE'),
	('050609', '0506', 'LEONCIO PRADO'),
	('050610', '0506', 'LLAUTA'),
	('050611', '0506', 'LUCANAS'),
	('050612', '0506', 'OCAÑA'),
	('050613', '0506', 'OTOCA'),
	('050614', '0506', 'SAISA'),
	('050615', '0506', 'SAN CRISTOBAL'),
	('050616', '0506', 'SAN JUAN'),
	('050617', '0506', 'SAN PEDRO'),
	('050618', '0506', 'SAN PEDRO DE PALCO'),
	('050619', '0506', 'SANCOS'),
	('050620', '0506', 'SANTA ANA DE HUAYCAHUACHO'),
	('050621', '0506', 'SANTA LUCIA'),
	('050701', '0507', 'CORACORA'),
	('050702', '0507', 'CHUMPI'),
	('050703', '0507', 'CORONEL CASTAÑEDA'),
	('050704', '0507', 'PACAPAUSA'),
	('050705', '0507', 'PULLO'),
	('050706', '0507', 'PUYUSCA'),
	('050707', '0507', 'SAN FRANCISCO DE RAVACAYCO'),
	('050708', '0507', 'UPAHUACHO'),
	('050801', '0508', 'PAUSA'),
	('050802', '0508', 'COLTA'),
	('050803', '0508', 'CORCULLA'),
	('050804', '0508', 'LAMPA'),
	('050805', '0508', 'MARCABAMBA'),
	('050806', '0508', 'OYOLO'),
	('050807', '0508', 'PARARCA'),
	('050808', '0508', 'SAN JAVIER DE ALPABAMBA'),
	('050809', '0508', 'SAN JOSE DE USHUA'),
	('050810', '0508', 'SARA SARA'),
	('050901', '0509', 'QUEROBAMBA'),
	('050902', '0509', 'BELEN'),
	('050903', '0509', 'CHALCOS'),
	('050904', '0509', 'CHILCAYOC'),
	('050905', '0509', 'HUACAÑA'),
	('050906', '0509', 'MORCOLLA'),
	('050907', '0509', 'PAICO'),
	('050908', '0509', 'SAN PEDRO DE LARCAY'),
	('050909', '0509', 'SAN SALVADOR DE QUIJE'),
	('050910', '0509', 'SANTIAGO DE PAUCARAY'),
	('050911', '0509', 'SORAS'),
	('051001', '0510', 'HUANCAPI'),
	('051002', '0510', 'ALCAMENCA'),
	('051003', '0510', 'APONGO'),
	('051004', '0510', 'ASQUIPATA'),
	('051005', '0510', 'CANARIA'),
	('051006', '0510', 'CAYARA'),
	('051007', '0510', 'COLCA'),
	('051008', '0510', 'HUAMANQUIQUIA'),
	('051009', '0510', 'HUANCARAYLLA'),
	('051010', '0510', 'HUAYA'),
	('051011', '0510', 'SARHUA'),
	('051012', '0510', 'VILCANCHOS'),
	('051101', '0511', 'VILCAS HUAMAN'),
	('051102', '0511', 'ACCOMARCA'),
	('051103', '0511', 'CARHUANCA'),
	('051104', '0511', 'CONCEPCION'),
	('051105', '0511', 'HUAMBALPA'),
	('051106', '0511', 'INDEPENDENCIA'),
	('051107', '0511', 'SAURAMA'),
	('051108', '0511', 'VISCHONGO'),
	('060101', '0601', 'CAJAMARCA'),
	('060102', '0601', 'ASUNCION'),
	('060103', '0601', 'CHETILLA'),
	('060104', '0601', 'COSPAN'),
	('060105', '0601', 'ENCAÑADA'),
	('060106', '0601', 'JESUS'),
	('060107', '0601', 'LLACANORA'),
	('060108', '0601', 'LOS BAÑOS DEL INCA'),
	('060109', '0601', 'MAGDALENA'),
	('060110', '0601', 'MATARA'),
	('060111', '0601', 'NAMORA'),
	('060112', '0601', 'SAN JUAN'),
	('060201', '0602', 'CAJABAMBA'),
	('060202', '0602', 'CACHACHI'),
	('060203', '0602', 'CONDEBAMBA'),
	('060204', '0602', 'SITACOCHA'),
	('060301', '0603', 'CELENDIN'),
	('060302', '0603', 'CHUMUCH'),
	('060303', '0603', 'CORTEGANA'),
	('060304', '0603', 'HUASMIN'),
	('060305', '0603', 'JORGE CHAVEZ'),
	('060306', '0603', 'JOSE GALVEZ'),
	('060307', '0603', 'MIGUEL IGLESIAS'),
	('060308', '0603', 'OXAMARCA'),
	('060309', '0603', 'SOROCHUCO'),
	('060310', '0603', 'SUCRE'),
	('060311', '0603', 'UTCO'),
	('060312', '0603', 'LA LIBERTAD DE PALLAN'),
	('060401', '0604', 'CHOTA'),
	('060402', '0604', 'ANGUIA'),
	('060403', '0604', 'CHADIN'),
	('060404', '0604', 'CHIGUIRIP'),
	('060405', '0604', 'CHIMBAN'),
	('060406', '0604', 'CHOROPAMPA'),
	('060407', '0604', 'COCHABAMBA'),
	('060408', '0604', 'CONCHAN'),
	('060409', '0604', 'HUAMBOS'),
	('060410', '0604', 'LAJAS'),
	('060411', '0604', 'LLAMA'),
	('060412', '0604', 'MIRACOSTA'),
	('060413', '0604', 'PACCHA'),
	('060414', '0604', 'PION'),
	('060415', '0604', 'QUEROCOTO'),
	('060416', '0604', 'SAN JUAN DE LICUPIS'),
	('060417', '0604', 'TACABAMBA'),
	('060418', '0604', 'TOCMOCHE'),
	('060419', '0604', 'CHALAMARCA'),
	('060501', '0605', 'CONTUMAZA'),
	('060502', '0605', 'CHILETE'),
	('060503', '0605', 'CUPISNIQUE'),
	('060504', '0605', 'GUZMANGO'),
	('060505', '0605', 'SAN BENITO'),
	('060506', '0605', 'SANTA CRUZ DE TOLED'),
	('060507', '0605', 'TANTARICA'),
	('060508', '0605', 'YONAN'),
	('060601', '0606', 'CUTERVO'),
	('060602', '0606', 'CALLAYUC'),
	('060603', '0606', 'CHOROS'),
	('060604', '0606', 'CUJILLO'),
	('060605', '0606', 'LA RAMADA'),
	('060606', '0606', 'PIMPINGOS'),
	('060607', '0606', 'QUEROCOTILLO'),
	('060608', '0606', 'SAN ANDRES DE CUTERVO'),
	('060609', '0606', 'SAN JUAN DE CUTERVO'),
	('060610', '0606', 'SAN LUIS DE LUCMA'),
	('060611', '0606', 'SANTA CRUZ'),
	('060612', '0606', 'SANTO DOMINGO DE LA CAPILLA'),
	('060613', '0606', 'SANTO TOMAS'),
	('060614', '0606', 'SOCOTA'),
	('060615', '0606', 'TORIBIO CASANOVA'),
	('060701', '0607', 'BAMBAMARCA'),
	('060702', '0607', 'CHUGUR'),
	('060703', '0607', 'HUALGAYOC'),
	('060801', '0608', 'JAEN'),
	('060802', '0608', 'BELLAVISTA'),
	('060803', '0608', 'CHONTALI'),
	('060804', '0608', 'COLASAY'),
	('060805', '0608', 'HUABAL'),
	('060806', '0608', 'LAS PIRIAS'),
	('060807', '0608', 'POMAHUACA'),
	('060808', '0608', 'PUCARA'),
	('060809', '0608', 'SALLIQUE'),
	('060810', '0608', 'SAN FELIPE'),
	('060811', '0608', 'SAN JOSE DEL ALTO'),
	('060812', '0608', 'SANTA ROSA'),
	('060901', '0609', 'SAN IGNACIO'),
	('060902', '0609', 'CHIRINOS'),
	('060903', '0609', 'HUARANGO'),
	('060904', '0609', 'LA COIPA'),
	('060905', '0609', 'NAMBALLE'),
	('060906', '0609', 'SAN JOSE DE LOURDES'),
	('060907', '0609', 'TABACONAS'),
	('061001', '0610', 'PEDRO GALVEZ'),
	('061002', '0610', 'CHANCAY'),
	('061003', '0610', 'EDUARDO VILLANUEVA'),
	('061004', '0610', 'GREGORIO PITA'),
	('061005', '0610', 'ICHOCAN'),
	('061006', '0610', 'JOSE MANUEL QUIROZ'),
	('061007', '0610', 'JOSE SABOGAL'),
	('061101', '0611', 'SAN MIGUEL'),
	('061102', '0611', 'BOLIVAR'),
	('061103', '0611', 'CALQUIS'),
	('061104', '0611', 'CATILLUC'),
	('061105', '0611', 'EL PRADO'),
	('061106', '0611', 'LA FLORIDA'),
	('061107', '0611', 'LLAPA'),
	('061108', '0611', 'NANCHOC'),
	('061109', '0611', 'NIEPOS'),
	('061110', '0611', 'SAN GREGORIO'),
	('061111', '0611', 'SAN SILVESTRE DE COCHAN'),
	('061112', '0611', 'TONGOD'),
	('061113', '0611', 'UNION AGUA BLANCA'),
	('061201', '0612', 'SAN PABLO'),
	('061202', '0612', 'SAN BERNARDINO'),
	('061203', '0612', 'SAN LUIS'),
	('061204', '0612', 'TUMBADEN'),
	('061301', '0613', 'SANTA CRUZ'),
	('061302', '0613', 'ANDABAMBA'),
	('061303', '0613', 'CATACHE'),
	('061304', '0613', 'CHANCAYBAÑOS'),
	('061305', '0613', 'LA ESPERANZA'),
	('061306', '0613', 'NINABAMBA'),
	('061307', '0613', 'PULAN'),
	('061308', '0613', 'SAUCEPAMPA'),
	('061309', '0613', 'SEXI'),
	('061310', '0613', 'UTICYACU'),
	('061311', '0613', 'YAUYUCAN'),
	('070101', '0701', 'CALLAO'),
	('070102', '0701', 'BELLAVISTA'),
	('070103', '0701', 'CARMEN DE LA LEGUA REYNOSO'),
	('070104', '0701', 'LA PERLA'),
	('070105', '0701', 'LA PUNTA'),
	('070106', '0701', 'VENTANILLA'),
	('080101', '0801', 'CUSCO'),
	('080102', '0801', 'CCORCA'),
	('080103', '0801', 'POROY'),
	('010101', '0101', 'CHACHAPOYAS'),
	('010102', '0101', 'ASUNCION'),
	('010103', '0101', 'BALSAS'),
	('010104', '0101', 'CHETO'),
	('010105', '0101', 'CHILIQUIN'),
	('010106', '0101', 'CHUQUIBAMBA'),
	('010107', '0101', 'GRANADA'),
	('010108', '0101', 'HUANCAS'),
	('010109', '0101', 'LA JALCA'),
	('010110', '0101', 'LEIMEBAMBA'),
	('010111', '0101', 'LEVANTO'),
	('010112', '0101', 'MAGDALENA'),
	('010113', '0101', 'MARISCAL CASTILLA'),
	('010114', '0101', 'MOLINOPAMPA'),
	('010115', '0101', 'MONTEVIDEO'),
	('010116', '0101', 'OLLEROS'),
	('010117', '0101', 'QUINJALCA'),
	('010118', '0101', 'SAN FRANCISCO DE DAGUAS'),
	('010119', '0101', 'SAN ISIDRO DE MAINO'),
	('010120', '0101', 'SOLOCO'),
	('010121', '0101', 'SONCHE'),
	('010201', '0102', 'LA PECA'),
	('010202', '0102', 'ARAMANGO'),
	('010203', '0102', 'COPALLIN'),
	('010204', '0102', 'EL PARCO'),
	('010205', '0102', 'IMAZA'),
	('010301', '0103', 'JUMBILLA'),
	('010302', '0103', 'CHISQUILLA'),
	('010303', '0103', 'CHURUJA'),
	('010304', '0103', 'COROSHA'),
	('010305', '0103', 'CUISPES'),
	('010306', '0103', 'FLORIDA'),
	('010307', '0103', 'JAZAN'),
	('010308', '0103', 'RECTA'),
	('010309', '0103', 'SAN CARLOS'),
	('010310', '0103', 'SHIPASBAMBA'),
	('010311', '0103', 'VALERA'),
	('010312', '0103', 'YAMBRASBAMBA'),
	('010401', '0104', 'NIEVA'),
	('010402', '0104', 'EL CENEPA'),
	('010403', '0104', 'RIO SANTIAGO'),
	('010501', '0105', 'LAMUD'),
	('010502', '0105', 'CAMPORREDONDO'),
	('010503', '0105', 'COCABAMBA'),
	('010504', '0105', 'COLCAMAR'),
	('010505', '0105', 'CONILA'),
	('010506', '0105', 'INGUILPATA'),
	('010507', '0105', 'LONGUITA'),
	('010508', '0105', 'LONYA CHICO'),
	('010509', '0105', 'LUYA'),
	('010510', '0105', 'LUYA VIEJO'),
	('010511', '0105', 'MARIA'),
	('010512', '0105', 'OCALLI'),
	('010513', '0105', 'OCUMAL'),
	('010514', '0105', 'PISUQUIA'),
	('010515', '0105', 'PROVIDENCIA'),
	('010516', '0105', 'SAN CRISTOBAL'),
	('010517', '0105', 'SAN FRANCISCO DEL YESO'),
	('010518', '0105', 'SAN JERONIMO'),
	('010519', '0105', 'SAN JUAN DE LOPECANCHA'),
	('010520', '0105', 'SANTA CATALINA'),
	('010521', '0105', 'SANTO TOMAS'),
	('010522', '0105', 'TINGO'),
	('010523', '0105', 'TRITA'),
	('010601', '0106', 'SAN NICOLAS'),
	('010602', '0106', 'CHIRIMOTO'),
	('010603', '0106', 'COCHAMAL'),
	('010604', '0106', 'HUAMBO'),
	('010605', '0106', 'LIMABAMBA'),
	('010606', '0106', 'LONGAR'),
	('010607', '0106', 'MARISCAL BENAVIDES'),
	('010608', '0106', 'MILPUC'),
	('010609', '0106', 'OMIA'),
	('010610', '0106', 'SANTA ROSA'),
	('010611', '0106', 'TOTORA'),
	('010612', '0106', 'VISTA ALEGRE'),
	('010701', '0107', 'BAGUA GRANDE'),
	('010702', '0107', 'CAJARURO'),
	('010703', '0107', 'CUMBA'),
	('010704', '0107', 'EL MILAGRO'),
	('010705', '0107', 'JAMALCA'),
	('010706', '0107', 'LONYA GRANDE'),
	('010707', '0107', 'YAMON'),
	('020101', '0201', 'HUARAZ'),
	('020102', '0201', 'COCHABAMBA'),
	('020103', '0201', 'COLCABAMBA'),
	('020104', '0201', 'HUANCHAY'),
	('020105', '0201', 'INDEPENDENCIA'),
	('020106', '0201', 'JANGAS'),
	('020107', '0201', 'LA LIBERTAD'),
	('020108', '0201', 'OLLEROS'),
	('020109', '0201', 'PAMPAS'),
	('020110', '0201', 'PARIACOTO'),
	('020111', '0201', 'PIRA'),
	('020112', '0201', 'TARICA'),
	('020201', '0202', 'AIJA'),
	('020202', '0202', 'CORIS'),
	('020203', '0202', 'HUACLLAN'),
	('020204', '0202', 'LA MERCED'),
	('020205', '0202', 'SUCCHA'),
	('020301', '0203', 'LLAMELLIN'),
	('020302', '0203', 'ACZO'),
	('020303', '0203', 'CHACCHO'),
	('020304', '0203', 'CHINGAS'),
	('020305', '0203', 'MIRGAS'),
	('020306', '0203', 'SAN JUAN DE RONTOY'),
	('020401', '0204', 'CHACAS'),
	('020402', '0204', 'ACOCHACA'),
	('020501', '0205', 'CHIQUIAN'),
	('020502', '0205', 'ABELARDO PARDO LEZAMETA'),
	('020503', '0205', 'ANTONIO RAYMONDI'),
	('020504', '0205', 'AQUIA'),
	('020505', '0205', 'CAJACAY'),
	('020506', '0205', 'CANIS'),
	('020507', '0205', 'COLQUIOC'),
	('020508', '0205', 'HUALLANCA'),
	('020509', '0205', 'HUASTA'),
	('020510', '0205', 'HUAYLLACAYAN'),
	('020511', '0205', 'LA PRIMAVERA'),
	('020512', '0205', 'MANGAS'),
	('020513', '0205', 'PACLLON'),
	('020514', '0205', 'SAN MIGUEL DE CORPANQUI'),
	('020515', '0205', 'TICLLOS'),
	('020601', '0206', 'CARHUAZ'),
	('020602', '0206', 'ACOPAMPA'),
	('020603', '0206', 'AMASHCA'),
	('020604', '0206', 'ANTA'),
	('020605', '0206', 'ATAQUERO'),
	('020606', '0206', 'MARCARA'),
	('020607', '0206', 'PARIAHUANCA'),
	('020608', '0206', 'SAN MIGUEL DE ACO'),
	('020609', '0206', 'SHILLA'),
	('020610', '0206', 'TINCO'),
	('020611', '0206', 'YUNGAR'),
	('020701', '0207', 'SAN LUIS'),
	('020702', '0207', 'SAN NICOLAS'),
	('020703', '0207', 'YAUYA'),
	('020801', '0208', 'CASMA'),
	('020802', '0208', 'BUENA VISTA ALTA'),
	('020803', '0208', 'COMANDANTE NOEL'),
	('020804', '0208', 'YAUTAN'),
	('020901', '0209', 'CORONGO'),
	('020902', '0209', 'ACO'),
	('020903', '0209', 'BAMBAS'),
	('020904', '0209', 'CUSCA'),
	('020905', '0209', 'LA PAMPA'),
	('020906', '0209', 'YANAC'),
	('020907', '0209', 'YUPAN'),
	('021001', '0210', 'HUARI'),
	('021002', '0210', 'ANRA'),
	('021003', '0210', 'CAJAY'),
	('021004', '0210', 'CHAVIN DE HUANTAR'),
	('021005', '0210', 'HUACACHI'),
	('021006', '0210', 'HUACCHIS'),
	('021007', '0210', 'HUACHIS'),
	('021008', '0210', 'HUANTAR'),
	('021009', '0210', 'MASIN'),
	('021010', '0210', 'PAUCAS'),
	('021011', '0210', 'PONTO'),
	('021012', '0210', 'RAHUAPAMPA'),
	('021013', '0210', 'RAPAYAN'),
	('021014', '0210', 'SAN MARCOS'),
	('021015', '0210', 'SAN PEDRO DE CHANA'),
	('021016', '0210', 'UCO'),
	('021101', '0211', 'HUARMEY'),
	('021102', '0211', 'COCHAPETI'),
	('021103', '0211', 'CULEBRAS'),
	('021104', '0211', 'HUAYAN'),
	('021105', '0211', 'MALVAS'),
	('021201', '0212', 'CARAZ'),
	('021202', '0212', 'HUALLANCA'),
	('021203', '0212', 'HUATA'),
	('021204', '0212', 'HUAYLAS'),
	('021205', '0212', 'MATO'),
	('021206', '0212', 'PAMPAROMAS'),
	('021207', '0212', 'PUEBLO LIBRE'),
	('021208', '0212', 'SANTA CRUZ'),
	('021209', '0212', 'SANTO TORIBIO'),
	('021210', '0212', 'YURACMARCA'),
	('021301', '0213', 'PISCOBAMBA'),
	('021302', '0213', 'CASCA'),
	('021303', '0213', 'ELEAZAR GUZMAN BARRON'),
	('021304', '0213', 'FIDEL OLIVAS ESCUDERO'),
	('021305', '0213', 'LLAMA'),
	('021306', '0213', 'LLUMPA'),
	('021307', '0213', 'LUCMA'),
	('021308', '0213', 'MUSGA'),
	('021401', '0214', 'OCROS'),
	('021402', '0214', 'ACAS'),
	('021403', '0214', 'CAJAMARQUILLA'),
	('021404', '0214', 'CARHUAPAMPA'),
	('021405', '0214', 'COCHAS'),
	('021406', '0214', 'CONGAS'),
	('021407', '0214', 'LLIPA'),
	('021408', '0214', 'SAN CRISTOBAL DE RAJAN'),
	('021409', '0214', 'SAN PEDRO'),
	('021410', '0214', 'SANTIAGO DE CHILCAS'),
	('021501', '0215', 'CABANA'),
	('021502', '0215', 'BOLOGNESI'),
	('021503', '0215', 'CONCHUCOS'),
	('021504', '0215', 'HUACASCHUQUE'),
	('021505', '0215', 'HUANDOVAL'),
	('021506', '0215', 'LACABAMBA'),
	('021507', '0215', 'LLAPO'),
	('021508', '0215', 'PALLASCA'),
	('021509', '0215', 'PAMPAS'),
	('021510', '0215', 'SANTA ROSA'),
	('021511', '0215', 'TAUCA'),
	('021601', '0216', 'POMABAMBA'),
	('021602', '0216', 'HUAYLLAN'),
	('021603', '0216', 'PAROBAMBA'),
	('021604', '0216', 'QUINUABAMBA'),
	('021701', '0217', 'RECUAY'),
	('021702', '0217', 'CATAC'),
	('021703', '0217', 'COTAPARACO'),
	('021704', '0217', 'HUAYLLAPAMPA'),
	('021705', '0217', 'LLACLLIN'),
	('021706', '0217', 'MARCA'),
	('021707', '0217', 'PAMPAS CHICO'),
	('021708', '0217', 'PARARIN'),
	('021709', '0217', 'TAPACOCHA'),
	('021710', '0217', 'TICAPAMPA'),
	('021801', '0218', 'CHIMBOTE'),
	('021802', '0218', 'CACERES DEL PERU'),
	('021803', '0218', 'COISHCO'),
	('021804', '0218', 'MACATE'),
	('021805', '0218', 'MORO'),
	('021806', '0218', 'NEPEÑA'),
	('021807', '0218', 'SAMANCO'),
	('021808', '0218', 'SANTA'),
	('021809', '0218', 'NUEVO CHIMBOTE'),
	('021901', '0219', 'SIHUAS'),
	('021902', '0219', 'ACOBAMBA'),
	('021903', '0219', 'ALFONSO UGARTE'),
	('021904', '0219', 'CASHAPAMPA'),
	('021905', '0219', 'CHINGALPO'),
	('021906', '0219', 'HUAYLLABAMBA'),
	('021907', '0219', 'QUICHES'),
	('021908', '0219', 'RAGASH'),
	('021909', '0219', 'SAN JUAN'),
	('021910', '0219', 'SICSIBAMBA'),
	('022001', '0220', 'YUNGAY'),
	('022002', '0220', 'CASCAPARA'),
	('022003', '0220', 'MANCOS'),
	('022004', '0220', 'MATACOTO'),
	('022005', '0220', 'QUILLO'),
	('022006', '0220', 'RANRAHIRCA'),
	('022007', '0220', 'SHUPLUY'),
	('022008', '0220', 'YANAMA'),
	('030101', '0301', 'ABANCAY'),
	('030102', '0301', 'CHACOCHE'),
	('030103', '0301', 'CIRCA'),
	('030104', '0301', 'CURAHUASI'),
	('030105', '0301', 'HUANIPACA'),
	('030106', '0301', 'LAMBRAMA'),
	('030107', '0301', 'PICHIRHUA'),
	('030108', '0301', 'SAN PEDRO DE CACHORA'),
	('030109', '0301', 'TAMBURCO'),
	('030201', '0302', 'ANDAHUAYLAS'),
	('030202', '0302', 'ANDARAPA'),
	('030203', '0302', 'CHIARA'),
	('030204', '0302', 'HUANCARAMA'),
	('030205', '0302', 'HUANCARAY'),
	('030206', '0302', 'HUAYANA'),
	('030207', '0302', 'KISHUARA'),
	('030208', '0302', 'PACOBAMBA'),
	('030209', '0302', 'PACUCHA'),
	('030210', '0302', 'PAMPACHIRI'),
	('030211', '0302', 'POMACOCHA'),
	('030212', '0302', 'SAN ANTONIO DE CACHI'),
	('030213', '0302', 'SAN JERONIMO'),
	('030214', '0302', 'SAN MIGUEL DE CHACCRAMPA'),
	('030215', '0302', 'SANTA MARIA DE CHICMO'),
	('030216', '0302', 'TALAVERA'),
	('030217', '0302', 'TUMAY HUARACA'),
	('030218', '0302', 'TURPO'),
	('030219', '0302', 'KAQUIABAMBA'),
	('030301', '0303', 'ANTABAMBA'),
	('030302', '0303', 'EL ORO'),
	('030303', '0303', 'HUAQUIRCA'),
	('030304', '0303', 'JUAN ESPINOZA MEDRANO'),
	('030305', '0303', 'OROPESA'),
	('030306', '0303', 'PACHACONAS'),
	('030307', '0303', 'SABAINO'),
	('030401', '0304', 'CHALHUANCA'),
	('030402', '0304', 'CAPAYA'),
	('030403', '0304', 'CARAYBAMBA'),
	('030404', '0304', 'CHAPIMARCA'),
	('030405', '0304', 'COLCABAMBA'),
	('030406', '0304', 'COTARUSE'),
	('030407', '0304', 'HUAYLLO'),
	('030408', '0304', 'JUSTO APU SAHUARAURA'),
	('030409', '0304', 'LUCRE'),
	('030410', '0304', 'POCOHUANCA'),
	('030411', '0304', 'SAN JUAN DE CHACÑA'),
	('030412', '0304', 'SAÑAYCA'),
	('030413', '0304', 'SORAYA'),
	('030414', '0304', 'TAPAIRIHUA'),
	('030415', '0304', 'TINTAY'),
	('030416', '0304', 'TORAYA'),
	('030417', '0304', 'YANACA'),
	('030501', '0305', 'TAMBOBAMBA'),
	('030502', '0305', 'COTABAMBAS'),
	('030503', '0305', 'COYLLURQUI'),
	('030504', '0305', 'HAQUIRA'),
	('030505', '0305', 'MARA'),
	('030506', '0305', 'CHALLHUAHUACHO'),
	('030601', '0306', 'CHINCHEROS'),
	('030602', '0306', 'ANCO_HUALLO'),
	('030603', '0306', 'COCHARCAS'),
	('030604', '0306', 'HUACCANA'),
	('030605', '0306', 'OCOBAMBA'),
	('030606', '0306', 'ONGOY'),
	('030607', '0306', 'URANMARCA'),
	('030608', '0306', 'RANRACANCHA'),
	('030701', '0307', 'CHUQUIBAMBILLA'),
	('030702', '0307', 'CURPAHUASI'),
	('030703', '0307', 'GAMARRA'),
	('030704', '0307', 'HUAYLLATI'),
	('030705', '0307', 'MAMARA'),
	('030706', '0307', 'MICAELA BASTIDAS'),
	('030707', '0307', 'PATAYPAMPA'),
	('030708', '0307', 'PROGRESO'),
	('030709', '0307', 'SAN ANTONIO'),
	('030710', '0307', 'SANTA ROSA'),
	('030711', '0307', 'TURPAY'),
	('030712', '0307', 'VILCABAMBA'),
	('030713', '0307', 'VIRUNDO'),
	('030714', '0307', 'CURASCO'),
	('040101', '0401', 'AREQUIPA'),
	('040102', '0401', 'ALTO SELVA ALEGRE'),
	('040103', '0401', 'CAYMA'),
	('040104', '0401', 'CERRO COLORADO'),
	('040105', '0401', 'CHARACATO'),
	('040106', '0401', 'CHIGUATA'),
	('040107', '0401', 'JACOBO HUNTER'),
	('040108', '0401', 'LA JOYA'),
	('040109', '0401', 'MARIANO MELGAR'),
	('040110', '0401', 'MIRAFLORES'),
	('040111', '0401', 'MOLLEBAYA'),
	('040112', '0401', 'PAUCARPATA'),
	('040113', '0401', 'POCSI'),
	('040114', '0401', 'POLOBAYA'),
	('040115', '0401', 'QUEQUEÑA'),
	('040116', '0401', 'SABANDIA'),
	('040117', '0401', 'SACHACA'),
	('040118', '0401', 'SAN JUAN DE SIGUAS'),
	('040119', '0401', 'SAN JUAN DE TARUCANI'),
	('040120', '0401', 'SANTA ISABEL DE SIGUAS'),
	('040121', '0401', 'SANTA RITA DE SIGUAS'),
	('040122', '0401', 'SOCABAYA'),
	('040123', '0401', 'TIABAYA'),
	('040124', '0401', 'UCHUMAYO'),
	('040125', '0401', 'VITOR'),
	('040126', '0401', 'YANAHUARA'),
	('040127', '0401', 'YARABAMBA'),
	('040128', '0401', 'YURA'),
	('040129', '0401', 'JOSE LUIS BUSTAMANTE Y RIVERO'),
	('040201', '0402', 'CAMANA'),
	('040202', '0402', 'JOSE MARIA QUIMPER'),
	('040203', '0402', 'MARIANO NICOLAS VALCARCEL'),
	('040204', '0402', 'MARISCAL CACERES'),
	('040205', '0402', 'NICOLAS DE PIEROLA'),
	('040206', '0402', 'OCOÑA'),
	('040207', '0402', 'QUILCA'),
	('040208', '0402', 'SAMUEL PASTOR'),
	('040301', '0403', 'CARAVELI'),
	('040302', '0403', 'ACARI'),
	('040303', '0403', 'ATICO'),
	('040304', '0403', 'ATIQUIPA'),
	('040305', '0403', 'BELLA UNION'),
	('040306', '0403', 'CAHUACHO'),
	('040307', '0403', 'CHALA'),
	('040308', '0403', 'CHAPARRA'),
	('040309', '0403', 'HUANUHUANU'),
	('040310', '0403', 'JAQUI'),
	('040311', '0403', 'LOMAS'),
	('040312', '0403', 'QUICACHA'),
	('040313', '0403', 'YAUCA'),
	('040401', '0404', 'APLAO'),
	('040402', '0404', 'ANDAGUA'),
	('040403', '0404', 'AYO'),
	('040404', '0404', 'CHACHAS'),
	('040405', '0404', 'CHILCAYMARCA'),
	('040406', '0404', 'CHOCO'),
	('040407', '0404', 'HUANCARQUI'),
	('040408', '0404', 'MACHAGUAY'),
	('040409', '0404', 'ORCOPAMPA'),
	('040410', '0404', 'PAMPACOLCA'),
	('040411', '0404', 'TIPAN'),
	('040412', '0404', 'UÑON'),
	('040413', '0404', 'URACA'),
	('040414', '0404', 'VIRACO'),
	('040501', '0405', 'CHIVAY'),
	('040502', '0405', 'ACHOMA'),
	('040503', '0405', 'CABANACONDE'),
	('040504', '0405', 'CALLALLI'),
	('040505', '0405', 'CAYLLOMA'),
	('040506', '0405', 'COPORAQUE'),
	('040507', '0405', 'HUAMBO'),
	('040508', '0405', 'HUANCA'),
	('040509', '0405', 'ICHUPAMPA'),
	('040510', '0405', 'LARI'),
	('040511', '0405', 'LLUTA'),
	('040512', '0405', 'MACA'),
	('040513', '0405', 'MADRIGAL'),
	('040514', '0405', 'SAN ANTONIO DE CHUCA'),
	('040515', '0405', 'SIBAYO'),
	('040516', '0405', 'TAPAY'),
	('040517', '0405', 'TISCO'),
	('040518', '0405', 'TUTI'),
	('040519', '0405', 'YANQUE'),
	('040520', '0405', 'MAJES'),
	('040601', '0406', 'CHUQUIBAMBA'),
	('040602', '0406', 'ANDARAY'),
	('040603', '0406', 'CAYARANI'),
	('040604', '0406', 'CHICHAS'),
	('040605', '0406', 'IRAY'),
	('040606', '0406', 'RIO GRANDE'),
	('040607', '0406', 'SALAMANCA'),
	('040608', '0406', 'YANAQUIHUA'),
	('040701', '0407', 'MOLLENDO'),
	('040702', '0407', 'COCACHACRA'),
	('040703', '0407', 'DEAN VALDIVIA'),
	('040704', '0407', 'ISLAY'),
	('040705', '0407', 'MEJIA'),
	('040706', '0407', 'PUNTA DE BOMBON'),
	('040801', '0408', 'COTAHUASI'),
	('040802', '0408', 'ALCA'),
	('040803', '0408', 'CHARCANA'),
	('040804', '0408', 'HUAYNACOTAS'),
	('040805', '0408', 'PAMPAMARCA'),
	('040806', '0408', 'PUYCA'),
	('040807', '0408', 'QUECHUALLA'),
	('040808', '0408', 'SAYLA'),
	('040809', '0408', 'TAURIA'),
	('040810', '0408', 'TOMEPAMPA'),
	('040811', '0408', 'TORO'),
	('050101', '0501', 'AYACUCHO'),
	('050102', '0501', 'ACOCRO'),
	('050103', '0501', 'ACOS VINCHOS'),
	('050104', '0501', 'CARMEN ALTO'),
	('050105', '0501', 'CHIARA'),
	('050106', '0501', 'OCROS'),
	('050107', '0501', 'PACAYCASA'),
	('050108', '0501', 'QUINUA'),
	('050109', '0501', 'SAN JOSE DE TICLLAS'),
	('050110', '0501', 'SAN JUAN BAUTISTA'),
	('050111', '0501', 'SANTIAGO DE PISCHA'),
	('050112', '0501', 'SOCOS'),
	('050113', '0501', 'TAMBILLO'),
	('050114', '0501', 'VINCHOS'),
	('050115', '0501', 'JESUS NAZARENO'),
	('050201', '0502', 'CANGALLO'),
	('050202', '0502', 'CHUSCHI'),
	('050203', '0502', 'LOS MOROCHUCOS'),
	('050204', '0502', 'MARIA PARADO DE BELLIDO'),
	('050205', '0502', 'PARAS'),
	('050206', '0502', 'TOTOS'),
	('050301', '0503', 'SANCOS'),
	('050302', '0503', 'CARAPO'),
	('080104', '0801', 'SAN JERONIMO'),
	('080105', '0801', 'SAN SEBASTIAN'),
	('080106', '0801', 'SANTIAGO'),
	('080107', '0801', 'SAYLLA'),
	('080108', '0801', 'WANCHAQ'),
	('080201', '0802', 'ACOMAYO'),
	('080202', '0802', 'ACOPIA'),
	('080203', '0802', 'ACOS'),
	('080204', '0802', 'MOSOC LLACTA'),
	('080205', '0802', 'POMACANCHI'),
	('080206', '0802', 'RONDOCAN'),
	('080207', '0802', 'SANGARARA'),
	('080301', '0803', 'ANTA'),
	('080302', '0803', 'ANCAHUASI'),
	('080303', '0803', 'CACHIMAYO'),
	('080304', '0803', 'CHINCHAYPUJIO'),
	('080305', '0803', 'HUAROCONDO'),
	('080306', '0803', 'LIMATAMBO'),
	('080307', '0803', 'MOLLEPATA'),
	('080308', '0803', 'PUCYURA'),
	('080309', '0803', 'ZURITE'),
	('080401', '0804', 'CALCA'),
	('080402', '0804', 'COYA'),
	('080403', '0804', 'LAMAY'),
	('080404', '0804', 'LARES'),
	('080405', '0804', 'PISAC'),
	('080406', '0804', 'SAN SALVADOR'),
	('080407', '0804', 'TARAY'),
	('080408', '0804', 'YANATILE'),
	('080501', '0805', 'YANAOCA'),
	('080502', '0805', 'CHECCA'),
	('080503', '0805', 'KUNTURKANKI'),
	('080504', '0805', 'LANGUI'),
	('080505', '0805', 'LAYO'),
	('080506', '0805', 'PAMPAMARCA'),
	('080507', '0805', 'QUEHUE'),
	('080508', '0805', 'TUPAC AMARU'),
	('080601', '0806', 'SICUANI'),
	('080602', '0806', 'CHECACUPE'),
	('080603', '0806', 'COMBAPATA'),
	('080604', '0806', 'MARANGANI'),
	('080605', '0806', 'PITUMARCA'),
	('080606', '0806', 'SAN PABLO'),
	('080607', '0806', 'SAN PEDRO'),
	('080608', '0806', 'TINTA'),
	('080701', '0807', 'SANTO TOMAS'),
	('080702', '0807', 'CAPACMARCA'),
	('080703', '0807', 'CHAMACA'),
	('080704', '0807', 'COLQUEMARCA'),
	('080705', '0807', 'LIVITACA'),
	('080706', '0807', 'LLUSCO'),
	('080707', '0807', 'QUIÑOTA'),
	('080708', '0807', 'VELILLE'),
	('080801', '0808', 'ESPINAR'),
	('080802', '0808', 'CONDOROMA'),
	('080803', '0808', 'COPORAQUE'),
	('080804', '0808', 'OCORURO'),
	('080805', '0808', 'PALLPATA'),
	('080806', '0808', 'PICHIGUA'),
	('080807', '0808', 'SUYCKUTAMBO'),
	('080808', '0808', 'ALTO PICHIGUA'),
	('080901', '0809', 'SANTA ANA'),
	('080902', '0809', 'ECHARATE'),
	('080903', '0809', 'HUAYOPATA'),
	('080904', '0809', 'MARANURA'),
	('080905', '0809', 'OCOBAMBA'),
	('080906', '0809', 'QUELLOUNO'),
	('080907', '0809', 'KIMBIRI'),
	('080908', '0809', 'SANTA TERESA'),
	('080909', '0809', 'VILCABAMBA'),
	('080910', '0809', 'PICHARI'),
	('081001', '0810', 'PARURO'),
	('081002', '0810', 'ACCHA'),
	('081003', '0810', 'CCAPI'),
	('081004', '0810', 'COLCHA'),
	('081005', '0810', 'HUANOQUITE'),
	('081006', '0810', 'OMACHA'),
	('081007', '0810', 'PACCARITAMBO'),
	('081008', '0810', 'PILLPINTO'),
	('081009', '0810', 'YAURISQUE'),
	('081101', '0811', 'PAUCARTAMBO'),
	('081102', '0811', 'CAICAY'),
	('081103', '0811', 'CHALLABAMBA'),
	('081104', '0811', 'COLQUEPATA'),
	('081105', '0811', 'HUANCARANI'),
	('081106', '0811', 'KOSÑIPATA'),
	('081201', '0812', 'URCOS'),
	('081202', '0812', 'ANDAHUAYLILLAS'),
	('081203', '0812', 'CAMANTI'),
	('081204', '0812', 'CCARHUAYO'),
	('081205', '0812', 'CCATCA'),
	('081206', '0812', 'CUSIPATA'),
	('081207', '0812', 'HUARO'),
	('081208', '0812', 'LUCRE'),
	('081209', '0812', 'MARCAPATA'),
	('081210', '0812', 'OCONGATE'),
	('081211', '0812', 'OROPESA'),
	('081212', '0812', 'QUIQUIJANA'),
	('081301', '0813', 'URUBAMBA'),
	('081302', '0813', 'CHINCHERO'),
	('081303', '0813', 'HUAYLLABAMBA'),
	('081304', '0813', 'MACHUPICCHU'),
	('081305', '0813', 'MARAS'),
	('081306', '0813', 'OLLANTAYTAMBO'),
	('081307', '0813', 'YUCAY'),
	('090101', '0901', 'HUANCAVELICA'),
	('090102', '0901', 'ACOBAMBILLA'),
	('090103', '0901', 'ACORIA'),
	('090104', '0901', 'CONAYCA'),
	('090105', '0901', 'CUENCA'),
	('090106', '0901', 'HUACHOCOLPA'),
	('090107', '0901', 'HUAYLLAHUARA'),
	('090108', '0901', 'IZCUCHACA'),
	('090109', '0901', 'LARIA'),
	('090110', '0901', 'MANTA'),
	('090111', '0901', 'MARISCAL CACERES'),
	('090112', '0901', 'MOYA'),
	('090113', '0901', 'NUEVO OCCORO'),
	('090114', '0901', 'PALCA'),
	('090115', '0901', 'PILCHACA'),
	('090116', '0901', 'VILCA'),
	('090117', '0901', 'YAULI'),
	('090118', '0901', 'ASCENSION'),
	('090119', '0901', 'HUANDO'),
	('090201', '0902', 'ACOBAMBA'),
	('090202', '0902', 'ANDABAMBA'),
	('090203', '0902', 'ANTA'),
	('090204', '0902', 'CAJA'),
	('090205', '0902', 'MARCAS'),
	('090206', '0902', 'PAUCARA'),
	('090207', '0902', 'POMACOCHA'),
	('090208', '0902', 'ROSARIO'),
	('090301', '0903', 'LIRCAY'),
	('090302', '0903', 'ANCHONGA'),
	('090303', '0903', 'CALLANMARCA'),
	('090304', '0903', 'CCOCHACCASA'),
	('090305', '0903', 'CHINCHO'),
	('090306', '0903', 'CONGALLA'),
	('090307', '0903', 'HUANCA-HUANCA'),
	('090308', '0903', 'HUAYLLAY GRANDE'),
	('090309', '0903', 'JULCAMARCA'),
	('090310', '0903', 'SAN ANTONIO DE ANTAPARCO'),
	('090311', '0903', 'SANTO TOMAS DE PATA'),
	('090312', '0903', 'SECCLLA'),
	('090401', '0904', 'CASTROVIRREYNA'),
	('090402', '0904', 'ARMA'),
	('090403', '0904', 'AURAHUA'),
	('090404', '0904', 'CAPILLAS'),
	('090405', '0904', 'CHUPAMARCA'),
	('090406', '0904', 'COCAS'),
	('090407', '0904', 'HUACHOS'),
	('090408', '0904', 'HUAMATAMBO'),
	('090409', '0904', 'MOLLEPAMPA'),
	('090410', '0904', 'SAN JUAN'),
	('090411', '0904', 'SANTA ANA'),
	('090412', '0904', 'TANTARA'),
	('090413', '0904', 'TICRAPO'),
	('090501', '0905', 'CHURCAMPA'),
	('090502', '0905', 'ANCO'),
	('090503', '0905', 'CHINCHIHUASI'),
	('090504', '0905', 'EL CARMEN'),
	('090505', '0905', 'LA MERCED'),
	('090506', '0905', 'LOCROJA'),
	('090507', '0905', 'PAUCARBAMBA'),
	('090508', '0905', 'SAN MIGUEL DE MAYOCC'),
	('090509', '0905', 'SAN PEDRO DE CORIS'),
	('090510', '0905', 'PACHAMARCA'),
	('090601', '0906', 'HUAYTARA'),
	('090602', '0906', 'AYAVI'),
	('090603', '0906', 'CORDOVA'),
	('090604', '0906', 'HUAYACUNDO ARMA'),
	('090605', '0906', 'LARAMARCA'),
	('090606', '0906', 'OCOYO'),
	('090607', '0906', 'PILPICHACA'),
	('090608', '0906', 'QUERCO'),
	('090609', '0906', 'QUITO-ARMA'),
	('090610', '0906', 'SAN ANTONIO DE CUSICANCHA'),
	('090611', '0906', 'SAN FRANCISCO DE SANGAYAICO'),
	('090612', '0906', 'SAN ISIDRO'),
	('090613', '0906', 'SANTIAGO DE CHOCORVOS'),
	('090614', '0906', 'SANTIAGO DE QUIRAHUARA'),
	('090615', '0906', 'SANTO DOMINGO DE CAPILLAS'),
	('090616', '0906', 'TAMBO'),
	('090701', '0907', 'PAMPAS'),
	('090702', '0907', 'ACOSTAMBO'),
	('090703', '0907', 'ACRAQUIA'),
	('090704', '0907', 'AHUAYCHA'),
	('090705', '0907', 'COLCABAMBA'),
	('090706', '0907', 'DANIEL HERNANDEZ'),
	('090707', '0907', 'HUACHOCOLPA'),
	('090709', '0907', 'HUARIBAMBA'),
	('090710', '0907', 'ÑAHUIMPUQUIO'),
	('090711', '0907', 'PAZOS'),
	('090713', '0907', 'QUISHUAR'),
	('090714', '0907', 'SALCABAMBA'),
	('090715', '0907', 'SALCAHUASI'),
	('090716', '0907', 'SAN MARCOS DE ROCCHAC'),
	('090717', '0907', 'SURCUBAMBA'),
	('090718', '0907', 'TINTAY PUNCU'),
	('100101', '1001', 'HUANUCO'),
	('100102', '1001', 'AMARILIS'),
	('100103', '1001', 'CHINCHAO'),
	('100104', '1001', 'CHURUBAMBA'),
	('100105', '1001', 'MARGOS'),
	('100106', '1001', 'QUISQUI'),
	('100107', '1001', 'SAN FRANCISCO DE CAYRAN'),
	('100108', '1001', 'SAN PEDRO DE CHAULAN'),
	('100109', '1001', 'SANTA MARIA DEL VALLE'),
	('100110', '1001', 'YARUMAYO'),
	('100111', '1001', 'PILLCO MARCA'),
	('100201', '1002', 'AMBO'),
	('100202', '1002', 'CAYNA'),
	('100203', '1002', 'COLPAS'),
	('100204', '1002', 'CONCHAMARCA'),
	('100205', '1002', 'HUACAR'),
	('100206', '1002', 'SAN FRANCISCO'),
	('100207', '1002', 'SAN RAFAEL'),
	('100208', '1002', 'TOMAY KICHWA'),
	('100301', '1003', 'LA UNION'),
	('100307', '1003', 'CHUQUIS'),
	('100311', '1003', 'MARIAS'),
	('100313', '1003', 'PACHAS'),
	('100316', '1003', 'QUIVILLA'),
	('100317', '1003', 'RIPAN'),
	('100321', '1003', 'SHUNQUI'),
	('100322', '1003', 'SILLAPATA'),
	('100323', '1003', 'YANAS'),
	('100401', '1004', 'HUACAYBAMBA'),
	('100402', '1004', 'CANCHABAMBA'),
	('100403', '1004', 'COCHABAMBA'),
	('100404', '1004', 'PINRA'),
	('100501', '1005', 'LLATA'),
	('100502', '1005', 'ARANCAY'),
	('100503', '1005', 'CHAVIN DE PARIARCA'),
	('100504', '1005', 'JACAS GRANDE'),
	('100505', '1005', 'JIRCAN'),
	('100506', '1005', 'MIRAFLORES'),
	('100507', '1005', 'MONZON'),
	('100508', '1005', 'PUNCHAO'),
	('100509', '1005', 'PUÑOS'),
	('100510', '1005', 'SINGA'),
	('100511', '1005', 'TANTAMAYO'),
	('100601', '1006', 'RUPA-RUPA'),
	('100602', '1006', 'DANIEL ALOMIAS ROBLES'),
	('100603', '1006', 'HERMILIO VALDIZAN'),
	('100604', '1006', 'JOSE CRESPO Y CASTILLO'),
	('100605', '1006', 'LUYANDO'),
	('100606', '1006', 'MARIANO DAMASO BERAUN'),
	('100701', '1007', 'HUACRACHUCO'),
	('100702', '1007', 'CHOLON'),
	('100703', '1007', 'SAN BUENAVENTURA'),
	('100801', '1008', 'PANAO'),
	('100802', '1008', 'CHAGLLA'),
	('100803', '1008', 'MOLINO'),
	('100804', '1008', 'UMARI'),
	('100901', '1009', 'PUERTO INCA'),
	('100902', '1009', 'CODO DEL POZUZO'),
	('100903', '1009', 'HONORIA'),
	('100904', '1009', 'TOURNAVISTA'),
	('100905', '1009', 'YUYAPICHIS'),
	('101001', '1010', 'JESUS'),
	('101002', '1010', 'BAÑOS'),
	('101003', '1010', 'JIVIA'),
	('101004', '1010', 'QUEROPALCA'),
	('101005', '1010', 'RONDOS'),
	('101006', '1010', 'SAN FRANCISCO DE ASIS'),
	('101007', '1010', 'SAN MIGUEL DE CAURI'),
	('101101', '1011', 'CHAVINILLO'),
	('101102', '1011', 'CAHUAC'),
	('101103', '1011', 'CHACABAMBA'),
	('101104', '1011', 'APARICIO POMARES'),
	('101105', '1011', 'JACAS CHICO'),
	('101106', '1011', 'OBAS'),
	('101107', '1011', 'PAMPAMARCA'),
	('101108', '1011', 'CHORAS'),
	('110101', '1101', 'ICA'),
	('110102', '1101', 'LA TINGUIÑA'),
	('110103', '1101', 'LOS AQUIJES'),
	('110104', '1101', 'OCUCAJE'),
	('110105', '1101', 'PACHACUTEC'),
	('110106', '1101', 'PARCONA'),
	('110107', '1101', 'PUEBLO NUEVO'),
	('110108', '1101', 'SALAS'),
	('110109', '1101', 'SAN JOSE DE LOS MOLINOS'),
	('110110', '1101', 'SAN JUAN BAUTISTA'),
	('110111', '1101', 'SANTIAGO'),
	('110112', '1101', 'SUBTANJALLA'),
	('110113', '1101', 'TATE'),
	('110114', '1101', 'YAUCA DEL ROSARIO'),
	('110201', '1102', 'CHINCHA ALTA'),
	('110202', '1102', 'ALTO LARAN'),
	('110203', '1102', 'CHAVIN'),
	('110204', '1102', 'CHINCHA BAJA'),
	('110205', '1102', 'EL CARMEN'),
	('110206', '1102', 'GROCIO PRADO'),
	('110207', '1102', 'PUEBLO NUEVO'),
	('110208', '1102', 'SAN JUAN DE YANAC'),
	('110209', '1102', 'SAN PEDRO DE HUACARPANA'),
	('110210', '1102', 'SUNAMPE'),
	('110211', '1102', 'TAMBO DE MORA'),
	('110301', '1103', 'NAZCA'),
	('110302', '1103', 'CHANGUILLO'),
	('110303', '1103', 'EL INGENIO'),
	('110304', '1103', 'MARCONA'),
	('110305', '1103', 'VISTA ALEGRE'),
	('110401', '1104', 'PALPA'),
	('110402', '1104', 'LLIPATA'),
	('110403', '1104', 'RIO GRANDE'),
	('110404', '1104', 'SANTA CRUZ'),
	('110405', '1104', 'TIBILLO'),
	('110501', '1105', 'PISCO'),
	('110502', '1105', 'HUANCANO'),
	('110503', '1105', 'HUMAY'),
	('110504', '1105', 'INDEPENDENCIA'),
	('110505', '1105', 'PARACAS'),
	('110506', '1105', 'SAN ANDRES'),
	('110507', '1105', 'SAN CLEMENTE'),
	('110508', '1105', 'TUPAC AMARU INCA'),
	('120101', '1201', 'HUANCAYO'),
	('120104', '1201', 'CARHUACALLANGA'),
	('120105', '1201', 'CHACAPAMPA'),
	('120106', '1201', 'CHICCHE'),
	('120107', '1201', 'CHILCA'),
	('120108', '1201', 'CHONGOS ALTO'),
	('120111', '1201', 'CHUPURO'),
	('120112', '1201', 'COLCA'),
	('120113', '1201', 'CULLHUAS'),
	('120114', '1201', 'EL TAMBO'),
	('120116', '1201', 'HUACRAPUQUIO'),
	('120117', '1201', 'HUALHUAS'),
	('120119', '1201', 'HUANCAN'),
	('120120', '1201', 'HUASICANCHA'),
	('120121', '1201', 'HUAYUCACHI'),
	('120122', '1201', 'INGENIO'),
	('120124', '1201', 'PARIAHUANCA'),
	('120125', '1201', 'PILCOMAYO'),
	('120126', '1201', 'PUCARA'),
	('120127', '1201', 'QUICHUAY'),
	('120128', '1201', 'QUILCAS'),
	('120129', '1201', 'SAN AGUSTIN'),
	('120130', '1201', 'SAN JERONIMO DE TUNAN'),
	('120132', '1201', 'SAÑO'),
	('120133', '1201', 'SAPALLANGA'),
	('120134', '1201', 'SICAYA'),
	('120135', '1201', 'SANTO DOMINGO DE ACOBAMBA'),
	('120136', '1201', 'VIQUES'),
	('120201', '1202', 'CONCEPCION'),
	('120202', '1202', 'ACO'),
	('120203', '1202', 'ANDAMARCA'),
	('120204', '1202', 'CHAMBARA'),
	('120205', '1202', 'COCHAS'),
	('120206', '1202', 'COMAS'),
	('120207', '1202', 'HEROINAS TOLEDO'),
	('120208', '1202', 'MANZANARES'),
	('120209', '1202', 'MARISCAL CASTILLA'),
	('120210', '1202', 'MATAHUASI'),
	('120211', '1202', 'MITO'),
	('120212', '1202', 'NUEVE DE JULIO'),
	('120213', '1202', 'ORCOTUNA'),
	('120214', '1202', 'SAN JOSE DE QUERO'),
	('120215', '1202', 'SANTA ROSA DE OCOPA'),
	('120301', '1203', 'CHANCHAMAYO'),
	('120302', '1203', 'PERENE'),
	('120303', '1203', 'PICHANAQUI'),
	('120304', '1203', 'SAN LUIS DE SHUARO'),
	('120305', '1203', 'SAN RAMON'),
	('120306', '1203', 'VITOC'),
	('120401', '1204', 'JAUJA'),
	('120402', '1204', 'ACOLLA'),
	('120403', '1204', 'APATA'),
	('120404', '1204', 'ATAURA'),
	('120405', '1204', 'CANCHAYLLO'),
	('120406', '1204', 'CURICACA'),
	('120407', '1204', 'EL MANTARO'),
	('120408', '1204', 'HUAMALI'),
	('120409', '1204', 'HUARIPAMPA'),
	('120410', '1204', 'HUERTAS'),
	('120411', '1204', 'JANJAILLO'),
	('120412', '1204', 'JULCAN'),
	('120413', '1204', 'LEONOR ORDOÑEZ'),
	('120414', '1204', 'LLOCLLAPAMPA'),
	('120415', '1204', 'MARCO'),
	('120416', '1204', 'MASMA'),
	('120417', '1204', 'MASMA CHICCHE'),
	('120418', '1204', 'MOLINOS'),
	('120419', '1204', 'MONOBAMBA'),
	('120420', '1204', 'MUQUI'),
	('120421', '1204', 'MUQUIYAUYO'),
	('120422', '1204', 'PACA'),
	('120423', '1204', 'PACCHA'),
	('120424', '1204', 'PANCAN'),
	('120425', '1204', 'PARCO'),
	('120426', '1204', 'POMACANCHA'),
	('120427', '1204', 'RICRAN'),
	('120428', '1204', 'SAN LORENZO'),
	('120429', '1204', 'SAN PEDRO DE CHUNAN'),
	('120430', '1204', 'SAUSA'),
	('120431', '1204', 'SINCOS'),
	('120432', '1204', 'TUNAN MARCA'),
	('120433', '1204', 'YAULI'),
	('120434', '1204', 'YAUYOS'),
	('120501', '1205', 'JUNIN'),
	('120502', '1205', 'CARHUAMAYO'),
	('120503', '1205', 'ONDORES'),
	('120504', '1205', 'ULCUMAYO'),
	('120601', '1206', 'SATIPO'),
	('120602', '1206', 'COVIRIALI'),
	('120603', '1206', 'LLAYLLA'),
	('120604', '1206', 'MAZAMARI'),
	('120605', '1206', 'PAMPA HERMOSA'),
	('120606', '1206', 'PANGOA'),
	('120607', '1206', 'RIO NEGRO'),
	('120608', '1206', 'RIO TAMBO'),
	('120701', '1207', 'TARMA'),
	('120702', '1207', 'ACOBAMBA'),
	('120703', '1207', 'HUARICOLCA'),
	('120704', '1207', 'HUASAHUASI'),
	('120705', '1207', 'LA UNION'),
	('120706', '1207', 'PALCA'),
	('120707', '1207', 'PALCAMAYO'),
	('120708', '1207', 'SAN PEDRO DE CAJAS'),
	('120709', '1207', 'TAPO'),
	('120801', '1208', 'LA OROYA'),
	('120802', '1208', 'CHACAPALPA'),
	('120803', '1208', 'HUAY-HUAY'),
	('120804', '1208', 'MARCAPOMACOCHA'),
	('120805', '1208', 'MOROCOCHA'),
	('120806', '1208', 'PACCHA'),
	('120807', '1208', 'SANTA BARBARA DE CARHUACAYAN'),
	('120808', '1208', 'SANTA ROSA DE SACCO'),
	('120809', '1208', 'SUITUCANCHA'),
	('120810', '1208', 'YAULI'),
	('120901', '1209', 'CHUPACA'),
	('120902', '1209', 'AHUAC'),
	('120903', '1209', 'CHONGOS BAJO'),
	('120904', '1209', 'HUACHAC'),
	('120905', '1209', 'HUAMANCACA CHICO'),
	('120906', '1209', 'SAN JUAN DE YSCOS'),
	('120907', '1209', 'SAN JUAN DE JARPA'),
	('120908', '1209', 'TRES DE DICIEMBRE'),
	('120909', '1209', 'YANACANCHA'),
	('130101', '1301', 'TRUJILLO'),
	('130102', '1301', 'EL PORVENIR'),
	('130103', '1301', 'FLORENCIA DE MORA'),
	('130104', '1301', 'HUANCHACO'),
	('130105', '1301', 'LA ESPERANZA'),
	('130106', '1301', 'LAREDO'),
	('130107', '1301', 'MOCHE'),
	('130108', '1301', 'POROTO'),
	('130109', '1301', 'SALAVERRY'),
	('130110', '1301', 'SIMBAL'),
	('130111', '1301', 'VICTOR LARCO HERRERA'),
	('130201', '1302', 'ASCOPE'),
	('130202', '1302', 'CHICAMA'),
	('130203', '1302', 'CHOCOPE'),
	('130204', '1302', 'MAGDALENA DE CAO'),
	('130205', '1302', 'PAIJAN'),
	('130206', '1302', 'RAZURI'),
	('130207', '1302', 'SANTIAGO DE CAO'),
	('130208', '1302', 'CASA GRANDE'),
	('130301', '1303', 'BOLIVAR'),
	('130302', '1303', 'BAMBAMARCA'),
	('130303', '1303', 'CONDORMARCA'),
	('130304', '1303', 'LONGOTEA'),
	('130305', '1303', 'UCHUMARCA'),
	('130306', '1303', 'UCUNCHA'),
	('130401', '1304', 'CHEPEN'),
	('130402', '1304', 'PACANGA'),
	('130403', '1304', 'PUEBLO NUEVO'),
	('130501', '1305', 'JULCAN'),
	('130502', '1305', 'CALAMARCA'),
	('130503', '1305', 'CARABAMBA'),
	('130504', '1305', 'HUASO'),
	('130601', '1306', 'OTUZCO'),
	('130602', '1306', 'AGALLPAMPA'),
	('130604', '1306', 'CHARAT'),
	('130605', '1306', 'HUARANCHAL'),
	('130606', '1306', 'LA CUESTA'),
	('130608', '1306', 'MACHE'),
	('130610', '1306', 'PARANDAY'),
	('130611', '1306', 'SALPO'),
	('130613', '1306', 'SINSICAP'),
	('130614', '1306', 'USQUIL'),
	('130701', '1307', 'SAN PEDRO DE LLOC'),
	('130702', '1307', 'GUADALUPE'),
	('130703', '1307', 'JEQUETEPEQUE'),
	('130704', '1307', 'PACASMAYO'),
	('130705', '1307', 'SAN JOSE'),
	('130801', '1308', 'TAYABAMBA'),
	('130802', '1308', 'BULDIBUYO'),
	('130803', '1308', 'CHILLIA'),
	('130804', '1308', 'HUANCASPATA'),
	('130805', '1308', 'HUAYLILLAS'),
	('130806', '1308', 'HUAYO'),
	('130807', '1308', 'ONGON'),
	('130808', '1308', 'PARCOY'),
	('130809', '1308', 'PATAZ'),
	('130810', '1308', 'PIAS'),
	('130811', '1308', 'SANTIAGO DE CHALLAS'),
	('130812', '1308', 'TAURIJA'),
	('130813', '1308', 'URPAY'),
	('130901', '1309', 'HUAMACHUCO'),
	('130902', '1309', 'CHUGAY'),
	('130903', '1309', 'COCHORCO'),
	('130904', '1309', 'CURGOS'),
	('130905', '1309', 'MARCABAL'),
	('130906', '1309', 'SANAGORAN'),
	('130907', '1309', 'SARIN'),
	('130908', '1309', 'SARTIMBAMBA'),
	('131001', '1310', 'SANTIAGO DE CHUCO'),
	('131002', '1310', 'ANGASMARCA'),
	('131003', '1310', 'CACHICADAN'),
	('131004', '1310', 'MOLLEBAMBA'),
	('131005', '1310', 'MOLLEPATA'),
	('131006', '1310', 'QUIRUVILCA'),
	('131007', '1310', 'SANTA CRUZ DE CHUCA'),
	('131008', '1310', 'SITABAMBA'),
	('131101', '1311', 'CASCAS'),
	('131102', '1311', 'LUCMA'),
	('131103', '1311', 'COMPIN'),
	('131104', '1311', 'SAYAPULLO'),
	('131201', '1312', 'VIRU'),
	('131202', '1312', 'CHAO'),
	('131203', '1312', 'GUADALUPITO'),
	('140101', '1401', 'CHICLAYO'),
	('140102', '1401', 'CHONGOYAPE'),
	('140103', '1401', 'ETEN'),
	('140104', '1401', 'ETEN PUERTO'),
	('140105', '1401', 'JOSE LEONARDO ORTIZ'),
	('140106', '1401', 'LA VICTORIA'),
	('140107', '1401', 'LAGUNAS'),
	('140108', '1401', 'MONSEFU'),
	('140109', '1401', 'NUEVA ARICA'),
	('140110', '1401', 'OYOTUN'),
	('140111', '1401', 'PICSI'),
	('140112', '1401', 'PIMENTEL'),
	('140113', '1401', 'REQUE'),
	('140114', '1401', 'SANTA ROSA'),
	('140115', '1401', 'SAÑA'),
	('140116', '1401', 'CAYALTI'),
	('140117', '1401', 'PATAPO'),
	('140118', '1401', 'POMALCA'),
	('140119', '1401', 'PUCALA'),
	('140120', '1401', 'TUMAN'),
	('140201', '1402', 'FERREÑAFE'),
	('140202', '1402', 'CAÑARIS'),
	('140203', '1402', 'INCAHUASI'),
	('140204', '1402', 'MANUEL ANTONIO MESONES MURO'),
	('140205', '1402', 'PITIPO'),
	('140206', '1402', 'PUEBLO NUEVO'),
	('140301', '1403', 'LAMBAYEQUE'),
	('140302', '1403', 'CHOCHOPE'),
	('140303', '1403', 'ILLIMO'),
	('140304', '1403', 'JAYANCA'),
	('140305', '1403', 'MOCHUMI'),
	('140306', '1403', 'MORROPE'),
	('140307', '1403', 'MOTUPE'),
	('140308', '1403', 'OLMOS'),
	('140309', '1403', 'PACORA'),
	('140310', '1403', 'SALAS'),
	('140311', '1403', 'SAN JOSE'),
	('140312', '1403', 'TUCUME'),
	('150101', '1501', 'LIMA'),
	('150102', '1501', 'ANCON'),
	('150103', '1501', 'ATE'),
	('150104', '1501', 'BARRANCO'),
	('150105', '1501', 'BREÑA'),
	('150106', '1501', 'CARABAYLLO'),
	('150107', '1501', 'CHACLACAYO'),
	('150108', '1501', 'CHORRILLOS'),
	('150109', '1501', 'CIENEGUILLA'),
	('150110', '1501', 'COMAS'),
	('150111', '1501', 'EL AGUSTINO'),
	('150112', '1501', 'INDEPENDENCIA'),
	('150113', '1501', 'JESUS MARIA'),
	('150114', '1501', 'LA MOLINA'),
	('150115', '1501', 'LA VICTORIA'),
	('150116', '1501', 'LINCE'),
	('150117', '1501', 'LOS OLIVOS'),
	('150118', '1501', 'LURIGANCHO'),
	('150119', '1501', 'LURIN'),
	('150120', '1501', 'MAGDALENA DEL MAR'),
	('150121', '1501', 'MAGDALENA VIEJA'),
	('150122', '1501', 'MIRAFLORES'),
	('150123', '1501', 'PACHACAMAC'),
	('150124', '1501', 'PUCUSANA'),
	('150125', '1501', 'PUENTE PIEDRA'),
	('150126', '1501', 'PUNTA HERMOSA'),
	('150127', '1501', 'PUNTA NEGRA'),
	('150128', '1501', 'RIMAC'),
	('150129', '1501', 'SAN BARTOLO'),
	('150130', '1501', 'SAN BORJA'),
	('150131', '1501', 'SAN ISIDRO'),
	('150132', '1501', 'SAN JUAN DE LURIGANCHO'),
	('150133', '1501', 'SAN JUAN DE MIRAFLORES'),
	('150134', '1501', 'SAN LUIS'),
	('150135', '1501', 'SAN MARTIN DE PORRES'),
	('150136', '1501', 'SAN MIGUEL'),
	('150137', '1501', 'SANTA ANITA'),
	('150138', '1501', 'SANTA MARIA DEL MAR'),
	('150139', '1501', 'SANTA ROSA'),
	('150140', '1501', 'SANTIAGO DE SURCO'),
	('150141', '1501', 'SURQUILLO'),
	('150142', '1501', 'VILLA EL SALVADOR'),
	('150143', '1501', 'VILLA MARIA DEL TRIUNFO'),
	('150201', '1502', 'BARRANCA'),
	('150202', '1502', 'PARAMONGA'),
	('150203', '1502', 'PATIVILCA'),
	('150204', '1502', 'SUPE'),
	('150205', '1502', 'SUPE PUERTO'),
	('150301', '1503', 'CAJATAMBO'),
	('150302', '1503', 'COPA'),
	('150303', '1503', 'GORGOR'),
	('150304', '1503', 'HUANCAPON'),
	('150305', '1503', 'MANAS'),
	('150401', '1504', 'CANTA'),
	('150402', '1504', 'ARAHUAY'),
	('150403', '1504', 'HUAMANTANGA'),
	('150404', '1504', 'HUAROS'),
	('150405', '1504', 'LACHAQUI'),
	('150406', '1504', 'SAN BUENAVENTURA'),
	('150407', '1504', 'SANTA ROSA DE QUIVES'),
	('150501', '1505', 'SAN VICENTE DE CAÑETE'),
	('150502', '1505', 'ASIA'),
	('150503', '1505', 'CALANGO'),
	('150504', '1505', 'CERRO AZUL'),
	('150505', '1505', 'CHILCA'),
	('150506', '1505', 'COAYLLO'),
	('150507', '1505', 'IMPERIAL'),
	('150508', '1505', 'LUNAHUANA'),
	('150509', '1505', 'MALA'),
	('150510', '1505', 'NUEVO IMPERIAL'),
	('150511', '1505', 'PACARAN'),
	('150512', '1505', 'QUILMANA'),
	('150513', '1505', 'SAN ANTONIO'),
	('150514', '1505', 'SAN LUIS'),
	('150515', '1505', 'SANTA CRUZ DE FLORES'),
	('150516', '1505', 'ZUÑIGA'),
	('150601', '1506', 'HUARAL'),
	('150602', '1506', 'ATAVILLOS ALTO'),
	('150603', '1506', 'ATAVILLOS BAJO'),
	('150604', '1506', 'AUCALLAMA'),
	('150605', '1506', 'CHANCAY'),
	('150606', '1506', 'IHUARI'),
	('150607', '1506', 'LAMPIAN'),
	('150608', '1506', 'PACARAOS'),
	('150609', '1506', 'SAN MIGUEL DE ACOS'),
	('150610', '1506', 'SANTA CRUZ DE ANDAMARCA'),
	('150611', '1506', 'SUMBILCA'),
	('150612', '1506', 'VEINTISIETE DE NOVIEMBRE'),
	('150701', '1507', 'MATUCANA'),
	('150702', '1507', 'ANTIOQUIA'),
	('150703', '1507', 'CALLAHUANCA'),
	('150704', '1507', 'CARAMPOMA'),
	('150705', '1507', 'CHICLA'),
	('150706', '1507', 'CUENCA'),
	('150707', '1507', 'HUACHUPAMPA'),
	('150708', '1507', 'HUANZA'),
	('150709', '1507', 'HUAROCHIRI'),
	('150710', '1507', 'LAHUAYTAMBO'),
	('150711', '1507', 'LANGA'),
	('150712', '1507', 'LARAOS'),
	('150713', '1507', 'MARIATANA'),
	('150714', '1507', 'RICARDO PALMA'),
	('150715', '1507', 'SAN ANDRES DE TUPICOCHA'),
	('150716', '1507', 'SAN ANTONIO'),
	('150717', '1507', 'SAN BARTOLOME'),
	('150718', '1507', 'SAN DAMIAN'),
	('150719', '1507', 'SAN JUAN DE IRIS'),
	('150720', '1507', 'SAN JUAN DE TANTARANCHE'),
	('150721', '1507', 'SAN LORENZO DE QUINTI'),
	('150722', '1507', 'SAN MATEO'),
	('150723', '1507', 'SAN MATEO DE OTAO'),
	('150724', '1507', 'SAN PEDRO DE CASTA'),
	('150725', '1507', 'SAN PEDRO DE HUANCAYRE'),
	('150726', '1507', 'SANGALLAYA'),
	('150727', '1507', 'SANTA CRUZ DE COCACHACRA'),
	('150728', '1507', 'SANTA EULALIA'),
	('150729', '1507', 'SANTIAGO DE ANCHUCAYA'),
	('150730', '1507', 'SANTIAGO DE TUNA'),
	('150731', '1507', 'SANTO DOMINGO DE LOS OLLEROS'),
	('150732', '1507', 'SURCO'),
	('150801', '1508', 'HUACHO'),
	('150802', '1508', 'AMBAR'),
	('150803', '1508', 'CALETA DE CARQUIN'),
	('150804', '1508', 'CHECRAS'),
	('150805', '1508', 'HUALMAY'),
	('150806', '1508', 'HUAURA'),
	('150807', '1508', 'LEONCIO PRADO'),
	('150808', '1508', 'PACCHO'),
	('150809', '1508', 'SANTA LEONOR'),
	('150810', '1508', 'SANTA MARIA'),
	('150811', '1508', 'SAYAN'),
	('150812', '1508', 'VEGUETA'),
	('150901', '1509', 'OYON'),
	('150902', '1509', 'ANDAJES'),
	('150903', '1509', 'CAUJUL'),
	('150904', '1509', 'COCHAMARCA'),
	('150905', '1509', 'NAVAN'),
	('150906', '1509', 'PACHANGARA'),
	('151001', '1510', 'YAUYOS'),
	('151002', '1510', 'ALIS'),
	('151003', '1510', 'AYAUCA'),
	('151004', '1510', 'AYAVIRI'),
	('151005', '1510', 'AZANGARO'),
	('151006', '1510', 'CACRA'),
	('151007', '1510', 'CARANIA'),
	('151008', '1510', 'CATAHUASI'),
	('151009', '1510', 'CHOCOS'),
	('151010', '1510', 'COCHAS'),
	('151011', '1510', 'COLONIA'),
	('151012', '1510', 'HONGOS'),
	('151013', '1510', 'HUAMPARA'),
	('151014', '1510', 'HUANCAYA'),
	('151015', '1510', 'HUANGASCAR'),
	('151016', '1510', 'HUANTAN'),
	('151017', '1510', 'HUAÑEC'),
	('151018', '1510', 'LARAOS'),
	('151019', '1510', 'LINCHA'),
	('151020', '1510', 'MADEAN'),
	('151021', '1510', 'MIRAFLORES'),
	('151022', '1510', 'OMAS'),
	('151023', '1510', 'PUTINZA'),
	('151024', '1510', 'QUINCHES'),
	('151025', '1510', 'QUINOCAY'),
	('151026', '1510', 'SAN JOAQUIN'),
	('151027', '1510', 'SAN PEDRO DE PILAS'),
	('151028', '1510', 'TANTA'),
	('151029', '1510', 'TAURIPAMPA'),
	('151030', '1510', 'TOMAS'),
	('151031', '1510', 'TUPE'),
	('151032', '1510', 'VIÑAC'),
	('151033', '1510', 'VITIS'),
	('160101', '1601', 'IQUITOS'),
	('160102', '1601', 'ALTO NANAY'),
	('160103', '1601', 'FERNANDO LORES'),
	('160104', '1601', 'INDIANA'),
	('160105', '1601', 'LAS AMAZONAS'),
	('160106', '1601', 'MAZAN'),
	('160107', '1601', 'NAPO'),
	('160108', '1601', 'PUNCHANA'),
	('160109', '1601', 'PUTUMAYO'),
	('160110', '1601', 'TORRES CAUSANA'),
	('160112', '1601', 'BELEN'),
	('160113', '1601', 'SAN JUAN BAUTISTA'),
	('160114', '1601', 'TENIENTE MANUEL CLAVERO'),
	('160201', '1602', 'YURIMAGUAS'),
	('160202', '1602', 'BALSAPUERTO'),
	('160205', '1602', 'JEBEROS'),
	('160206', '1602', 'LAGUNAS'),
	('160210', '1602', 'SANTA CRUZ'),
	('160211', '1602', 'TENIENTE CESAR LOPEZ ROJAS'),
	('160301', '1603', 'NAUTA'),
	('160302', '1603', 'PARINARI'),
	('160303', '1603', 'TIGRE'),
	('160304', '1603', 'TROMPETEROS'),
	('160305', '1603', 'URARINAS'),
	('160401', '1604', 'RAMON CASTILLA'),
	('160402', '1604', 'PEBAS'),
	('160403', '1604', 'YAVARI'),
	('160404', '1604', 'SAN PABLO'),
	('160501', '1605', 'REQUENA'),
	('160502', '1605', 'ALTO TAPICHE'),
	('160503', '1605', 'CAPELO'),
	('160504', '1605', 'EMILIO SAN MARTIN'),
	('160505', '1605', 'MAQUIA'),
	('160506', '1605', 'PUINAHUA'),
	('160507', '1605', 'SAQUENA'),
	('160508', '1605', 'SOPLIN'),
	('160509', '1605', 'TAPICHE'),
	('160510', '1605', 'JENARO HERRERA'),
	('160511', '1605', 'YAQUERANA'),
	('160601', '1606', 'CONTAMANA'),
	('160602', '1606', 'INAHUAYA'),
	('160603', '1606', 'PADRE MARQUEZ'),
	('160604', '1606', 'PAMPA HERMOSA'),
	('160605', '1606', 'SARAYACU'),
	('160606', '1606', 'VARGAS GUERRA'),
	('160701', '1607', 'BARRANCA'),
	('160702', '1607', 'CAHUAPANAS'),
	('160703', '1607', 'MANSERICHE'),
	('160704', '1607', 'MORONA'),
	('160705', '1607', 'PASTAZA'),
	('160706', '1607', 'ANDOAS'),
	('170101', '1701', 'TAMBOPATA'),
	('170102', '1701', 'INAMBARI'),
	('170103', '1701', 'LAS PIEDRAS'),
	('170104', '1701', 'LABERINTO'),
	('170201', '1702', 'MANU'),
	('170202', '1702', 'FITZCARRALD'),
	('170203', '1702', 'MADRE DE DIOS'),
	('170204', '1702', 'HUEPETUHE'),
	('170301', '1703', 'IÑAPARI'),
	('170302', '1703', 'IBERIA'),
	('170303', '1703', 'TAHUAMANU'),
	('180101', '1801', 'MOQUEGUA'),
	('180102', '1801', 'CARUMAS'),
	('180103', '1801', 'CUCHUMBAYA'),
	('180104', '1801', 'SAMEGUA'),
	('180105', '1801', 'SAN CRISTOBAL'),
	('180106', '1801', 'TORATA'),
	('180201', '1802', 'OMATE'),
	('180202', '1802', 'CHOJATA'),
	('180203', '1802', 'COALAQUE'),
	('180204', '1802', 'ICHUÑA'),
	('180205', '1802', 'LA CAPILLA'),
	('180206', '1802', 'LLOQUE'),
	('180207', '1802', 'MATALAQUE'),
	('180208', '1802', 'PUQUINA'),
	('180209', '1802', 'QUINISTAQUILLAS'),
	('180210', '1802', 'UBINAS'),
	('180211', '1802', 'YUNGA'),
	('180301', '1803', 'ILO'),
	('180302', '1803', 'EL ALGARROBAL'),
	('180303', '1803', 'PACOCHA'),
	('190101', '1901', 'CHAUPIMARCA'),
	('190102', '1901', 'HUACHON'),
	('190103', '1901', 'HUARIACA'),
	('190104', '1901', 'HUAYLLAY'),
	('190105', '1901', 'NINACACA'),
	('190106', '1901', 'PALLANCHACRA'),
	('190107', '1901', 'PAUCARTAMBO'),
	('190108', '1901', 'SAN FRANCISCO DE ASIS DE YARUSYACAN'),
	('190109', '1901', 'SIMON BOLIVAR'),
	('190110', '1901', 'TICLACAYAN'),
	('190111', '1901', 'TINYAHUARCO'),
	('190112', '1901', 'VICCO'),
	('190113', '1901', 'YANACANCHA'),
	('190201', '1902', 'YANAHUANCA'),
	('190202', '1902', 'CHACAYAN'),
	('190203', '1902', 'GOYLLARISQUIZGA'),
	('190204', '1902', 'PAUCAR'),
	('190205', '1902', 'SAN PEDRO DE PILLAO'),
	('190206', '1902', 'SANTA ANA DE TUSI'),
	('190207', '1902', 'TAPUC'),
	('190208', '1902', 'VILCABAMBA'),
	('190301', '1903', 'OXAPAMPA'),
	('190302', '1903', 'CHONTABAMBA'),
	('190303', '1903', 'HUANCABAMBA'),
	('190304', '1903', 'PALCAZU'),
	('190305', '1903', 'POZUZO'),
	('190306', '1903', 'PUERTO BERMUDEZ'),
	('190307', '1903', 'VILLA RICA'),
	('200101', '2001', 'PIURA'),
	('200104', '2001', 'CASTILLA'),
	('200105', '2001', 'CATACAOS'),
	('200107', '2001', 'CURA MORI'),
	('200108', '2001', 'EL TALLAN'),
	('200109', '2001', 'LA ARENA'),
	('200110', '2001', 'LA UNION'),
	('200111', '2001', 'LAS LOMAS'),
	('200114', '2001', 'TAMBO GRANDE'),
	('200201', '2002', 'AYABACA'),
	('200202', '2002', 'FRIAS'),
	('200203', '2002', 'JILILI'),
	('200204', '2002', 'LAGUNAS'),
	('200205', '2002', 'MONTERO'),
	('200206', '2002', 'PACAIPAMPA'),
	('200207', '2002', 'PAIMAS'),
	('200208', '2002', 'SAPILLICA'),
	('200209', '2002', 'SICCHEZ'),
	('200210', '2002', 'SUYO'),
	('200301', '2003', 'HUANCABAMBA'),
	('200302', '2003', 'CANCHAQUE'),
	('200303', '2003', 'EL CARMEN DE LA FRONTERA'),
	('200304', '2003', 'HUARMACA'),
	('200305', '2003', 'LALAQUIZ'),
	('200306', '2003', 'SAN MIGUEL DE EL FAIQUE'),
	('200307', '2003', 'SONDOR'),
	('200308', '2003', 'SONDORILLO'),
	('200401', '2004', 'CHULUCANAS'),
	('200402', '2004', 'BUENOS AIRES'),
	('200403', '2004', 'CHALACO'),
	('200404', '2004', 'LA MATANZA'),
	('200405', '2004', 'MORROPON'),
	('200406', '2004', 'SALITRAL'),
	('200407', '2004', 'SAN JUAN DE BIGOTE'),
	('200408', '2004', 'SANTA CATALINA DE MOSSA'),
	('200409', '2004', 'SANTO DOMINGO'),
	('200410', '2004', 'YAMANGO'),
	('200501', '2005', 'PAITA'),
	('200502', '2005', 'AMOTAPE'),
	('200503', '2005', 'ARENAL'),
	('200504', '2005', 'COLAN'),
	('200505', '2005', 'LA HUACA'),
	('200506', '2005', 'TAMARINDO'),
	('200507', '2005', 'VICHAYAL'),
	('200601', '2006', 'SULLANA'),
	('200602', '2006', 'BELLAVISTA'),
	('200603', '2006', 'IGNACIO ESCUDERO'),
	('200604', '2006', 'LANCONES'),
	('200605', '2006', 'MARCAVELICA'),
	('200606', '2006', 'MIGUEL CHECA'),
	('200607', '2006', 'QUERECOTILLO'),
	('200608', '2006', 'SALITRAL'),
	('200701', '2007', 'PARIÑAS'),
	('200702', '2007', 'EL ALTO'),
	('200703', '2007', 'LA BREA'),
	('200704', '2007', 'LOBITOS'),
	('200705', '2007', 'LOS ORGANOS'),
	('200706', '2007', 'MANCORA'),
	('200801', '2008', 'SECHURA'),
	('200802', '2008', 'BELLAVISTA DE LA UNION'),
	('200803', '2008', 'BERNAL'),
	('200804', '2008', 'CRISTO NOS VALGA'),
	('200805', '2008', 'VICE'),
	('200806', '2008', 'RINCONADA LLICUAR'),
	('210101', '2101', 'PUNO'),
	('210102', '2101', 'ACORA'),
	('210103', '2101', 'AMANTANI'),
	('210104', '2101', 'ATUNCOLLA'),
	('210105', '2101', 'CAPACHICA'),
	('210106', '2101', 'CHUCUITO'),
	('210107', '2101', 'COATA'),
	('210108', '2101', 'HUATA'),
	('210109', '2101', 'MAÑAZO'),
	('210110', '2101', 'PAUCARCOLLA'),
	('210111', '2101', 'PICHACANI'),
	('210112', '2101', 'PLATERIA'),
	('210113', '2101', 'SAN ANTONIO'),
	('210114', '2101', 'TIQUILLACA'),
	('210115', '2101', 'VILQUE'),
	('210201', '2102', 'AZANGARO'),
	('210202', '2102', 'ACHAYA'),
	('210203', '2102', 'ARAPA'),
	('210204', '2102', 'ASILLO'),
	('210205', '2102', 'CAMINACA'),
	('210206', '2102', 'CHUPA'),
	('210207', '2102', 'JOSE DOMINGO CHOQUEHUANCA'),
	('210208', '2102', 'MUÑANI'),
	('210209', '2102', 'POTONI'),
	('210210', '2102', 'SAMAN'),
	('210211', '2102', 'SAN ANTON'),
	('210212', '2102', 'SAN JOSE'),
	('210213', '2102', 'SAN JUAN DE SALINAS'),
	('210214', '2102', 'SANTIAGO DE PUPUJA'),
	('210215', '2102', 'TIRAPATA'),
	('210301', '2103', 'MACUSANI'),
	('210302', '2103', 'AJOYANI'),
	('210303', '2103', 'AYAPATA'),
	('210304', '2103', 'COASA'),
	('210305', '2103', 'CORANI'),
	('210306', '2103', 'CRUCERO'),
	('210307', '2103', 'ITUATA'),
	('210308', '2103', 'OLLACHEA'),
	('210309', '2103', 'SAN GABAN'),
	('210310', '2103', 'USICAYOS'),
	('210401', '2104', 'JULI'),
	('210402', '2104', 'DESAGUADERO'),
	('210403', '2104', 'HUACULLANI'),
	('210404', '2104', 'KELLUYO'),
	('210405', '2104', 'PISACOMA'),
	('210406', '2104', 'POMATA'),
	('210407', '2104', 'ZEPITA'),
	('210501', '2105', 'ILAVE'),
	('210502', '2105', 'CAPAZO'),
	('210503', '2105', 'PILCUYO'),
	('210504', '2105', 'SANTA ROSA'),
	('210505', '2105', 'CONDURIRI'),
	('210601', '2106', 'HUANCANE'),
	('210602', '2106', 'COJATA'),
	('210603', '2106', 'HUATASANI'),
	('210604', '2106', 'INCHUPALLA'),
	('210605', '2106', 'PUSI'),
	('210606', '2106', 'ROSASPATA'),
	('210607', '2106', 'TARACO'),
	('210608', '2106', 'VILQUE CHICO'),
	('210701', '2107', 'LAMPA'),
	('210702', '2107', 'CABANILLA'),
	('210703', '2107', 'CALAPUJA'),
	('210704', '2107', 'NICASIO'),
	('210705', '2107', 'OCUVIRI'),
	('210706', '2107', 'PALCA'),
	('210707', '2107', 'PARATIA'),
	('210708', '2107', 'PUCARA'),
	('210709', '2107', 'SANTA LUCIA'),
	('210710', '2107', 'VILAVILA'),
	('210801', '2108', 'AYAVIRI'),
	('210802', '2108', 'ANTAUTA'),
	('210803', '2108', 'CUPI'),
	('210804', '2108', 'LLALLI'),
	('210805', '2108', 'MACARI'),
	('210806', '2108', 'NUÑOA'),
	('210807', '2108', 'ORURILLO'),
	('210808', '2108', 'SANTA ROSA'),
	('210809', '2108', 'UMACHIRI'),
	('210901', '2109', 'MOHO'),
	('210902', '2109', 'CONIMA'),
	('210903', '2109', 'HUAYRAPATA'),
	('210904', '2109', 'TILALI'),
	('211001', '2110', 'PUTINA'),
	('211002', '2110', 'ANANEA'),
	('211003', '2110', 'PEDRO VILCA APAZA'),
	('211004', '2110', 'QUILCAPUNCU'),
	('211005', '2110', 'SINA'),
	('211101', '2111', 'JULIACA'),
	('211102', '2111', 'CABANA'),
	('211103', '2111', 'CABANILLAS'),
	('211104', '2111', 'CARACOTO'),
	('211201', '2112', 'SANDIA'),
	('211202', '2112', 'CUYOCUYO'),
	('211203', '2112', 'LIMBANI'),
	('211204', '2112', 'PATAMBUCO'),
	('211205', '2112', 'PHARA'),
	('211206', '2112', 'QUIACA'),
	('211207', '2112', 'SAN JUAN DEL ORO'),
	('211208', '2112', 'YANAHUAYA'),
	('211209', '2112', 'ALTO INAMBARI'),
	('211210', '2112', 'SAN PEDRO DE PUTINA PUNCO'),
	('211301', '2113', 'YUNGUYO'),
	('211302', '2113', 'ANAPIA'),
	('211303', '2113', 'COPANI'),
	('211304', '2113', 'CUTURAPI'),
	('211305', '2113', 'OLLARAYA'),
	('211306', '2113', 'TINICACHI'),
	('211307', '2113', 'UNICACHI'),
	('220101', '2201', 'MOYOBAMBA'),
	('220102', '2201', 'CALZADA'),
	('220103', '2201', 'HABANA'),
	('220104', '2201', 'JEPELACIO'),
	('220105', '2201', 'SORITOR'),
	('220106', '2201', 'YANTALO'),
	('220201', '2202', 'BELLAVISTA'),
	('220202', '2202', 'ALTO BIAVO'),
	('220203', '2202', 'BAJO BIAVO'),
	('220204', '2202', 'HUALLAGA'),
	('220205', '2202', 'SAN PABLO'),
	('220206', '2202', 'SAN RAFAEL'),
	('220301', '2203', 'SAN JOSE DE SISA'),
	('220302', '2203', 'AGUA BLANCA'),
	('220303', '2203', 'SAN MARTIN'),
	('220304', '2203', 'SANTA ROSA'),
	('220305', '2203', 'SHATOJA'),
	('220401', '2204', 'SAPOSOA'),
	('220402', '2204', 'ALTO SAPOSOA'),
	('220403', '2204', 'EL ESLABON'),
	('220404', '2204', 'PISCOYACU'),
	('220405', '2204', 'SACANCHE'),
	('220406', '2204', 'TINGO DE SAPOSOA'),
	('220501', '2205', 'LAMAS'),
	('220502', '2205', 'ALONSO DE ALVARADO'),
	('220503', '2205', 'BARRANQUITA'),
	('220504', '2205', 'CAYNARACHI'),
	('220505', '2205', 'CUÑUMBUQUI'),
	('220506', '2205', 'PINTO RECODO'),
	('220507', '2205', 'RUMISAPA'),
	('220508', '2205', 'SAN ROQUE DE CUMBAZA'),
	('220509', '2205', 'SHANAO'),
	('220510', '2205', 'TABALOSOS'),
	('220511', '2205', 'ZAPATERO'),
	('220601', '2206', 'JUANJUI'),
	('220602', '2206', 'CAMPANILLA'),
	('220603', '2206', 'HUICUNGO'),
	('220604', '2206', 'PACHIZA'),
	('220605', '2206', 'PAJARILLO'),
	('220701', '2207', 'PICOTA'),
	('220702', '2207', 'BUENOS AIRES'),
	('220703', '2207', 'CASPISAPA'),
	('220704', '2207', 'PILLUANA'),
	('220705', '2207', 'PUCACACA'),
	('220706', '2207', 'SAN CRISTOBAL'),
	('220707', '2207', 'SAN HILARION'),
	('220708', '2207', 'SHAMBOYACU'),
	('220709', '2207', 'TINGO DE PONASA'),
	('220710', '2207', 'TRES UNIDOS'),
	('220801', '2208', 'RIOJA'),
	('220802', '2208', 'AWAJUN'),
	('220803', '2208', 'ELIAS SOPLIN VARGAS'),
	('220804', '2208', 'NUEVA CAJAMARCA'),
	('220805', '2208', 'PARDO MIGUEL'),
	('220806', '2208', 'POSIC'),
	('220807', '2208', 'SAN FERNANDO'),
	('220808', '2208', 'YORONGOS'),
	('220809', '2208', 'YURACYACU'),
	('220901', '2209', 'TARAPOTO'),
	('220902', '2209', 'ALBERTO LEVEAU'),
	('220903', '2209', 'CACATACHI'),
	('220904', '2209', 'CHAZUTA'),
	('220905', '2209', 'CHIPURANA'),
	('220906', '2209', 'EL PORVENIR'),
	('220907', '2209', 'HUIMBAYOC'),
	('220908', '2209', 'JUAN GUERRA'),
	('220909', '2209', 'LA BANDA DE SHILCAYO'),
	('220910', '2209', 'MORALES'),
	('220911', '2209', 'PAPAPLAYA'),
	('220912', '2209', 'SAN ANTONIO'),
	('220913', '2209', 'SAUCE'),
	('220914', '2209', 'SHAPAJA'),
	('221001', '2210', 'TOCACHE'),
	('221002', '2210', 'NUEVO PROGRESO'),
	('221003', '2210', 'POLVORA'),
	('221004', '2210', 'SHUNTE'),
	('221005', '2210', 'UCHIZA'),
	('230101', '2301', 'TACNA'),
	('230102', '2301', 'ALTO DE LA ALIANZA'),
	('230103', '2301', 'CALANA'),
	('230104', '2301', 'CIUDAD NUEVA'),
	('230105', '2301', 'INCLAN'),
	('230106', '2301', 'PACHIA'),
	('230107', '2301', 'PALCA'),
	('230108', '2301', 'POCOLLAY'),
	('230109', '2301', 'SAMA'),
	('230110', '2301', 'CORONEL GREGORIO ALBARRACIN LANCHIP'),
	('230201', '2302', 'CANDARAVE'),
	('230202', '2302', 'CAIRANI'),
	('230203', '2302', 'CAMILACA'),
	('230204', '2302', 'CURIBAYA'),
	('230205', '2302', 'HUANUARA'),
	('230206', '2302', 'QUILAHUANI'),
	('230301', '2303', 'LOCUMBA'),
	('230302', '2303', 'ILABAYA'),
	('230303', '2303', 'ITE'),
	('230401', '2304', 'TARATA'),
	('230402', '2304', 'HEROES ALBARRACIN'),
	('230403', '2304', 'ESTIQUE'),
	('230404', '2304', 'ESTIQUE-PAMPA'),
	('230405', '2304', 'SITAJARA'),
	('230406', '2304', 'SUSAPAYA'),
	('230407', '2304', 'TARUCACHI'),
	('230408', '2304', 'TICACO'),
	('240101', '2401', 'TUMBES'),
	('240102', '2401', 'CORRALES'),
	('240103', '2401', 'LA CRUZ'),
	('240104', '2401', 'PAMPAS DE HOSPITAL'),
	('240105', '2401', 'SAN JACINTO'),
	('240106', '2401', 'SAN JUAN DE LA VIRGEN'),
	('240201', '2402', 'ZORRITOS'),
	('240202', '2402', 'CASITAS'),
	('240203', '2402', 'CANOAS DE PUNTA SAL'),
	('240301', '2403', 'ZARUMILLA'),
	('240302', '2403', 'AGUAS VERDES'),
	('240303', '2403', 'MATAPALO'),
	('240304', '2403', 'PAPAYAL'),
	('250101', '2501', 'CALLERIA'),
	('250102', '2501', 'CAMPOVERDE'),
	('250103', '2501', 'IPARIA'),
	('250104', '2501', 'MASISEA'),
	('250105', '2501', 'YARINACOCHA'),
	('250106', '2501', 'NUEVA REQUENA'),
	('250107', '2501', 'MANANTAY'),
	('250201', '2502', 'RAYMONDI'),
	('250202', '2502', 'SEPAHUA'),
	('250203', '2502', 'TAHUANIA'),
	('250204', '2502', 'YURUA'),
	('250301', '2503', 'PADRE ABAD'),
	('250302', '2503', 'IRAZOLA'),
	('250303', '2503', 'CURIMANA'),
	('250401', '2504', 'PURUS');
/*!40000 ALTER TABLE `distritos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `empresa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ruc` varchar(11) DEFAULT NULL,
  `nombres` varchar(200) DEFAULT NULL,
  `ncomercial` varchar(100) DEFAULT NULL,
  `producto` tinyint(1) DEFAULT 0,
  `dscto` tinyint(1) DEFAULT 0,
  `igv` decimal(5,2) DEFAULT NULL,
  `logo` text DEFAULT NULL,
  `lticket` text DEFAULT NULL,
  `ticket` int(2) DEFAULT 80,
  `pie` text DEFAULT NULL,
  `time` int(14) DEFAULT NULL,
  `compra` tinyint(1) DEFAULT 0,
  `arqueo` tinyint(1) DEFAULT 0,
  `pventa` tinyint(1) DEFAULT 0,
  `pestablecimiento` tinyint(1) DEFAULT 0,
  `facturacion` tinyint(1) DEFAULT 0,
  `tipo_soap` char(2) DEFAULT NULL,
  `envio_automatico` tinyint(1) DEFAULT 0,
  `usuario_soap` varchar(20) DEFAULT NULL,
  `clave_soap` varchar(20) DEFAULT NULL,
  `certificado` varchar(50) DEFAULT NULL,
  `certificado_clave` varchar(100) DEFAULT NULL,
  `certificado_vence` date DEFAULT NULL,
  `edicion` tinyint(1) DEFAULT 0,
  `id_validador` varchar(200) DEFAULT NULL,
  `secret_validador` varchar(200) DEFAULT NULL,
  `token_validador` longtext DEFAULT NULL,
  `fecha_validador` datetime DEFAULT NULL,
  `expires_validador` int(11) DEFAULT NULL,
  `id_gre` varchar(200) DEFAULT NULL,
  `secret_gre` varchar(200) DEFAULT NULL,
  `token_gre` longtext DEFAULT NULL,
  `fecha_gre` datetime DEFAULT NULL,
  `expires_gre` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `empresa` DISABLE KEYS */;
INSERT INTO `empresa` (`id`, `ruc`, `nombres`, `ncomercial`, `producto`, `dscto`, `igv`, `logo`, `lticket`, `ticket`, `pie`, `time`, `compra`, `arqueo`, `pventa`, `pestablecimiento`, `facturacion`, `tipo_soap`, `envio_automatico`, `usuario_soap`, `clave_soap`, `certificado`, `certificado_clave`, `certificado_vence`, `edicion`, `id_validador`, `secret_validador`, `token_validador`, `fecha_validador`, `expires_validador`, `id_gre`, `secret_gre`, `token_gre`, `fecha_gre`, `expires_gre`) VALUES
	(1, '10757979972', 'AGUILAR RUIZ EVELIN', 'BOTICA MEDIKALFARMA', 0, 1, NULL, 'http://localhost/public/logo/logo_medikalfarma.jpeg', 'http://localhost/public/logo/logo_medikalfarma.jpeg', 80, 'GRACIAS POR SU COMPRA', NULL, 0, 0, 1, 0, 1, '01', 1, '', '', '', '', '2026-08-01', 0, 'cbae1693-6b28-4def-a47f-af3e8a27b7ce', 'DBiKqh5Wi/yJ39a9wkCovg==', 'eyJraWQiOiJhcGkuc3VuYXQuZ29iLnBlLmtpZDEwMSIsInR5cCI6IkpXVCIsImFsZyI6IlJTMjU2In0.eyJzdWIiOiJjYmFlMTY5My02YjI4LTRkZWYtYTQ3Zi1hZjNlOGEyN2I3Y2UiLCJhdWQiOiJbe1wiYXBpXCI6XCJodHRwczpcL1wvYXBpLnN1bmF0LmdvYi5wZVwiLFwicmVjdXJzb1wiOlt7XCJpZFwiOlwiXC92MVwvY29udHJpYnV5ZW50ZVwvY29udHJpYnV5ZW50ZXNcIixcImluZGljYWRvclwiOlwiMFwiLFwiZ3RcIjpcIjAxMDAwMFwifV19XSIsIm5iZiI6MTcyNjUyNzgwNCwiY2xpZW50SWQiOiJjYmFlMTY5My02YjI4LTRkZWYtYTQ3Zi1hZjNlOGEyN2I3Y2UiLCJpc3MiOiJodHRwczpcL1wvYXBpLXNlZ3VyaWRhZC5zdW5hdC5nb2IucGVcL3YxXC9jbGllbnRlc2V4dHJhbmV0XC9jYmFlMTY5My02YjI4LTRkZWYtYTQ3Zi1hZjNlOGEyN2I3Y2VcL29hdXRoMlwvdG9rZW5cLyIsImV4cCI6MTcyNjUzMTQwNCwiZ3JhbnRUeXBlIjoiY2xpZW50X2NyZWRlbnRpYWxzIiwiaWF0IjoxNzI2NTI3ODA0fQ.CPB3DO-FiI5dswFVltGjd6QTqd_bbO6xg7MrzrJ57JDiToZ2iZU_RSvYqtCfTviQK088D3E7RKMnHl7VZ2JifgGWHpAtpfDXLMJbAhEba5KV-q0NtLOekDNEuoeiy22IfQlZ4xU98CA2kd2UocMQtNWl51ToCa_LkgNfQ9M2OAPbcnI9MlVcAWgztt556cd7j2dJj6T3njDgqMzBJJAZMG1ueuX_k1OTmVeTu1_gue_yrKCI8XtxFvqtQWku3B8iuF_9itYruinmHvvIUWTDgZ8kEzb1mEgUrQCkIaIcBTrr8V9bkhULu1K7R0YKyvI2v6qTQYKzSsMxxC4bE_-5xw', '2024-09-16 18:03:24', 3600, NULL, NULL, NULL, NULL, NULL);
/*!40000 ALTER TABLE `empresa` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `establecimientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` char(4) DEFAULT NULL,
  `descripcion` varchar(100) DEFAULT NULL,
  `iddepartamento` char(2) DEFAULT NULL,
  `idprovincia` char(4) DEFAULT NULL,
  `iddistrito` char(6) DEFAULT NULL,
  `direccion` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `telefono` varchar(100) DEFAULT NULL,
  `cdigemid` char(20) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `establecimientos` DISABLE KEYS */;
INSERT INTO `establecimientos` (`id`, `codigo`, `descripcion`, `iddepartamento`, `idprovincia`, `iddistrito`, `direccion`, `email`, `telefono`, `cdigemid`, `fregistro`) VALUES
	(1, '0000', 'LOCAL 1', '10', '1001', '100101', 'JR. HUALLAYCO NRO. 1371 HUANUCO', '', '-', '', '2022-12-30 17:51:22');
/*!40000 ALTER TABLE `establecimientos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `gastos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `comprobante` varchar(5) DEFAULT NULL,
  `numero` varchar(30) DEFAULT NULL,
  `idproveedor` int(11) DEFAULT NULL,
  `proveedor` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `motivo` varchar(200) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `gastos` DISABLE KEYS */;
/*!40000 ALTER TABLE `gastos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `ingresos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `comprobante` varchar(5) DEFAULT NULL,
  `numero` varchar(30) DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `motivo` varchar(200) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `ingresos` DISABLE KEYS */;
/*!40000 ALTER TABLE `ingresos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `inventarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `venta` decimal(10,2) DEFAULT NULL,
  `pventa` decimal(10,2) DEFAULT NULL,
  `pblister` decimal(10,2) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `inventarios` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventarios` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `inventario_inicial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `numero` int(11) NOT NULL,
  `femision` date DEFAULT NULL,
  `idproducto` int(11) NOT NULL,
  `descripcion` varchar(200) NOT NULL,
  `cantidad` double NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  `importe` decimal(10,2) NOT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT 0,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `inventario_inicial` DISABLE KEYS */;
/*!40000 ALTER TABLE `inventario_inicial` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `kardex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `idtmovimiento` int(11) DEFAULT NULL,
  `concepto` varchar(100) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `entradaf` double DEFAULT NULL,
  `salidaf` double DEFAULT NULL,
  `saldof` double NOT NULL,
  `costo` decimal(10,4) DEFAULT NULL,
  `entradav` decimal(10,2) DEFAULT NULL,
  `salidav` decimal(10,2) DEFAULT NULL,
  `saldov` decimal(10,2) DEFAULT NULL,
  `documento` varchar(30) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `laboratorios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `laboratorios` DISABLE KEYS */;
INSERT INTO `laboratorios` (`id`, `descripcion`) VALUES
	(1, 'AC FARMA'),
	(2, 'ALFA'),
	(3, 'ALPHARMA.CO'),
	(4, 'AMERICA S.R.L.'),
	(5, 'ANSOLAT'),
	(6, 'AXON PHARMA'),
	(7, 'OQ PHARMA'),
	(8, 'KNOP'),
	(9, 'BAYER'),
	(10, 'BAGO'),
	(11, 'BIOS'),
	(12, 'B&J BRATON'),
	(13, 'LABORATORIOS DELFARMA S.A.C'),
	(14, 'EUROFARMA'),
	(15, 'FARVET'),
	(16, 'FARMINDUSTRIA'),
	(17, 'GLASOSMITHKLINE'),
	(18, 'DEUTSCHE PHARMA S.A.C.'),
	(19, 'BMC FARMA'),
	(20, 'RG GEDEON RICHTER'),
	(21, 'GENFAR'),
	(22, 'HERSIL S.A'),
	(23, 'IQ FARMA'),
	(24, 'INDUQUIMICA'),
	(25, 'INDUFAR'),
	(26, 'LYAFARM'),
	(27, 'MEDIFARMA'),
	(28, 'PHARMED CORPORATION'),
	(29, 'PHARMAGEN'),
	(30, 'NATURGEN'),
	(31, 'PORTUGAL'),
	(32, 'QUILAB'),
	(33, 'ROXFARMA'),
	(34, 'ROEMMERS'),
	(35, 'SEBAL FARMA '),
	(36, 'SIEGFRIED'),
	(37, 'SANOFI'),
	(38, 'SMART PHARMA'),
	(39, 'INTIPHARMA S.A.C.'),
	(40, 'LABOFAR'),
	(41, 'LUDBER'),
	(42, 'LUXOR PHARMACEUTICAL S.A.C.'),
	(43, 'MEDROCK'),
	(44, 'CONTILAB'),
	(45, 'MARKOS'),
	(46, 'MARFAN'),
	(47, 'MERK'),
	(48, 'VICK'),
	(49, 'GENCOPHARMACEUTICAL'),
	(50, 'CORPORACION CASTILLO S.A.'),
	(51, 'RUTSA'),
	(52, 'PAK FARMA'),
	(53, 'ABF ARIAL PERUBIOFARMACEUTICA S.A.C.'),
	(54, 'LAFRANCOL'),
	(55, 'TEVA'),
	(56, 'VIFARMA E.I.R.L.'),
	(57, 'ALKOFARMA'),
	(58, 'MEDICAL '),
	(59, 'MEDIKIT'),
	(60, 'SIGMA'),
	(61, 'LABORATORIOS ALKOFARMA E.I.R.L.'),
	(62, 'DROGUERIA SIGMA ENTERPRISES PERU S.A.C'),
	(63, 'P&W'),
	(64, 'COLGATE PALMOLIVE'),
	(65, 'HADA S.A'),
	(66, 'JOHNSON & JHONSON DEL PERU S.A.'),
	(67, 'PERUFARMA S.A'),
	(68, 'V.RAVETTINO S.R.L.'),
	(69, 'TUINIES'),
	(70, 'NESTLE'),
	(71, 'KIMBERLY CLARK PERU S.R.L.'),
	(72, 'PRODUCTOS TISSUE DEL PERU S.A.C.'),
	(73, 'PALMYRA S.A.C.'),
	(74, 'DR.ZAIDMAN'),
	(75, 'PRODUCTOS FAMILIA S.A.'),
	(76, 'KIMBERLY CORPAPEL S.A.'),
	(77, 'DISTRIBUIDORA CONTINENTAL 6 S.A.'),
	(78, 'SMIC'),
	(79, 'INVERSIONES ALCIMARS E.I.R.L.'),
	(80, 'FAMILY DOCTOR'),
	(82, 'VITALIS'),
	(83, 'ATRAL'),
	(84, 'DAEWON'),
	(85, 'LUSA'),
	(86, 'DISTRIBUCIONES DANY'),
	(87, 'JPS DISTRIBUCIONES'),
	(88, 'BENDI-C'),
	(89, 'CONSORCIO INDUSTRIAL DE AREQUIPA S.A'),
	(90, 'WIN PERU S.A.C.'),
	(91, 'P&G PROCTER & GAMBLE'),
	(92, 'INDUSTRIAS ALGOTEC S.A'),
	(93, 'NORDIC'),
	(94, 'UNILEVER'),
	(95, 'BRAUN MEDICAL PERU S.A'),
	(96, 'LABORATORIOS SMA S.A.C.'),
	(97, 'YOBEL SUPPLY CHAIN MANAGEMENT S.A'),
	(98, 'COLGATE-PALMOLIVE'),
	(99, 'THAI NIPPON RUBBER INDUSTRY PUBLIC COMPANY LIMITED,'),
	(100, 'APROPO'),
	(101, 'DROKASA PERU S.A.'),
	(102, 'AJEPER SA.'),
	(103, 'EMBOTELLADORA SAN MIGUEL DEL SUR S.A.'),
	(104, 'DROGUERIA IMPORTACIONES SIU S.R.L.'),
	(105, 'IMPORTACIONES FERCAR E.I.R.L'),
	(106, 'DELFIN'),
	(107, 'VOGUE'),
	(108, 'NEOPAN'),
	(109, 'IMPORTACIONES YANG'),
	(110, 'M&D PRODUCTOS GLEAM S.R.L.'),
	(111, 'SCHWARZKOPF & HENKEL'),
	(112, 'LABORATORIO DURANDIN S.A.'),
	(113, 'QUALA PERU S.A.C.'),
	(114, 'GENOMMA LAB INTERNACIONAL'),
	(115, 'SURETEX PROPHYLACTICS'),
	(117, 'INTRAVEN'),
	(118, 'MEDIC '),
	(119, 'BIODES'),
	(120, 'ALKHOFAR'),
	(121, 'FACE MASK'),
	(122, 'SEGURIMAX'),
	(123, 'VENDIBAND'),
	(124, 'APPLE'),
	(125, 'MAYBO'),
	(126, 'LOVE SEX'),
	(127, 'LADY SOFT'),
	(128, 'BABYSEC'),
	(129, 'ASEPXIA'),
	(130, 'FARMAQUIL'),
	(131, 'UNIMED'),
	(132, 'KONZIL'),
	(133, 'PIEL'),
	(134, 'PERT'),
	(135, 'KOLINOS'),
	(136, 'KOLYNOS'),
	(137, 'CYNKAT'),
	(138, 'INTRALAB'),
	(139, 'DOVE'),
	(140, 'STERI-STRIP'),
	(141, 'GRUNENTHAL'),
	(142, 'QM PHARMA'),
	(143, 'CIFARMA'),
	(144, 'PANTENE'),
	(145, 'HEAD SHOULDERS'),
	(146, 'OLD SPICE'),
	(147, 'ORAL-B'),
	(148, 'NOSOTRAS'),
	(149, 'GARDEN HOUSE'),
	(150, 'PROTEX'),
	(151, 'GENTS'),
	(152, 'DUREX'),
	(153, 'EDGEWELL PERSONAL CARE '),
	(154, 'ALGOTEC S.A'),
	(155, 'BRUT'),
	(156, 'SECRET'),
	(157, 'AMMENS'),
	(160, 'SCALA IMPOT E.I.R.L'),
	(161, 'FORESTA'),
	(162, 'FLORESTA'),
	(163, 'SPORADE'),
	(164, 'PLENITUD'),
	(165, 'HUGGIES'),
	(166, 'PONDS'),
	(167, 'PÉTALO'),
	(168, 'BABYLAND'),
	(169, 'FAMILAND'),
	(170, 'GENFAR VIT'),
	(171, 'LANSIER'),
	(172, 'SM'),
	(173, 'ISM'),
	(174, 'ECOFLAR'),
	(175, 'ECOFLAC'),
	(176, 'SANTOLEE'),
	(177, 'BRUSH'),
	(178, 'BEISE'),
	(179, 'DIGESA'),
	(180, 'TOYS '),
	(181, 'LOVELY COLLECTION'),
	(182, 'VOLT'),
	(183, 'BAHIA'),
	(184, 'HANSAPLAST'),
	(185, 'DROPESAC'),
	(186, 'LATAM'),
	(187, 'BRATON'),
	(188, 'PHARMEX'),
	(189, 'LA CAROSITA'),
	(190, 'V.FARMA'),
	(191, 'KOTEX '),
	(192, 'NINET'),
	(193, 'DROGUERIA DANY'),
	(194, 'VITALINE'),
	(195, 'DISTRIB MILAGRITOS'),
	(196, 'EGO'),
	(197, 'SAYSON'),
	(198, 'DISTRIB. CARLITOS'),
	(199, 'PALMIRA'),
	(200, 'SCHICK'),
	(201, 'NOVAX'),
	(202, 'BABY GARDY'),
	(203, 'BIOTECH'),
	(204, 'ABBOTT'),
	(205, 'DELFARMA'),
	(206, 'GALBLAN'),
	(207, 'GRUPECC'),
	(208, 'LA COOPER'),
	(209, 'BIOSANA'),
	(210, 'NIVEA'),
	(211, 'COPERINSA'),
	(212, 'WET NAPS LTD'),
	(213, 'LANMAN & KEMP-BARCLAY & CO'),
	(214, 'GABBLAN'),
	(215, 'ROCHE'),
	(216, 'MONT GROUP S.A.C.'),
	(217, 'KARIFLAN S.A.C.'),
	(218, 'EDEN'),
	(219, 'ROWA'),
	(220, 'QUILLAFARMA'),
	(221, 'BONAPHARM'),
	(222, 'CAFERMA'),
	(223, 'LABOT'),
	(224, 'ANDREU'),
	(225, 'FARMEDIC'),
	(226, 'ELIFARMA'),
	(227, 'MIMI'),
	(228, 'PFISER'),
	(229, 'LAFARTE'),
	(230, 'LLECLERC'),
	(231, 'MAVER'),
	(232, 'PHARMA CHECK'),
	(233, 'ABLPHARMA'),
	(234, 'FARMACEUTICA OTARVASQ'),
	(235, 'LABOGEN'),
	(236, 'LA SANTE'),
	(237, 'LIPHARMA'),
	(238, 'JENFARMA'),
	(239, 'CKF'),
	(240, 'TERBOL'),
	(241, 'UNILENE'),
	(242, 'SHERFARMA'),
	(243, 'LAFARMED'),
	(244, 'GILSAN'),
	(245, 'FARGRUP'),
	(246, 'MEGA WE CARE'),
	(247, 'QUILLA PHARMA PERU SAC'),
	(248, 'CFALAB PERU SAC '),
	(249, 'FARMASUR S.A.C'),
	(250, 'MEGA LABS LATAM S.A'),
	(251, 'ACCORD'),
	(252, 'ZAMBON '),
	(253, 'DHG PHARMA'),
	(254, 'SANDOZ'),
	(255, 'DRONNVELS CENTRO SOCIEDAD COMERCIAL DE RESPONSABILIDAD LIMITADAD'),
	(256, 'OSPRAK '),
	(257, 'BEIERSDORF'),
	(258, 'PROCTER & GAMBLE PERU S. R .L '),
	(259, 'CRESPAL S.A '),
	(260, 'GSK '),
	(261, 'SUDAMERICA'),
	(262, 'SAVAL.CL'),
	(263, 'CARNOT'),
	(264, 'BELVS PHARMA S.A.C'),
	(265, 'SOTTCOR LABS S.A.C'),
	(266, 'VID NATUR '),
	(267, 'KALLPA LUZ '),
	(268, 'MEAD JOHNSON'),
	(269, 'HERBAL NATURAL'),
	(270, 'ZMAF'),
	(271, 'BRANDARIUM S.A.C'),
	(272, 'INTRADEVCO INDUSTRIAL S.A '),
	(273, 'DROGUERIA INVERSIONES JPS'),
	(274, 'ESPECIALIDADES OFTALMOLOGICAS S.A '),
	(275, 'DIPHASAC S.A.C'),
	(276, 'TOBAL'),
	(277, 'DROGUERIA LIPHARMA SAC'),
	(278, 'GEDEON RICHTER PERU SAC'),
	(279, 'ZMAF PACKING SAC '),
	(280, 'EMPRESA DE CONCERTACION ECON'),
	(281, 'EFICIENCIA LABORAL S.A'),
	(282, 'DROGUERIA INRETAIL PHARMA SAC'),
	(283, 'HENKEL PERUANA S.A'),
	(284, 'PUIG PERU S.A'),
	(285, 'LA CORONA PERU CORPORACION S.A.C'),
	(286, 'ZAIMELLA SAC'),
	(287, 'RIMAR IMPORT EXPORT S.A.C'),
	(288, 'DANI MED IMPORT SAC'),
	(289, 'ADVANCE SCIENTIF MEDIC SAC'),
	(290, 'PERFAR SAC'),
	(291, 'LABORATORIO TEXTILES LOS ROSALES SAC'),
	(292, 'CORPORACION LANUS SAC'),
	(293, 'RECAMIER '),
	(294, 'LUCIANA HC IMPORT SAC'),
	(295, 'SPORT CENTER SHOES SAC'),
	(296, 'ANHUI H MEDICAL '),
	(297, 'LAPE SA'),
	(298, 'LABORATORIO ESLIMEDIC SAC'),
	(299, 'DROGUERIA PERFAR SAC'),
	(300, 'DROGUERIA MONTREALIMPORTACIONES S.A.C'),
	(301, 'RB HEALTH PERU SRL'),
	(302, 'FOREST NATURE'),
	(303, 'COMPAÑIA INDUSTRIAL PAREDES'),
	(304, 'CIA CAR SAC'),
	(305, 'PLUS COSMETICA S.A'),
	(306, 'LAPE S.A'),
	(307, 'ALFY MEDICA E.I.R.L'),
	(308, 'LABORATORIO BARTON S.A.C'),
	(309, 'LABORATORIOS DENTAID S.A.S'),
	(310, 'IMPORT MEDICAL SERVICE E.I.R.L'),
	(311, 'INVERSIONES ELESNA MEDIC SAC'),
	(312, 'R&G SEGURIDAD E HIGIENE INDUSTRIAL S.A.C'),
	(313, '3M PERU S.A'),
	(314, 'BIOTEC ANDINO SAC'),
	(315, 'UNIBELL S.A.C'),
	(316, 'CORPORACION PRODESA S.A.'),
	(317, 'OQCORP S.A.C.'),
	(318, 'INDUSTRIAS PLASTICAS JOSA '),
	(319, 'ATHALIA FARMA SAC.'),
	(320, 'DROGUERIA INVERSIONES FARMACOM S.A'),
	(321, 'PHARMA-C SAC'),
	(322, 'LIDER PHARMA S.A.'),
	(323, 'CORPORACION DOLOPHARM S.A.C.'),
	(324, 'SWISS'),
	(325, 'BRISAFARMA'),
	(326, 'RUCEF S.A.C.'),
	(327, 'PROPIEL EIRL'),
	(328, 'HERBAL NATURAL S.A.C.'),
	(329, 'FORZA NATURAL E.I.R.L'),
	(330, 'SUNDANCE VITAMINAS'),
	(331, 'FARMASALUD'),
	(332, 'LABORATORIO ALYN'),
	(333, 'GO TO MARKET S.A.C.'),
	(334, 'YANBAL'),
	(335, 'ARSENIOUS PHARMACEUTICAL'),
	(336, 'INKAMART E.I.R.L'),
	(337, 'LABORATORIOS ZMAF S.A.C.'),
	(338, 'GRUPO ZUDEX S.A.C.'),
	(339, 'FERRER'),
	(340, 'PASCOE PHARMAZEUTISCHE');
/*!40000 ALTER TABLE `laboratorios` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `lotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nlote` varchar(50) DEFAULT NULL,
  `fvencimiento` date DEFAULT NULL,
  `inicial` int(11) DEFAULT NULL,
  `stock` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `lotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lotes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `meses` (
  `id` smallint(6) NOT NULL,
  `descripcion` varchar(20) DEFAULT NULL,
  `sigla` varchar(5) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `meses` DISABLE KEYS */;
INSERT INTO `meses` (`id`, `descripcion`, `sigla`) VALUES
	(1, 'ENERO', 'ENE'),
	(2, 'FEBRERO', 'FEB'),
	(3, 'MARZO', 'MAR'),
	(4, 'ABRIL', 'ABR'),
	(5, 'MAYO', 'MAY'),
	(6, 'JUNIO', 'JUN'),
	(7, 'JULIO', 'JUL'),
	(8, 'AGOSTO', 'AGO'),
	(9, 'SEPTIEMBRE', 'SEP'),
	(10, 'OCTUBRE', 'OCT'),
	(11, 'NOVIEMBRE', 'NOV'),
	(12, 'DICIEMBRE', 'DIC');
/*!40000 ALTER TABLE `meses` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `movimientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(1) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `idtmovimiento` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `observaciones` text DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `movimientos` DISABLE KEYS */;
/*!40000 ALTER TABLE `movimientos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `movimientos_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idmovimiento` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,4) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `clote` varchar(20) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `movimientos_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `movimientos_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `notas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(1) NOT NULL DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `grupo` enum('01','02') DEFAULT NULL COMMENT '01-factura, 02-boleta',
  `tcomprobante` char(3) DEFAULT NULL,
  `serie` varchar(5) DEFAULT NULL,
  `numero` int(8) DEFAULT NULL,
  `moneda` char(5) DEFAULT NULL,
  `tnota` char(2) DEFAULT NULL,
  `motivo` varchar(200) DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `hemision` time DEFAULT NULL,
  `tgravado` decimal(10,2) DEFAULT NULL,
  `tinafecto` decimal(10,2) DEFAULT NULL,
  `texonerado` decimal(10,2) DEFAULT NULL,
  `subtotal` decimal(10,2) DEFAULT NULL,
  `tigv` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idventa` int(11) DEFAULT NULL,
  `filename` varchar(50) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `has_xml` tinyint(1) DEFAULT 0,
  `has_pdf` tinyint(1) DEFAULT 0,
  `has_cdr` tinyint(1) DEFAULT 0,
  `tipo_soap` char(2) DEFAULT NULL,
  `tipo_estado` char(2) DEFAULT NULL,
  `respuesta_sunat` text DEFAULT NULL,
  `rectificar` tinyint(1) NOT NULL DEFAULT 0,
  `respuesta_rectificar` text DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `notas` DISABLE KEYS */;
/*!40000 ALTER TABLE `notas` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `notas_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idnota` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `valor` decimal(10,6) DEFAULT NULL,
  `tprecio` char(3) DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `tafectacion` int(3) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `igv` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,4) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `clote` varchar(20) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `notas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `notas_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `nventas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(1) NOT NULL DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `serie` varchar(5) DEFAULT NULL,
  `numero` int(8) DEFAULT NULL,
  `formato` tinyint(1) DEFAULT 0,
  `cliente` varchar(100) DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `hemision` time DEFAULT NULL,
  `fvencimiento` date DEFAULT NULL,
  `dscto` double DEFAULT NULL,
  `cargo` double DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `izipay` double DEFAULT NULL,
  `condicion` tinyint(1) DEFAULT 0,
  `cuotas` int(5) DEFAULT NULL,
  `mcuota` decimal(10,2) DEFAULT NULL,
  `pcuota` char(20) DEFAULT NULL,
  `fpago` date DEFAULT NULL,
  `cancelado` tinyint(1) DEFAULT 0,
  `lote` tinyint(1) DEFAULT 0,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `nventas` DISABLE KEYS */;
/*!40000 ALTER TABLE `nventas` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `nventas_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idnventa` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `dscto` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,4) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `clote` varchar(20) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `nventas_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `nventas_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `pagos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `nulo` tinyint(1) DEFAULT 0,
  `idcompra` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `idtpago` int(11) DEFAULT NULL,
  `documento` text DEFAULT NULL,
  `idarqueoc` int(11) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `pagos` DISABLE KEYS */;
/*!40000 ALTER TABLE `pagos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `periodos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `periodos` DISABLE KEYS */;
INSERT INTO `periodos` (`id`, `descripcion`) VALUES
	(1, 2025),
	(2, 2026),
	(3, 2027),
	(4, 2028);
/*!40000 ALTER TABLE `periodos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `principio_activos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `principio_activos` DISABLE KEYS */;
INSERT INTO `principio_activos` (`id`, `descripcion`) VALUES
	(1, 'AMOXICILINA 500MG + ACIDO CLAVULANICO 125MG TABLETAS'),
	(2, 'MINOCICLINA 100MG CAPSULA'),
	(9, 'AMPICILINA 500MG CAPSULAS'),
	(3, 'CEFALEXINA 500MG TAB'),
	(4, 'CEFUROXIMA 500 MG TABLETAS'),
	(5, 'AMIKACINA'),
	(6, 'AZITROMICINA 500MG TABLETAS'),
	(7, 'AMOXICILINA  500MG+AMBROXOL 30MG CAPSULAS'),
	(8, 'AMOXICILINA 250MG /5ML SUSPENSION ORAL'),
	(10, 'CIPROFLOXACINO 500MG TABLETA'),
	(11, 'ketoprofeno  100MG TABLETAS'),
	(12, 'PARACETAMOL 500 MG TABLETAS'),
	(14, 'ESOMEPRAZOL 20MG CAPSULAS'),
	(15, 'FENOFIBRATO 200MG CAPSULAS'),
	(16, 'EZETIMIBA10 + SIMVASTATINA 20MG TABLETAS'),
	(17, 'GLIBEPIRIDA 2MG +METFORMINA hcl 500MG TABLETAS'),
	(18, 'DIMENHIDRINATO  50MG TABLETAS '),
	(19, 'KETOROLACO 10MG TABLETAS '),
	(20, 'IBUPROFENO 200MG +PARACETAMOL 500MG TABLETAS'),
	(21, 'CELECOXIB 200 MG CAPSULA'),
	(22, 'ACIDO ACETILSALICILICO 100MG TABLETAS'),
	(23, 'NITROFURANTOINA 100 MG CAPSULA'),
	(24, 'SIMETICONA 100MG /ML GOTAS'),
	(25, 'ACETILCISTEINA 100 MG/5ML  SOLUCION ORAL'),
	(26, 'NIFUROXAZIDA 200 MG+ATAPULGITA  ACTIVADA 350MG TABLETAS'),
	(27, 'METRONIDAZOL 500MG +NISTATINA 100000 UI +LIDOCAINA 7MG'),
	(28, 'IBUPROFENO DE 200 MG TAB'),
	(29, 'DICLOFENACO 50MG + PARACETAMOL 500MG TABLETAS'),
	(30, 'SULFAMETOXAZOL 200MG +TRIMETOPRIMA 40MG/5ML JARABE'),
	(31, 'SIMETICONA+METILBROMURO DE HOMATROPIMA'),
	(32, 'SULCRALFATO 1G/5ML SUSPENSION'),
	(33, 'DOXICICLINA 100 MG CAPSULAS'),
	(34, 'CLARITROMICINA 500MG TABLETAS '),
	(35, 'MAGALDRATO 800MG + SIMETICONA 60MG /10ML'),
	(36, 'CEFALEXINA 250MG+AMBROXOL15MG /5ML SUSPENSION'),
	(37, 'LEVOFLOXACINO 500 MG TABLETAS '),
	(38, 'DEXKETOPROFENO TROMETAMOL 25MG TABLETAS'),
	(39, 'CIPROFLOXACINO 500MG +FENAZOPIRIDINA DE 50MG TABLETAS'),
	(40, 'CELECOXIB 200MG + ORFENADRINA 35MG TAB'),
	(41, 'SULFATO FERROSO 300 MG TABLETAS'),
	(42, 'LEVOCETIRIZINA 5MG TABLETAS'),
	(43, 'CETIRIZINA 10 MG TABLETAS'),
	(44, 'HIDROXIDO DE ALUMINIO 400+ HIDROXIDO DE MAGNESIO DE 400 MG/5ML JARABE'),
	(45, 'METAMIZOL SODICO 500MG TABLETAS'),
	(46, 'DICLOFENACO SODICO 50MG TABLETA'),
	(47, 'DICLOFENACO POTASICO'),
	(48, 'TAMSULOSINA 0.4 CAPSULA'),
	(49, 'ORFENADRINA 100 MG TABLETAS'),
	(50, 'SUBSALICILATO DE BISMUTO 87.33MG/5ML SUSPENSION'),
	(51, 'ALGINATO DE SODIO 500MG +BICARBONATO DE SODIO 267MG +CARBONATO DE CALCIO160MG /10ML '),
	(52, 'PICOSULFATO DE SODIO2.5MG +ACIDO TARTARICO 3G +ACIDO FOSFORICO 4814 MG '),
	(53, 'PICOSULFATO DE SODIO 2.5 MG/100ML SOLUCION ORAL'),
	(54, 'ENANTATO DE NORETISTERONA 50MG+VALERATO DE ESTRADIOL 5MG'),
	(55, 'ALGESTONA ACETOFENIDA  +BENZOATO DE ESTRADIOL BUTIRATO'),
	(56, 'BENCILPENICILINA PROCAINICA 1000000UI AMPOLLA'),
	(57, 'ENOXAPARINA SODICA 60MG /0.6ML AMPOLLA'),
	(58, 'DEXAMETASONA 4MG/2ML AMPOLLA'),
	(59, 'LINCOMICINA'),
	(60, 'CEFTRIAXONA  1G EN AMPOLLA'),
	(61, 'DICLOFENACO 50MG + ORFENADRINA CITRATO 75MG + PARACETAMOL 500MG TABLETAS'),
	(62, 'PIRIDOXINA CLORHIDRATO+CIANOCOBALAMINA+NICOTINAMIDA+DEXPANTENOL+ACIDO FOLICO+ACIDO OROTICO'),
	(63, 'RANITIDINA 300MG CAPSULAS'),
	(64, 'LIDOCAINA 2% INYECTABLE'),
	(66, 'NEOMICINA SULFATO500 MG + POLIMIXINA B 500000 U.I + BACITRACINA 50000U.I'),
	(67, 'BENCIDAMINA CLORHIDRATO'),
	(68, 'CLORURO DE SODIO  0.9% SOLUCION'),
	(69, 'VITAMINA E 400 UI CAPSULAS'),
	(70, 'METAMIZOL SODICO 250MG + N-BUTILBROMURO DE HIOSCINA 10MG TABLETAS'),
	(71, 'MELOXICAN 15MG  + PARACETAMOL 500MG TABLETAS'),
	(72, 'MELOXICAM 15MG TABLETAS'),
	(73, 'FLUCONAZOL 150 MG CAPSULA'),
	(74, 'METRONIDAZOL 500 MG  TABLETAS '),
	(75, 'GEMFIBROZILO 600 MG TABLETAS'),
	(76, 'ATORVASTATINA 10MG TABLETAS'),
	(77, 'PREDNISONA 5MG/5ML JARABE'),
	(78, 'PANTOPRAZOL 40 MG TABLETAS'),
	(79, 'ACIDO FOLICO 0.5MG TABLETAS'),
	(80, 'LORATADINA 10 MG TABLETAS'),
	(81, 'ERITROMICINA ESTEARATO 500MG TABLETAS'),
	(82, 'NAPROXENO SODICO 275 MG TABLETAS'),
	(83, 'ACICLOVIR 200MG  TABLETAS '),
	(84, 'DICLOXACILINA  500 MG CAPSULA '),
	(85, 'DEXTROMETORFANO 15 MG/5ML'),
	(86, 'AMBROXOL 15MG/5ML JARABE'),
	(87, 'CEFACLOR 250MG/5ML SUSPENSION'),
	(88, 'TERBINAFINA CLORHIDRATO 1% CREMA/SOLUCION'),
	(89, 'ZINC UNDECILENATO+ACIDO UNDECILENICO+CETRIMIDA+CINCOCAINACLORHIDRATO'),
	(90, 'OMEGA 3 1000MG CAPSULA'),
	(91, 'CALCIO 600MG  +VITAMINA D3 200 UI'),
	(92, 'SULFADIAZINA DE PLATA 1% CREMA /POLVO'),
	(93, 'FURAZOLIDONA 50 MG/5ML JARABE'),
	(94, 'ESPORAS DE BACILLUS CLAUSII 2 MILLARDOS /5ML'),
	(96, 'CLINDAMICINA 300MG CAPSULA'),
	(97, 'CEFALEXINA 500MG  CAP'),
	(98, 'IBUPROFENO 400 MG TAB '),
	(99, 'IBUPROFENO 400 MG CB'),
	(100, 'IBUPROFENO 800 MG TAB'),
	(101, 'IBUPROFENO 100MG /5ML SUSPENSION'),
	(102, 'CEFALEXINA 500MG+AMBROXOL 30MG CB'),
	(103, 'CELECOXIB 400 MG CAPSULA'),
	(104, 'ACETILCISTEINA 200 MG SOBRES'),
	(105, 'ACETILCISTEINA DE 600 MG SOBRES'),
	(106, 'ACICLOVIR 400 MG TABLETAS'),
	(107, 'ACICLOVIR 800MG TABLETAS'),
	(108, 'ACICLOVIR  5% CREMA '),
	(109, 'AMBROXOL 30MG/5ML JARABE'),
	(110, 'AMOXICILINA 250MG+ AMBROXOL 15 MG/5ML'),
	(111, 'AMOXICILINA 500 MG TABLETAS'),
	(112, 'AMOXICILINA 500MG CAPSULA'),
	(113, 'AMOXICILINA  250MG + ACIDO CLAVULANICO 62.5MG/5ML SUSPENSION'),
	(114, 'AMOXICILINA 875MG+ACIDO CLAVULANICO 125MG TABLETAS'),
	(115, 'CETIRIZINA 5MG /5ML JARABE'),
	(116, 'DEXAMETASONA 4ML /1ML AMPOLLA'),
	(117, 'DEXAMETASONA 4MG TABLETAS'),
	(118, 'DEXAMETASONA 0.5MG/5ML ELIXIR'),
	(119, 'DEXAMETASONA 2 MG/5ML ELIXIR'),
	(120, 'DICLOXACILINA 250 MG/5ML SUSPENSION'),
	(121, 'DICLOFENACO SODICO 100 MG TABLETAS'),
	(122, 'DICLOFENACO SODICO 75 MG/3ML AMPOLLA'),
	(123, 'ATORVASTATINA  20MG TABLETAS'),
	(124, 'ATORVASTATINA 40MG TABLETAS'),
	(125, 'AZITROMICINA 200MG/5ML SUSPENSION'),
	(126, 'CLARITROMICINA 250MG/5ML SUSPENSION'),
	(127, 'CITRATO DE CLCIO 1500 MG +VITAMINA D3 400UI'),
	(128, 'DIMENHIDRINATO 12.5 MG/ML'),
	(129, 'DIMENHIDRINATO 15MG/5ML'),
	(130, 'ESOMEPRAZOL 40MG TABLETAS'),
	(131, 'ESOMEPRAZOL 40 MG CAPSULAS'),
	(132, 'FURAZOLIDONA 100 MG TABLETAS'),
	(133, 'HIDROXIDO DE MAGNESIO 400MG/5ML SUSPENSION'),
	(134, 'HIERRO 50MG/5ML JARABE'),
	(136, 'SULFATO FERROSO 75MG/5ML'),
	(137, 'KETOPROFENO DE 150 MG CAPSULA'),
	(138, 'KETOPROFENO 200 MG CAPSULA'),
	(139, 'KETEROLACO 60MG /2ML'),
	(140, 'LEVOFLOXACINO 750MG TABLETAS'),
	(141, 'LORATADINA 5MG/5ML JARABE'),
	(142, 'SIMETICONA 80MG /ML'),
	(143, 'METAMIZOL SODICO 1G/2ML INYECTABLE'),
	(144, 'HIOSCINA N-BUTILMROMURO 10MG+PARACETAMOL 500MG TABLETAS'),
	(145, 'METRONIDAZOL 500 MG OVULOS'),
	(146, 'METRONIDAZOL 250MG/5ML JARABE'),
	(147, 'NAPROXENO SODICO 550 MG TABLETAS'),
	(148, 'NIFUROXAZIDA 200MG + ATAPULGITA ACTIVADA  500MG/5ML'),
	(149, 'PARACETAMOL 100MG/ML GOTAS'),
	(150, 'PARACETAMOL 120MG/5ML JARABE'),
	(151, 'PARACETAMOL 160MG/5ML JARABE'),
	(152, 'PARACETAMOL 1 G TABLETAS'),
	(153, 'PREDNISONA 0.5 TABLETAS '),
	(154, 'PREDNISONA 20MG TABLETAS'),
	(155, 'PREDNISONA 50MG TABLETAS'),
	(156, 'RANITIDINA 50MG/2ML INYECTABLE'),
	(157, 'SULFAMETOXAZOL400MG + TRIMETOPRIMA 80MG/5ML JARABE'),
	(158, 'SULFAMETOXAZOL 400MG + TRIMETOPRIMA 80 MG TABLETA'),
	(159, 'SULFAMETOZAXOL 800MG + TRIMETOPRIMA 160MG TABLETAS'),
	(160, 'DUTASTERIDA 0.5 MG + TAMSULOSINA 0.4 MG CAPSULAS'),
	(161, 'TERBINAFINA CLORHIDRATO 250MG TABLETAS'),
	(162, 'AMBROXOL  75MG +  CLEMBUTEROL 0.005 MG /5ML JARABE'),
	(163, 'AMBROXOL 7.5MG + CLENBUTEROL 0.005MG/ML GOTAS'),
	(164, 'LOPERAMIDA 2 MG TABLETAS'),
	(165, 'CEFALEXINA 250MG /5ML SUSPENSION'),
	(166, 'CLARITROMICINA 125MG/5ML SUSPENSION'),
	(167, 'HIERRO 50MG /ML GOTAS'),
	(168, 'HIERRO 25MG/ML GOTAS '),
	(169, 'ACIDO ACETILSALICILICO 81 MG TABLETAS'),
	(170, 'DICLOFENACO RESINATO 15MG/ML GOTAS'),
	(171, 'LEVOTIROXINA SODICA 100 MCG'),
	(172, 'METFORMINA CLORHIDRATO 850 MG TAB'),
	(173, 'BISACODILO 5MG TABLETAS'),
	(174, 'SEN POLVO 85.470 G +MENTA POLVO 8.547 G'),
	(175, 'EXTRACTO SECO DE HOJAS DE CASSIA ANGUSTIFOLIA 125MG'),
	(176, 'VIT B1 50MG+VIT B2 50MG+VIT B6 50MG +VIT B12 50MCG +NICOTINAMIDA 50 MG+ ACIDO FOLICO 100MCG + COLINA'),
	(177, 'DICLOFENACO SODICO 50MG + FENAZOPIRIDINA 100 MG CAPSULA'),
	(178, 'FOSFOLIPIDOS ESENCIALES 300MG + VIT B1 10MG + VIT B2 6MG + VIT B6 10MG + VIT B12 10MCG + NICOTINAMID'),
	(179, 'NITAZOXANIDA 500 MG TABLETAS'),
	(180, 'PINENO 31MG + CANFENO 15MG + CINEOL 3MG + FENCHONA 4MG + BORNEOL 10MG ANETOL 4MG + ACEITE DE OLIVA 3'),
	(181, 'PINENO 17MG + CANFENO 5MG + CINEOL 2MG + MENTOL 32MG +MENTONA 6MG + BORNEOL 5MG +ACEITE DE OLIVA /CA'),
	(182, 'DEXTROMETORFANO 15MG + GUAIFENESINA 100 MG/5ML'),
	(183, 'AMBROXOL CLORHIDRATO 15 MG+ CLENBUTEROL CLORHIDRATO 0.01 /5ML JARABE'),
	(184, 'DEXTROMETORFANO 5MG + GUAIFENESINA 100 MG /5ML JARABE'),
	(185, 'MAGALDRATO 400MG + SIMETICONA 30 MG /5 ML JARABE'),
	(186, 'HEDERA HELIX 35MG/5ML  JARABE'),
	(187, 'EXTRACTO DE HOJAS DE EUCALIPTUS 19.7 ML+ AMERICANA (PALTO) 19.7 '),
	(188, 'EXTRACTO DE HOJA DE EUCALIPTUS 19.7 + EXTRACTO DE HOJA DE PERSEA 19.7 +ANIS 1.2 G '),
	(189, 'CALCIO 300MG  +VIT D3 100UI + MAGNESIO 50MG +ZINC 7.5MG/5ML JARABE'),
	(190, 'FURAZOLIDONA 50MG /5ML JARABE'),
	(191, 'CLORHEXIDINA GLUCONATO  0.12% X 120 ML'),
	(192, 'CLORHEDIXINA 0.05 % SOLUCION'),
	(193, 'SULFAMETOXAZOL 200MG +TRIMETOPRIMA 40MG +GUAIFENESINA 50MG/5MLJARABE'),
	(194, 'DEXTROMETORFANO 10MG + GUAIFENESINA 100MG +CLORFENAMINA MALEATO 1.25MG/5ML JARABE'),
	(195, 'CLORFENAMINA 2MG/5ML JARABE'),
	(196, 'KETOCONAZOL 2% CREMA '),
	(197, 'DICLOFENACO SODICO 2% GEL'),
	(198, 'AQUA +GLYCERYL+OCTYLDODECANOL+PANTHENOL'),
	(199, 'CLOTRIMAZOL 1G +BETAMETASONA 0.05G +GENTAMICINA 0.1G /100G CREMA'),
	(200, 'AQUA+PANTENOL+ISOPROPYL+MYRISTATE+CETYL ALCOHOL+STEARYL ALCOHOL +++ '),
	(201, 'OXIDO DE ZINC 5G +MENTOL 0.250G +LANOLINA+ACEITE DE HIGADO BACALAO+ACEITE DE CACAHUATE+AGU DE HUMAME'),
	(202, 'CLOTRIMAZOL 1G +GENTAMICINA0.10G+ DEXAMETASONA 0.04G CREMA '),
	(203, 'DEXPANTENOL 5%'),
	(204, 'BETAMETASONA 0.05% CREMA'),
	(205, 'CLOTRIMAZOL 1% CREMA'),
	(206, 'CLOTRIMAZOL 2% CREMA'),
	(207, 'NEOMICINA +POLIMIXINA B+ BACITRACINA'),
	(208, 'CLOBETAZOL 0.05% UNGUENTO'),
	(209, 'CLOBETASOL 0.05% CREMA '),
	(210, 'POLIESTER MUCOPOLISACARIDO DEL ACIDO SULFURICO 0.445% CREMA'),
	(211, 'DICLOFENACO POTASICO 9MG/5ML JARABE'),
	(212, 'NEOMICINA SULFATO 460MG + HIDROCORTISONA 500MG + LIDOCAINA 2000MG '),
	(213, 'CLORURO DE SODIO 0.9% GOTAS'),
	(214, 'CLOZORXAZONA 250 MG + DICLOFENACO SODICO 50MG TABLETAS'),
	(215, 'IVERMECTINA 6MG/ML GOTAS'),
	(216, 'BENCIDAMINA CLORHIDRATO 0.30% SPRAY'),
	(217, 'METAMIZOL SODICO 400MG/ML GOTAS'),
	(218, 'ORFENADRINA  CITRATO 35MG + PARACETAMOL 450 MG TAB'),
	(219, 'LANSOPRAZOL 30 MG CAP'),
	(220, 'POLIENZIMA DIGESTIVA 150MG + SIMETICONA 50.00MG + DEHIDROCOLATO SODICO 30.0MG +METOCLOPRAMIDA 7.0MG'),
	(221, 'CLONIXINATO DE LISINA  125MG +PARGEVERINA CLORHIDRATO 10 MG '),
	(222, 'ACETILCISTEINA 600MG EFERVESCENTES'),
	(223, 'METFORMINA 1000MG TAB'),
	(224, 'HIOSCINA 10MG + PARACETAMOL 500 MG'),
	(225, 'POLIENZIMA DIGESTIVA 100MG + SIMETICONA 50 MG CAP'),
	(226, 'AMOXICILINA 875MG + AMBROXOL 60MG TAB'),
	(227, 'NAPROXENO SODICO 220 MG '),
	(228, 'IBUPROFENO DE 200 MG  CAP'),
	(229, 'RUSCUS ACULEATUS - LACTOBACILLUS SPOROGENES  - ACIDO ASCORBICO'),
	(230, 'ALGINATO DE SODIO 500MG + BICARBONATO DE SODIO 267MG + CARBONATO DE CALCIO 160 MG '),
	(231, 'POVIDONA YODADA 10% '),
	(232, 'POVIDONA YODADA 7.5 %'),
	(233, 'HIDROXIDO DE MAGNESIO 8G +HIDROXIDO DE ALUMINIO 8G +SIMETICONA0.6'),
	(234, 'FURAZOLIDONA DE 50MG/5 ML EN UNITOMAS'),
	(235, 'PARACETAMOL 500MG +GUAIFENESINA 200+FENILEFRINA  10MG SOBRE'),
	(236, 'PARACETAMOL 650MG + ACIDO ASCORBICO  250MG + CLORFENAMINA MALEATO 4MG+CAFEINA CITRATO 30MG +  DEXTRO'),
	(237, 'CIPROHEPTADINA +B1 +RIBOFLAVINA+ VIT B3 + VIT B5 +VIT B6 + VIT B12 + PIROFOSFATO FERRICO SOLUBLE'),
	(239, 'GLIBENCLAMIDA  5MG '),
	(240, 'LOSARTAN 50 MG TAB'),
	(241, 'SALBUTAMOL 100MCG /DOSIS '),
	(242, 'BECLOMETASONA 50 MCG /DOSIS '),
	(243, 'GASA FRACCIONADA -ANTISEPTICA 2M X 10 CM'),
	(244, 'MATERIAL MEDICO'),
	(245, 'PRODUCTO SANITARIO'),
	(246, 'DOBESILATO DE CALCIO 500 MG CAP'),
	(247, 'IRBESARTAN 150 MG X 50 TAB'),
	(248, 'COLCHICINA 0.5MG TABLETA '),
	(249, 'CARBAMAZEPINA 200MG TAB'),
	(250, 'SALBUTAMOL 4MG TAB'),
	(251, 'CLOTRIMAZOL 500 MG OVULOS '),
	(252, 'TERAZOSINA 5MG  TAB'),
	(253, 'DOXICICLINA 100 MG CAP'),
	(254, 'PIROXICAM 20 MG TAB'),
	(255, 'VALSARTAN 160 MG TAB'),
	(256, 'CLORFENAMINA MALEATO 4MG TAB'),
	(257, 'PARACETAMOL 500 MG TAB'),
	(258, 'GLICERINA 1.465G +ESTEARATO DE SODIO 0.154G +AGUA PURIFICADA C.S.P'),
	(259, 'PREGABALINA 75 MG CAP'),
	(260, 'PREGABALINA 150 MG CAP'),
	(261, 'DEFLAZACORT 30 MG TAB'),
	(262, 'CEFADROXILO 500 MG CAP'),
	(263, 'SIMETICONA 80MG / ML'),
	(264, 'ENALAPRIL 10 MG TAB'),
	(265, 'ENALAPRIL 20 MG TAB'),
	(266, 'ALOPURINOL 300 MG TAB'),
	(267, 'FENAZOPIRIDINA 100 MG TAB'),
	(268, 'ALOPURINOL 100 MG TAB'),
	(269, 'CAPTOPRIL 25 MG TAB'),
	(270, 'NOCOTINAMIDA  10MG + PANTOTENATO DE CALCIO 5MG +RIBOFLAVINA 2MG +PIRIDOXINA 2MG +CIANOCOBALAMINA 1MC'),
	(271, 'LACTULOSA 3.33G/5ML '),
	(272, 'OMEPRAZOL 20MG CAP'),
	(273, 'TIAMINA 25MG+ RIBOFLAVINA 5 FOSFATO 12MG + NICOTINAMIDA 100.00MG PIRIDOXINA 2.5MG +CIANOCOBALAMINA 0'),
	(274, 'PARACETAMOL 650 MG +CLORFENAMINA MALEATO 4MG  + DEXTROMETORFANO 20 MG '),
	(275, 'PARACETAMOL 250 MG +ACIDO ACETILSALICILICO 250MG + CAFEINA 65 MG TAB'),
	(276, 'EXTRACTO  DE ARNICA 3%+ MASA ADHESIVA 97 %'),
	(277, 'PARACETAMOL 500+CAFEINA 65 MG TAB'),
	(278, 'PARACETAMOL 325MG + DEXTROMETORFANO  10MG + FENILIFRINA 5MG CAP '),
	(279, 'EXTRACTO DE GINSENG 999MCG + VIT A 2000UI + VIT B1 1MG +VIT B2 1MG + VIT 6+ VIT B12 + VIT D +CALCIO '),
	(280, 'MAGALDRATO  800MG + SIMETICONA 40MG TAB MAS'),
	(281, 'PARACETAMOL 1 G + BICARBONATO DE SODIO 1408MG +CAFEINA DE 60MG '),
	(282, 'SILIMARINA 150MG +COMPLRJO B CAP'),
	(283, 'VIT B1 5MG + VIT B2 4MG + VIT B6 4MG + VIT B12 8MCG +VIT E 5MG +BIOTINA 5MG +++++++'),
	(284, 'ACIDO ACETILSALICILICO 325MG +SALOFENO 160MG +CAFEINA 15MG '),
	(285, 'NONOXINOL-9 150MG +EXCIPIENTES'),
	(286, 'BICARBONATO DE SODIO 2.28G +SULFATO DE MAGNESIO 0.8825 G '),
	(287, 'DICLOFENA 50 MG + VIT B1 +VIT B6 +VIT B12 '),
	(288, 'NAPROXENO SODICO 275MG + PARACETAMOL 300 MG TAB '),
	(289, 'SULFAMETOXAZOL 800MG +TRIMETOPRIMA 160MG + GUAIFENESINA 200MG TAB'),
	(290, 'CIPROFLOXACINO 500MG + FENAZOPIRIDINA 100 MG TAB'),
	(291, 'METOCLOPRAMIDA  7MG + SIMETICONA 30MG ACIDO DEHIDROCOLICO 25 MG +PANCREATINA  4 NF +CELULASA+PEPSINA'),
	(292, 'PARACETAMOL 500MG +DICLOFENACO 50MG CAP'),
	(293, 'ACEITE DE HIGADO DE BACALAO 525MG +VIT A 0.6269MG +VIT D +CALCIO +FOSFORO'),
	(294, 'PARACETAMOL 500MG +FENILIFRINA  5MG + DEXTROMETORFANO 15MG +CLORFENAMINA 2MG  TAB'),
	(295, 'VITAMINA C 1G '),
	(296, 'SUBSALICILATO DE BISMUTO 262MG TAB'),
	(297, 'FLORES DE TILO SECA   2G'),
	(298, 'PARACETAMOL 80.0MG +CLORFENIRAMINA MALEATO  1.0MG +FENILIFRINA 2.5 '),
	(299, 'PARACETAMOL 500MG CLORFENAMINA MALEATO 4 MG +FENILIFRINA 10MG '),
	(300, 'DICLOFENACO SODICO 50MG + PRIDINOL MESILATO 4 MG CAP'),
	(301, 'SACCHAROMYCES BOULARDII 250MG '),
	(302, 'PARACETAMOL 500+FENILEFRINA CLORHIDRATO 5 +CLORFENAMINA MALEATO 2MG '),
	(303, 'ACIDO ASCORBICO 1G SOB'),
	(304, 'HIDROXIDO DE ALUMINIO 582MG +HIDROXIDO DE MAGNESIO 196MG +OXETACAINA 20 MG /10ML SOBRE '),
	(305, 'GLUCOSAMINA SULFATO 1500MG +CONDROITINA SULFATO 1200MG +METILSULFONILMETANO 2400MG  SOBRE'),
	(306, 'ACIDO ACETILSALICILICO 500MG +CAFEINA 30MG '),
	(307, 'ETORICOXIB 90MG TAB'),
	(308, 'ETORICOXIB 120 MG TAB'),
	(309, 'ESPORAS DE BACILLUS CLAUSI 2000MILLONES /5ML'),
	(310, 'DICLOFENACO POTASICO 50MG +PARACETAMOL 300MG TAB'),
	(311, 'MEDROXIPROGESTERONA 150MG/'),
	(312, 'CLORURO DE MAGNESIO  1.860G +CARBONATO DE MAGNESIO0.124G +OXIDO DE ZINC 0.016G SOBRE'),
	(313, 'ACETATO DE MEDROXIPROGESTERONA Y CIPIONATO DE ESTRADIOL 25MG/5ML'),
	(314, 'TRIMAGNESIO DICITRATO ANHIDRO 1547.085MG +ZINC OXIDO 13.692MG '),
	(315, 'VIT C +ZINC +VIT D '),
	(316, 'PARACETAMOL 80MG +FENILEFRINA 2.5MG +CLORFENAMINA MALEATO 1MG TAB'),
	(317, 'PARACETAMOL 500MG +DEXTROMETORFANO  15MG +FENILEFRINA  5MG +CLORFENAMINA  2MG '),
	(318, 'VIT D +VIT C + ZINC TUBO X 10  TAB EFERVECENTES'),
	(319, 'ACETAMINOFEN 500MG + FENILEFRINA 5MG + CLORFENIRAMINA  2MG  CAP '),
	(320, 'VIT A + VIT C +VIT B1 +B2 +B6 +B9 +B12 +VIT D + VIT E '),
	(321, 'VITAMINA  C 50MG  GOMITAS'),
	(322, 'CLORFENAMINA MALEATO 10MG/ML SOL INY AMP'),
	(323, 'DHA +ACIDO FOLICO 200UG  +VIT B12 1.2UG +B6 300UG'),
	(324, 'ZINZ 11MG GOMITAS'),
	(325, 'OMEGA 3/ 6/ 9/ DHA +EPA  GOMITAS'),
	(326, 'CALCIO 100MG +VIT D 2UG  +ACIDO FOLICO 30UG GOMITAS'),
	(327, 'LINCOMICINA 600MG/2ML AMP'),
	(328, 'ACIDO ACETILSALICILICO 500 TAB'),
	(329, 'PARACETAMOL 80 MG TAB MAST'),
	(330, 'CLORHIDRATO DE DIFENHIDRAMINA 50 MG TAB '),
	(331, 'VIT A +VIT D3+ VIT E +ACIDO ASCORBICO + VIT B1 -B2 -B12 +CALCIO +ACIDO FOLICO '),
	(332, 'LACTASA 9000FCC ALU TAB'),
	(333, 'PARACETAMOL 500MG +FENILEFRINA 5MG + CLORFENAMINA MALEATO 4MG +CAFEINA DE 25 MG '),
	(334, 'GUAIFENESINA +DEXTROMETORFANO'),
	(335, 'SAL PARCIAL MEZCLADA SODICAO +CALCICA DEL  POLI+CARBOXIMETILCELULOSA +MEZCLA DE PETROLATO Y ACEITE M'),
	(336, 'MACA +LEVADURA DE CERVEZA +BAYAS DE GOJI'),
	(337, 'CLORURO DE MAGNESIO +CAMU CAMU '),
	(338, 'HOJAS DE STEVIA DESHIDRATADAS'),
	(339, 'MULTIVITAMINICO'),
	(340, 'TOALLAS HIGIENEICAS'),
	(341, 'PRESERVATIVOS'),
	(342, 'LISTERINE '),
	(343, 'ENJUAJE DENTO'),
	(344, 'PASTA DENTAL'),
	(345, 'CLINDAMICINA AMP IM 600/4ML'),
	(346, 'DICLOFENACO SODICO 75MG+ORFENADRINA 60MG'),
	(347, 'TIAMINA(vit.B1),+PIRIDOXINA(vit.B6),+CIANOCOBALAMINA(vit,B12)'),
	(348, 'CIPROFLOXACINO 0.3%+DEXAMETASONA 0.1%'),
	(349, 'POLIMIXINA B SULFATO10000UI +NEOMICINA SULFATO 10.0MG + FLUDOCORTISONA ACETATO 1.0MG + LIDOCAINA 40.'),
	(350, 'AGUA ESTERIL AMP'),
	(351, 'TOBRAMICINA 0.3% + DEXAMETASONA 0.1%'),
	(352, 'HIPROMELOSA 0.3%'),
	(353, 'FRAMICETINA 1% +DEXAMETASONA 0.1%'),
	(354, 'TETRAHIDROZOLINA CLORHIDRATO 0.05%'),
	(355, 'CARBOXIMETILCELULOSA SODICA 0.5%'),
	(356, 'CARBOXIMETILCELULOSA SODICA 1%'),
	(357, 'GENTAMICINA 0.3%'),
	(358, 'NAFAZOLINA CLORHIDRATO 0.1%'),
	(359, 'OXITETRACICLINA  0.5% + POLIMIXINA B 1000000UI '),
	(360, 'vit.B1+vit.B6,+vit.B12 Y DICLOFENACO '),
	(361, 'SILDENAFILO 100MG '),
	(362, 'SILDENAFILO 50MG '),
	(363, 'TADALAFILO 20 MG '),
	(364, 'PRUEBA DE EMBARAZO'),
	(365, 'LEVONORGESTREL 1.5MG '),
	(366, 'CIPROTERONA  ACETATO 2MG /ETINILESTRADIOL 0.035MG '),
	(367, 'NEOMICINA 35.000U.I+NISTANINA  100.000U.I + POLIMIXINA B 35.000U.I'),
	(368, 'CLOTRIMAZOL 100MG +CLINDAMICINA 100 MG '),
	(369, 'LEVONORGESTREL 0.15MG + ETHINYLESTRADIOL/ETINILESTRADIOL 0.03MG'),
	(370, 'SODIO 78.00MEQ +POTASIO 20.00MQE + CLORURO 65.00MQE+CITRATO 30.00MEQ+ZINC0.61MEQ '),
	(371, 'SODIO 45MEQ+POTASIO 20MEQ+CLORURO35MEQ+CITRATO30MEQ GLUCOSA 25G +CALORIAS100CAL'),
	(372, 'ELECTROLITOS'),
	(373, 'COLAGENO HIDROLIZADO +GLUCOSAMINA +CALCIO+CAMU CAMU +VIT C+VIT D '),
	(374, 'PAÑITOS HUMEDOS '),
	(375, 'ALCOHOL '),
	(376, 'DESINFECTANTE'),
	(377, 'MASCARILLA'),
	(378, 'FROTACION'),
	(379, 'GEL DE CABELLO '),
	(380, 'MELOXICAM 15MG/1.5ML AMP'),
	(381, 'NITAZOXANIDA 100 MG/ 5 ML'),
	(382, 'FUROSEMIDA 40MG'),
	(383, 'HIALURONATO DE SODIO  0.4%');
/*!40000 ALTER TABLE `principio_activos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `productos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` char(1) DEFAULT 'B',
  `idcategoria` int(11) DEFAULT NULL,
  `descripcion` varchar(250) DEFAULT NULL,
  `idlaboratorio` int(11) DEFAULT NULL,
  `codbarra` varchar(20) DEFAULT NULL,
  `digemid` tinyint(1) DEFAULT 0,
  `cdigemid` char(11) DEFAULT NULL,
  `mstock` int(2) DEFAULT NULL,
  `tafectacion` char(3) DEFAULT NULL,
  `compra` decimal(10,2) DEFAULT NULL,
  `venta` decimal(10,2) DEFAULT NULL,
  `factor` int(3) DEFAULT NULL,
  `pcompra` decimal(10,2) DEFAULT NULL,
  `pventa` decimal(10,2) DEFAULT NULL,
  `factorb` int(3) DEFAULT NULL,
  `pblister` decimal(10,2) DEFAULT NULL,
  `idpactivo` int(11) DEFAULT NULL,
  `idaterapeutica` int(11) DEFAULT NULL,
  `vsujeta` tinyint(1) DEFAULT NULL,
  `rsanitario` varchar(20) DEFAULT NULL,
  `estado` tinyint(1) DEFAULT NULL,
  `lote` tinyint(1) NOT NULL DEFAULT 0,
  `idubicacion` int(11) DEFAULT NULL,
  `informacion` longtext DEFAULT NULL,
  `puntos` tinyint(1) DEFAULT 0,
  `ruta` text DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `productos` DISABLE KEYS */;
/*!40000 ALTER TABLE `productos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `proveedores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tdocumento` char(1) DEFAULT NULL,
  `documento` varchar(11) NOT NULL,
  `nombres` varchar(200) DEFAULT NULL,
  `iddepartamento` char(2) DEFAULT NULL,
  `idprovincia` char(4) DEFAULT NULL,
  `iddistrito` char(6) DEFAULT NULL,
  `direccion` varchar(100) DEFAULT NULL,
  `telefono` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `proveedores` DISABLE KEYS */;
/*!40000 ALTER TABLE `proveedores` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `provincias` (
  `id` varchar(4) DEFAULT NULL,
  `descripcion` varchar(50) DEFAULT NULL,
  `iddepartamento` varchar(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `provincias` DISABLE KEYS */;
INSERT INTO `provincias` (`id`, `descripcion`, `iddepartamento`) VALUES
	('0101', 'CHACHAPOYAS', '01'),
	('0102', 'BAGUA', '01'),
	('0103', 'BONGARA', '01'),
	('0104', 'CONDORCANQUI', '01'),
	('0105', 'LUYA', '01'),
	('0106', 'RODRIGUEZ DE MENDOZA', '01'),
	('0107', 'UTCUBAMBA', '01'),
	('0201', 'HUARAZ', '02'),
	('0202', 'AIJA', '02'),
	('0203', 'ANTONIO RAYMONDI', '02'),
	('0204', 'ASUNCION', '02'),
	('0205', 'BOLOGNESI', '02'),
	('0206', 'CARHUAZ', '02'),
	('0207', 'CARLOS FERMIN FITZCARRALD', '02'),
	('0208', 'CASMA', '02'),
	('0209', 'CORONGO', '02'),
	('0210', 'HUARI', '02'),
	('0211', 'HUARMEY', '02'),
	('0212', 'HUAYLAS', '02'),
	('0213', 'MARISCAL LUZURIAGA', '02'),
	('0214', 'OCROS', '02'),
	('0215', 'PALLASCA', '02'),
	('0216', 'POMABAMBA', '02'),
	('0217', 'RECUAY', '02'),
	('0218', 'SANTA', '02'),
	('0219', 'SIHUAS', '02'),
	('0220', 'YUNGAY', '02'),
	('0301', 'ABANCAY', '03'),
	('0302', 'ANDAHUAYLAS', '03'),
	('0303', 'ANTABAMBA', '03'),
	('0304', 'AYMARAES', '03'),
	('0305', 'COTABAMBAS', '03'),
	('0306', 'CHINCHEROS', '03'),
	('0307', 'GRAU', '03'),
	('0401', 'AREQUIPA', '04'),
	('0402', 'CAMANA', '04'),
	('0403', 'CARAVELI', '04'),
	('0404', 'CASTILLA', '04'),
	('0405', 'CAYLLOMA', '04'),
	('0406', 'CONDESUYOS', '04'),
	('0407', 'ISLAY', '04'),
	('0408', 'LA UNION', '04'),
	('0501', 'HUAMANGA', '05'),
	('0502', 'CANGALLO', '05'),
	('0503', 'HUANCA SANCOS', '05'),
	('0504', 'HUANTA', '05'),
	('0505', 'LA MAR', '05'),
	('0506', 'LUCANAS', '05'),
	('0507', 'PARINACOCHAS', '05'),
	('0508', 'PAUCAR DEL SARA SARA', '05'),
	('0509', 'SUCRE', '05'),
	('0510', 'VICTOR FAFARDO', '05'),
	('0510', 'VICTOR FAJARDO', '05'),
	('0511', 'VILCAS HUAMAN', '05'),
	('0601', 'CAJAMARCA', '06'),
	('0602', 'CAJABAMBA', '06'),
	('0603', 'CELENDIN', '06'),
	('0604', 'CHOTA', '06'),
	('0605', 'CONTUMAZA', '06'),
	('0606', 'CUTERVO', '06'),
	('0607', 'HUALGAYOC', '06'),
	('0608', 'JAEN', '06'),
	('0609', 'SAN IGNACIO', '06'),
	('0610', 'SAN MARCOS', '06'),
	('0611', 'SAN MIGUEL', '06'),
	('0612', 'SAN PABLO', '06'),
	('0613', 'SANTA CRUZ', '06'),
	('0701', 'CALLAO', '07'),
	('0801', 'CUSCO', '08'),
	('0802', 'ACOMAYO', '08'),
	('0803', 'ANTA', '08'),
	('0804', 'CALCA', '08'),
	('0805', 'CANAS', '08'),
	('0806', 'CANCHIS', '08'),
	('0807', 'CHUMBIVILCAS', '08'),
	('0808', 'ESPINAR', '08'),
	('0809', 'LA CONVENCION', '08'),
	('0810', 'PARURO', '08'),
	('0811', 'PAUCARTAMBO', '08'),
	('0812', 'QUISPICANCHI', '08'),
	('0813', 'URUBAMBA', '08'),
	('0901', 'HUANCAVELICA', '09'),
	('0902', 'ACOBAMBA', '09'),
	('0903', 'ANGARAES', '09'),
	('0904', 'CASTROVIRREYNA', '09'),
	('0905', 'CHURCAMPA', '09'),
	('0906', 'HUAYTARA', '09'),
	('0907', 'TAYACAJA', '09'),
	('1001', 'HUANUCO', '10'),
	('1002', 'AMBO', '10'),
	('1003', 'DOS DE MAYO', '10'),
	('1004', 'HUACAYBAMBA', '10'),
	('1005', 'HUAMALIES', '10'),
	('1006', 'LEONCIO PRADO', '10'),
	('1007', 'MARAÑON', '10'),
	('1008', 'PACHITEA', '10'),
	('1009', 'PUERTO INCA', '10'),
	('1010', 'LAURICOCHA', '10'),
	('1011', 'YAROWILCA', '10'),
	('1101', 'ICA', '11'),
	('1102', 'CHINCHA', '11'),
	('1103', 'NAZCA', '11'),
	('1104', 'PALPA', '11'),
	('1105', 'PISCO', '11'),
	('1201', 'HUANCAYO', '12'),
	('1202', 'CONCEPCION', '12'),
	('1203', 'CHANCHAMAYO', '12'),
	('1204', 'JAUJA', '12'),
	('1205', 'JUNIN', '12'),
	('1206', 'SATIPO', '12'),
	('1207', 'TARMA', '12'),
	('1208', 'YAULI', '12'),
	('1209', 'CHUPACA', '12'),
	('1301', 'TRUJILLO', '13'),
	('1302', 'ASCOPE', '13'),
	('1303', 'BOLIVAR', '13'),
	('1304', 'CHEPEN', '13'),
	('1305', 'JULCAN', '13'),
	('1306', 'OTUZCO', '13'),
	('1307', 'PACASMAYO', '13'),
	('1308', 'PATAZ', '13'),
	('1309', 'SANCHEZ CARRION', '13'),
	('1310', 'SANTIAGO DE CHUCO', '13'),
	('1311', 'GRAN CHIMU', '13'),
	('1312', 'VIRU', '13'),
	('1401', 'CHICLAYO', '14'),
	('1402', 'FERREÑAFE', '14'),
	('1403', 'LAMBAYEQUE', '14'),
	('1501', 'LIMA', '15'),
	('1502', 'BARRANCA', '15'),
	('1503', 'CAJATAMBO', '15'),
	('1504', 'CANTA', '15'),
	('1505', 'CAÑETE', '15'),
	('1506', 'HUARAL', '15'),
	('1507', 'HUAROCHIRI', '15'),
	('1508', 'HUAURA', '15'),
	('1509', 'OYON', '15'),
	('1510', 'YAUYOS', '15'),
	('1601', 'MAYNAS', '16'),
	('1602', 'ALTO AMAZONAS', '16'),
	('1603', 'LORETO', '16'),
	('1604', 'MARISCAL RAMON CASTILLA', '16'),
	('1605', 'REQUENA', '16'),
	('1606', 'UCAYALI', '16'),
	('1607', 'DATEM DEL MARAÑON', '16'),
	('1701', 'TAMBOPATA', '17'),
	('1702', 'MANU', '17'),
	('1703', 'TAHUAMANU', '17'),
	('1801', 'MARISCAL NIETO', '18'),
	('1802', 'GENERAL SANCHEZ CERRO', '18'),
	('1803', 'ILO', '18'),
	('1901', 'PASCO', '19'),
	('1902', 'DANIEL ALCIDES CARRION', '19'),
	('1903', 'OXAPAMPA', '19'),
	('2001', 'PIURA', '20'),
	('2001', 'PUIRA', '20'),
	('2002', 'AYABACA', '20'),
	('2003', 'HUANCABAMBA', '20'),
	('2004', 'MORROPON', '20'),
	('2005', 'PAITA', '20'),
	('2006', 'SULLANA', '20'),
	('2007', 'TALARA', '20'),
	('2008', 'SECHURA', '20'),
	('2101', 'PUNO', '21'),
	('2102', 'AZANGARO', '21'),
	('2103', 'CARABAYA', '21'),
	('2104', 'CHUCUITO', '21'),
	('2105', 'EL COLLAO', '21'),
	('2106', 'HUANCANE', '21'),
	('2107', 'LAMPA', '21'),
	('2108', 'MELGAR', '21'),
	('2109', 'MOHO', '21'),
	('2110', 'SAN ANTONIO DE PUTINA', '21'),
	('2111', 'SAN ROMAN', '21'),
	('2112', 'SANDIA', '21'),
	('2113', 'YUNGUYO', '21'),
	('2201', 'MOYOBAMBA', '22'),
	('2202', 'BELLAVISTA', '22'),
	('2203', 'EL DORADO', '22'),
	('2204', 'HUALLAGA', '22'),
	('2205', 'LAMAS', '22'),
	('2206', 'MARISCAL CACERES', '22'),
	('2207', 'PICOTA', '22'),
	('2208', 'RIOJA', '22'),
	('2209', 'SAN MARTIN', '22'),
	('2210', 'TOCACHE', '22'),
	('2301', 'TACNA', '23'),
	('2302', 'CANDARAVE', '23'),
	('2303', 'JORGE BASADRE', '23'),
	('2304', 'TARATA', '23'),
	('2401', 'TUMBES', '24'),
	('2402', 'CONTRALMIRANTE VILLAR', '24'),
	('2403', 'ZARUMILLA', '24'),
	('2501', 'CORONEL PORTILLO', '25'),
	('2502', 'ATALAYA', '25'),
	('2503', 'PADRE ABAD', '25'),
	('2504', 'PURUS', '25');
/*!40000 ALTER TABLE `provincias` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `puntos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `valorp` double DEFAULT NULL,
  `caducidad` int(11) DEFAULT NULL,
  `canjep` double DEFAULT NULL,
  `canjev` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `puntos` DISABLE KEYS */;
INSERT INTO `puntos` (`id`, `valorp`, `caducidad`, `canjep`, `canjev`) VALUES
	(1, 5, 0, 200, 20);
/*!40000 ALTER TABLE `puntos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `resumenes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `fdocumento` date DEFAULT NULL,
  `tproceso` int(3) DEFAULT NULL,
  `identificador` char(20) DEFAULT NULL,
  `ticket` char(20) DEFAULT NULL,
  `filename` varchar(50) DEFAULT NULL,
  `has_xml` tinyint(1) DEFAULT 0,
  `has_cdr` tinyint(1) DEFAULT 0,
  `tipo_soap` char(2) DEFAULT NULL,
  `tipo_estado` char(2) DEFAULT NULL,
  `respuesta_sunat` text DEFAULT NULL,
  `validado` tinyint(1) DEFAULT 0,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `resumenes` DISABLE KEYS */;
/*!40000 ALTER TABLE `resumenes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `resumenes_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idresumen` int(11) DEFAULT NULL,
  `condicion` int(1) DEFAULT NULL,
  `idventa` int(11) DEFAULT NULL,
  `idnota` int(11) DEFAULT NULL,
  `motivo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `resumenes_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `resumenes_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `series` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `tcomprobante` varchar(3) DEFAULT NULL,
  `serie` char(5) DEFAULT NULL,
  `numero` int(8) unsigned zerofill DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `series` DISABLE KEYS */;
INSERT INTO `series` (`id`, `idestablecimiento`, `tcomprobante`, `serie`, `numero`) VALUES
	(1, 1, '01', 'F001', 00000001),
	(2, 1, '03', 'B001', 00000001),
	(3, 1, '07', 'FC01', 00000001),
	(4, 1, '07', 'BC01', 00000001),
	(5, 1, '99', 'NV01', 00000001),
	(6, 1, '09', 'T001', 00000001);
/*!40000 ALTER TABLE `series` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `solicitudes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `idproveedor` int(11) DEFAULT NULL,
  `proveedor` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `estado` tinyint(1) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `solicitudes` DISABLE KEYS */;
/*!40000 ALTER TABLE `solicitudes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `solicitudes_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idsolicitud` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `factor` int(3) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `solicitudes_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `solicitudes_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_afectaciones` (
  `id` char(3) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_afectaciones` DISABLE KEYS */;
INSERT INTO `tipo_afectaciones` (`id`, `descripcion`) VALUES
	('10', 'Gravado - Operación Onerosa'),
	('20', 'Exonerado - Operación Onerosa'),
	('30', 'Inafecto - Operación Onerosa');
/*!40000 ALTER TABLE `tipo_afectaciones` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_comprobantes` (
  `id` varchar(3) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  `formulario` tinyint(1) DEFAULT 0,
  `contable` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_comprobantes` DISABLE KEYS */;
INSERT INTO `tipo_comprobantes` (`id`, `descripcion`, `formulario`, `contable`) VALUES
	('01', 'Factura', 1, 1),
	('03', 'Boleta de Venta', 1, 1),
	('07', 'Nota de Crédito', 2, 1),
	('99', 'Nota de Venta', 0, 1),
	('09', 'Guía de Remisión Remitente', 0, 1);
/*!40000 ALTER TABLE `tipo_comprobantes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_credito` (
  `id` int(2) unsigned zerofill NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(200) DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_credito` DISABLE KEYS */;
INSERT INTO `tipo_credito` (`id`, `descripcion`, `estado`) VALUES
	(01, 'Anulación de la operación', 1),
	(02, 'Anulación por error en el RUC', 0),
	(03, 'Corrección por error en la descripción', 0),
	(04, 'Descuento global', 0),
	(05, 'Descuento por item', 0),
	(06, 'Devolución total', 1),
	(07, 'Devolución por item', 1),
	(08, 'Bonificación', 0),
	(09, 'Disminución en el valor', 0),
	(10, 'Otros Conceptos ', 0),
	(11, 'Ajustes de operaciones de exportación', 0),
	(12, 'Ajustes afectos al IVAP', 0);
/*!40000 ALTER TABLE `tipo_credito` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_debito` (
  `id` int(2) unsigned zerofill NOT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_debito` DISABLE KEYS */;
INSERT INTO `tipo_debito` (`id`, `descripcion`, `estado`) VALUES
	(01, 'Intereses por mora', 1),
	(02, 'Aumento en el valor', 0),
	(03, 'Penalidades/ otros conceptos', 0),
	(11, 'Ajustes de operaciones de exportación', 0),
	(12, 'Ajustes afectos al IVAP', 0);
/*!40000 ALTER TABLE `tipo_debito` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_estado` (
  `id` char(2) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  `badge` varchar(20) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_estado` DISABLE KEYS */;
INSERT INTO `tipo_estado` (`id`, `descripcion`, `badge`) VALUES
	('01', 'Registrado', 'bg-secondary'),
	('03', 'Enviado', 'bg-info'),
	('05', 'Aceptado', 'bg-success'),
	('07', 'Observado', 'bg-primary'),
	('09', 'Rechazado', 'bg-dark'),
	('11', 'Anulado', 'bg-danger'),
	('13', 'Por anular', 'bg-warning');
/*!40000 ALTER TABLE `tipo_estado` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_gastos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_gastos` DISABLE KEYS */;
INSERT INTO `tipo_gastos` (`id`, `descripcion`) VALUES
	(1, 'Planilla de Personal'),
	(2, 'Recibo Honorarios'),
	(3, 'Servicio Publico'),
	(4, 'Alquiler');
/*!40000 ALTER TABLE `tipo_gastos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_identidades` (
  `id` char(3) NOT NULL,
  `descripcion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_identidades` DISABLE KEYS */;
INSERT INTO `tipo_identidades` (`id`, `descripcion`) VALUES
	('0', 'Doc.trib.no.dom.sin.ruc'),
	('1', 'DNI'),
	('4', 'CE'),
	('6', 'RUC'),
	('7', 'PASAPORTE');
/*!40000 ALTER TABLE `tipo_identidades` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_ingresos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_ingresos` DISABLE KEYS */;
INSERT INTO `tipo_ingresos` (`id`, `descripcion`) VALUES
	(1, 'Prestamos'),
	(2, 'Ingresos Financieros'),
	(3, 'alquiler local');
/*!40000 ALTER TABLE `tipo_ingresos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_movimientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  `tipo` char(1) DEFAULT NULL,
  `estado` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_movimientos` DISABLE KEYS */;
INSERT INTO `tipo_movimientos` (`id`, `descripcion`, `tipo`, `estado`) VALUES
	(1, 'Venta nacional', 'S', 0),
	(2, 'Compra nacional', 'I', 0),
	(3, 'Consignación recibida', 'I', 0),
	(4, 'Consignación entregada', 'S', 0),
	(5, 'Devolución recibida', 'I', 0),
	(6, 'Devolución entregada', 'S', 0),
	(7, 'Bonificación', 'S', 0),
	(8, 'Premio', 'S', 0),
	(9, 'Donación', 'S', 0),
	(10, 'Salida a producción', 'S', 0),
	(11, 'Salida por transferencia entre almacenes ', 'S', 1),
	(12, 'Retiro', 'S', 1),
	(13, 'Mermas', 'S', 1),
	(14, 'Desmedros', 'S', 1),
	(15, 'Destrucción', 'S', 0),
	(16, 'Inventario inicial', 'I', 1),
	(17, 'Exportación', 'S', 0),
	(18, 'Importación', 'I', 0),
	(19, 'Ingreso de producción', 'I', 0),
	(20, 'Entrada por devolución de producción', 'I', 0),
	(21, 'Entrada por transferencia entre almacenes ', 'I', 1),
	(22, 'Entrada por identificación erronea', 'I', 1),
	(23, 'Salida por identificación erronea', 'S', 1),
	(24, 'Entrada por devolución del cliente', 'I', 0),
	(25, 'Salida por devolución al proveedor', 'S', 0),
	(26, 'Entrada para servicio de producción', 'I', 0),
	(27, 'Salida por servicio de producción', 'S', 0),
	(28, 'Ajuste por diferencia de inventario', 'S', 1),
	(29, 'Entrada de bienes en préstamo', 'I', 0),
	(30, 'Salida de bienes en préstamo', 'S', 0),
	(31, 'Entrada de bienes en custodia', 'I', 0),
	(32, 'Salida de bienes en custodia', 'S', 0),
	(33, 'Muestras médicas', 'I', 1),
	(34, 'Publicidad', 'S', 0),
	(35, 'Gastos de representación', 'S', 0),
	(36, 'Retiro para entrega a trabajadores', 'S', 1),
	(37, 'Retiro por convenio colectivo', 'S', 0),
	(38, 'Retiro por sustitución de bien siniestrado', 'S', 0),
	(39, 'Ingreso por transformacion', 'I', 0),
	(40, 'Ingreso temporal', 'I', 0),
	(41, 'Entrada por conversion de medida', 'I', 0),
	(42, 'Salida temporal', 'S', 0),
	(43, 'Salida para servicios terceros', 'S', 0),
	(44, 'Salida por conversion de medida', 'S', 0);
/*!40000 ALTER TABLE `tipo_movimientos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_pagos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_pagos` DISABLE KEYS */;
INSERT INTO `tipo_pagos` (`id`, `descripcion`) VALUES
	(1, 'Efectivo'),
	(2, 'Tarjeta de crédito'),
	(3, 'Tarjeta de débito'),
	(4, 'Yape'),
	(5, 'Deposito a Cuenta'),
	(6, 'plin');
/*!40000 ALTER TABLE `tipo_pagos` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_transportes` (
  `id` varchar(255) NOT NULL,
  `descripcion` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_transportes` DISABLE KEYS */;
INSERT INTO `tipo_transportes` (`id`, `descripcion`) VALUES
	('01', 'Transporte público'),
	('02', 'Transporte privado');
/*!40000 ALTER TABLE `tipo_transportes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_traslados` (
  `id` varchar(255) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_traslados` DISABLE KEYS */;
INSERT INTO `tipo_traslados` (`id`, `descripcion`) VALUES
	('01', 'Venta'),
	('02', 'Compra'),
	('04', 'Traslado entre establecimientos de la misma empresa'),
	('08', 'Importación'),
	('09', 'Exportación'),
	('13', 'Otros'),
	('14', 'Venta sujeta a confirmación del comprador'),
	('18', 'Traslado emisor itinerante CP'),
	('19', 'Traslado a zona primaria');
/*!40000 ALTER TABLE `tipo_traslados` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `tipo_validaciones` (
  `id` char(2) NOT NULL,
  `tipo` char(1) DEFAULT NULL,
  `descripcion` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `tipo_validaciones` DISABLE KEYS */;
INSERT INTO `tipo_validaciones` (`id`, `tipo`, `descripcion`) VALUES
	('0', 'E', 'NO EXISTE'),
	('1', 'E', 'ACEPTADO'),
	('2', 'E', 'ANULADO'),
	('3', 'E', 'AUTORIZADO'),
	('4', 'E', 'NO AUTORIZADO'),
	('00', 'R', 'ACTIVO'),
	('01', 'R', 'BAJA PROVISIONAL'),
	('02', 'R', 'BAJA PROV. POR OFICIO'),
	('03', 'R', 'SUSPENSION TEMPORAL'),
	('10', 'R', 'BAJA DEFINITIVA'),
	('11', 'R', 'BAJA DE OFICIO'),
	('22', 'R', 'INHABILITADO-VENT.UNICA'),
	('00', 'C', 'HABIDO'),
	('09', 'C', 'PENDIENTE'),
	('11', 'C', 'POR VERIFICAR'),
	('12', 'C', 'NO HABIDO'),
	('20', 'C', 'NO HALLADO');
/*!40000 ALTER TABLE `tipo_validaciones` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `transportes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idttransporte` char(2) DEFAULT NULL,
  `tdocumento` char(3) DEFAULT NULL,
  `documento` varchar(15) DEFAULT NULL,
  `nombres` varchar(200) DEFAULT NULL,
  `placa` varchar(100) DEFAULT NULL,
  `licencia` varchar(15) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `transportes` DISABLE KEYS */;
/*!40000 ALTER TABLE `transportes` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `traslados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(4) DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `idestablecimientod` int(11) DEFAULT NULL,
  `frecepcion` date DEFAULT NULL,
  `urecepcion` int(11) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `traslados` DISABLE KEYS */;
/*!40000 ALTER TABLE `traslados` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `traslados_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idtraslado` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,2) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `clote` varchar(20) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `traslados_detalle` DISABLE KEYS */;
/*!40000 ALTER TABLE `traslados_detalle` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `ubicaciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `ubicaciones` DISABLE KEYS */;
INSERT INTO `ubicaciones` (`id`, `descripcion`) VALUES
	(1, 'A-1');
/*!40000 ALTER TABLE `ubicaciones` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `nombres` varchar(200) NOT NULL,
  `usuario` varchar(100) NOT NULL,
  `clave` varchar(100) NOT NULL,
  `tipo` enum('admin','vendedor') NOT NULL DEFAULT 'vendedor',
  `idestablecimiento` text DEFAULT NULL,
  `predeterminadoe` int(11) DEFAULT NULL,
  `estado` tinyint(1) NOT NULL DEFAULT 1,
  `fregistro` datetime NOT NULL DEFAULT current_timestamp(),
  `fedicion` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `nombres` (`nombres`),
  UNIQUE KEY `usuario` (`usuario`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `usuarios` DISABLE KEYS */;
INSERT INTO `usuarios` (`id`, `nombres`, `usuario`, `clave`, `tipo`, `idestablecimiento`, `predeterminadoe`, `estado`, `fregistro`, `fedicion`) VALUES
	(1, 'Administrador sistema', 'administrador', 'joekio', 'admin', '1', 1, 1, '2022-08-29 17:03:56', '2025-02-12 18:47:58');
/*!40000 ALTER TABLE `usuarios` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `vales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `femision` date DEFAULT NULL,
  `dni` char(15) DEFAULT NULL,
  `importe` double DEFAULT NULL,
  `estado` tinyint(1) DEFAULT 1,
  `fcanje` date DEFAULT NULL,
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40000 ALTER TABLE `vales` DISABLE KEYS */;
/*!40000 ALTER TABLE `vales` ENABLE KEYS */;

CREATE TABLE IF NOT EXISTS `ventas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idestablecimiento` int(11) DEFAULT NULL,
  `nulo` tinyint(1) NOT NULL DEFAULT 0,
  `iduser` int(11) DEFAULT NULL,
  `grupo` enum('01','02') DEFAULT NULL COMMENT '01-factura, 02-boleta',
  `tcomprobante` char(3) DEFAULT NULL,
  `serie` varchar(5) DEFAULT NULL,
  `numero` int(8) DEFAULT NULL,
  `toperacion` char(5) DEFAULT NULL,
  `moneda` char(5) DEFAULT NULL,
  `idcliente` int(11) DEFAULT NULL,
  `cliente` varchar(100) DEFAULT NULL,
  `femision` date DEFAULT NULL,
  `hemision` time DEFAULT NULL,
  `fvencimiento` date DEFAULT NULL,
  `tdscto` double DEFAULT NULL,
  `tcargo` double DEFAULT NULL,
  `tgravado` decimal(10,2) DEFAULT NULL,
  `tinafecto` decimal(10,2) DEFAULT NULL,
  `texonerado` decimal(10,2) DEFAULT NULL,
  `subtotal` decimal(10,2) DEFAULT NULL,
  `tigv` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `izipay` double DEFAULT NULL,
  `condicion` tinyint(1) DEFAULT 0,
  `cuotas` int(5) DEFAULT NULL,
  `mcuota` decimal(10,2) DEFAULT NULL,
  `pcuota` char(20) DEFAULT NULL,
  `fpago` date DEFAULT NULL,
  `filename` varchar(50) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `has_xml` tinyint(1) DEFAULT 0,
  `has_pdf` tinyint(1) DEFAULT 0,
  `has_cdr` tinyint(1) DEFAULT 0,
  `tipo_soap` char(2) DEFAULT NULL,
  `tipo_estado` char(2) DEFAULT NULL,
  `respuesta_sunat` text DEFAULT NULL,
  `rectificar` tinyint(1) NOT NULL DEFAULT 0,
  `respuesta_rectificar` text DEFAULT NULL,
  `cancelado` tinyint(1) DEFAULT 0,
  `lote` tinyint(1) DEFAULT 0,
  `descuentos` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`descuentos`)),
  `fregistro` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `ventas_detalle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idventa` int(11) DEFAULT NULL,
  `idproducto` int(11) DEFAULT NULL,
  `descripcion` varchar(200) DEFAULT NULL,
  `unidad` char(5) DEFAULT NULL,
  `cantidad` double DEFAULT NULL,
  `valor` decimal(16,6) DEFAULT NULL,
  `tprecio` char(3) DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  `tafectacion` int(3) DEFAULT NULL,
  `dscto` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  `igv` decimal(10,2) DEFAULT NULL,
  `importe` decimal(10,2) DEFAULT NULL,
  `calmacen` double DEFAULT NULL,
  `palmacen` decimal(10,4) DEFAULT NULL,
  `lote` varchar(50) DEFAULT NULL,
  `clote` varchar(20) DEFAULT NULL,
  `fvencimiento` varchar(50) DEFAULT NULL,
  `descuentos` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`descuentos`)),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
